/*
 * Decompiled with CFR 0.152.
 */
package info.simplecloud.scimproxy.compliance;

import info.simplecloud.core.Group;
import info.simplecloud.core.User;
import info.simplecloud.scimproxy.compliance.CSP;
import info.simplecloud.scimproxy.compliance.ComplienceUtils;
import info.simplecloud.scimproxy.compliance.ServiceProviderConfig;
import info.simplecloud.scimproxy.compliance.enteties.Result;
import info.simplecloud.scimproxy.compliance.enteties.Statistics;
import info.simplecloud.scimproxy.compliance.enteties.TestResult;
import info.simplecloud.scimproxy.compliance.exception.CritialComplienceException;
import info.simplecloud.scimproxy.compliance.test.AttributeTest;
import info.simplecloud.scimproxy.compliance.test.ConfigTest;
import info.simplecloud.scimproxy.compliance.test.DeleteTest;
import info.simplecloud.scimproxy.compliance.test.FilterTest;
import info.simplecloud.scimproxy.compliance.test.PatchTest;
import info.simplecloud.scimproxy.compliance.test.PostTest;
import info.simplecloud.scimproxy.compliance.test.PutTest;
import info.simplecloud.scimproxy.compliance.test.ResourceCache;
import info.simplecloud.scimproxy.compliance.test.SortTest;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;

@Path(value="/test")
public class Compliance
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    @POST
    @Produces(value={"application/json"})
    public Result runTests(@FormParam(value="url") String url, @FormParam(value="username") String username, @FormParam(value="password") String password, @FormParam(value="clientId") String clientId, @FormParam(value="clientSecret") String clientSecret, @FormParam(value="authorizationServer") String authorizationServer, @FormParam(value="authorizationHeader") String authorizationHeader, @FormParam(value="authMethod") String authMethod) throws InterruptedException, ServletException {
        if (url == null || url.isEmpty()) {
            url = "http://127.0.0.1:8080";
        }
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes);
        if (!urlValidator.isValid(url)) {
            results.add(new TestResult(0, "Invalid service provider URL.", "", null));
            Statistics statistics = new Statistics();
            statistics.incFailed();
            return new Result(statistics, results);
        }
        CSP csp = new CSP();
        csp.setUrl(url);
        csp.setVersion("/v1");
        csp.setAuthentication(authMethod);
        csp.setUsername(username);
        csp.setPassword(password);
        csp.setOAuth2AuthorizationServer(authorizationServer);
        csp.setoAuth2ClientId(clientId);
        csp.setoAuth2ClientSecret(clientSecret);
        csp.setoAuth2GrantType("password");
        csp.setAuthorizationHeader(authorizationHeader);
        try {
            ConfigTest configTest = new ConfigTest();
            results.add(configTest.getConfiguration(csp));
            if ("basicAuth".equalsIgnoreCase(authMethod) && StringUtils.isEmpty((String)username) && StringUtils.isEmpty((String)password) || "oauthAuth".equalsIgnoreCase(authMethod) && StringUtils.isEmpty((String)username) && StringUtils.isEmpty((String)password) && StringUtils.isEmpty((String)authorizationServer) && StringUtils.isEmpty((String)clientId) && StringUtils.isEmpty((String)clientSecret)) {
                ServiceProviderConfig spc = csp.getSpc();
                return new Result(spc.getAuthenticationSchemes());
            }
            results.add(configTest.getSchema("Users", csp));
            results.add(configTest.getSchema("Groups", csp));
            ResourceCache<User> userCache = new ResourceCache<User>();
            ResourceCache<Group> groupCache = new ResourceCache<Group>();
            results.addAll(new PostTest(csp, userCache, groupCache).run());
            results.addAll(new FilterTest(csp, userCache, groupCache).run());
            results.addAll(new PatchTest(csp, userCache, groupCache).run());
            results.addAll(new PutTest(csp, userCache, groupCache).run());
            results.addAll(new SortTest(csp, userCache, groupCache).run());
            results.addAll(new AttributeTest(csp, userCache, groupCache).run());
            results.addAll(new DeleteTest(csp, userCache, groupCache).run());
        }
        catch (CritialComplienceException e) {
            results.add(e.getResult());
        }
        catch (Throwable e) {
            results.add(new TestResult(0, "Unknown Test", e.getMessage(), ComplienceUtils.getWire(e)));
        }
        Statistics statistics = new Statistics();
        for (TestResult result : results) {
            switch (result.getStatus()) {
                case 0: {
                    statistics.incFailed();
                    break;
                }
                case 1: {
                    statistics.incSuccess();
                    break;
                }
                case 2: {
                    statistics.incSkipped();
                }
            }
        }
        return new Result(statistics, results);
    }
}

