/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core;

import java.io.Serializable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.test.AutomationFeature;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={AutomationFeature.class})
public class TestCreateZip {
    @Inject
    CoreSession session;
    @Inject
    AutomationService as;

    @Test
    public void isServiceDeployed() {
        Assert.assertNotNull((Object)this.as);
    }

    @Test
    public void canGetZip() throws Exception {
        DocumentModel ws1 = this.session.createDocumentModel("Workspace");
        ws1.setPathInfo("/", "ws1");
        ws1 = this.session.createDocument(ws1);
        DocumentModel doc2 = this.session.createDocumentModel("File");
        doc2.setPathInfo("/ws1", "doc2");
        doc2.setPropertyValue("file:content", (Serializable)Blobs.createBlob((String)"content doc2"));
        doc2 = this.session.createDocument(doc2);
        DocumentModel doc = this.session.createDocumentModel("File");
        doc.setPathInfo("/ws1", "doc1");
        doc.setPropertyValue("file:content", (Serializable)Blobs.createBlob((String)"content doc1"));
        doc = this.session.createDocument(doc);
        this.session.save();
        OperationContext ctx = new OperationContext(this.session);
        ctx.setInput((Object)ws1);
        OperationChain chain = new OperationChain("ZipWs");
        chain.add("Document.GetChildren");
        chain.add("Document.GetBlob");
        chain.add("Blob.CreateZip").set("filename", (Object)"zip.zip");
        Blob zipBlob = (Blob)this.as.run(ctx, chain);
        Assert.assertNotNull((Object)zipBlob);
        Assert.assertTrue((String)("ZIP blob '" + zipBlob.getFilename() + "' is empty"), (zipBlob.getLength() > 0L ? 1 : 0) != 0);
    }
}

