/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.collections.ListUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.server.jaxrs.batch.Batch;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchFileEntry;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManagerComponent;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.transientstore.AbstractTransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.transientstore.test.TransientStoreFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class, TransientStoreFeature.class})
@Deploy(value={"org.nuxeo.ecm.automation.core", "org.nuxeo.ecm.platform.web.common", "org.nuxeo.ecm.webengine.core", "org.nuxeo.ecm.automation.io", "org.nuxeo.ecm.automation.server"})
public class BatchManagerFixture {
    @Inject
    protected RuntimeHarness harness;

    @Test
    public void testServiceRegistred() {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        Assert.assertNotNull((Object)bm);
    }

    @Test
    public void testTransientStoreRegistered() {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        Assert.assertNotNull((Object)bm.getTransientStore());
    }

    @Test
    public void testBatchInit() throws Exception {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        String batchId = bm.initBatch();
        Assert.assertNotNull((Object)batchId);
        Assert.assertTrue((boolean)bm.hasBatch(batchId));
        Batch batch = ((BatchManagerComponent)bm).getBatch(batchId);
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((Object)batchId, (Object)batch.getKey());
        Assert.assertEquals((long)0L, (long)bm.getTransientStore().getStorageSizeMB());
    }

    @Test(expected=NuxeoException.class)
    public void testBatchInitClientGeneratedIdNotAllowed() throws Exception {
        ((BatchManagerComponent)Framework.getService(BatchManager.class)).initBatchInternal("testBatchId");
    }

    @Test
    public void testBatchInitClientGeneratedIdAllowed() throws Exception {
        this.harness.deployContrib("org.nuxeo.ecm.automation.test.test", "test-batchmanager-client-generated-id-allowed-contrib.xml");
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        String batchId = ((BatchManagerComponent)bm).initBatchInternal("testBatchId").getKey();
        Assert.assertEquals((Object)"testBatchId", (Object)batchId);
        Assert.assertTrue((boolean)bm.hasBatch("testBatchId"));
        Batch batch = ((BatchManagerComponent)bm).getBatch("testBatchId");
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((Object)"testBatchId", (Object)batch.getKey());
        this.harness.undeployContrib("org.nuxeo.ecm.automation.test.test", "test-batchmanager-client-generated-id-allowed-contrib.xml");
    }

    @Test
    public void testAddFileStream() throws IOException {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        String batchId = bm.initBatch();
        ByteArrayInputStream is = new ByteArrayInputStream("Contenu accentu\u00e9".getBytes("UTF-8"));
        bm.addStream(batchId, "0", (InputStream)is, "Mon doc 1.txt", "text/plain");
        is = new ByteArrayInputStream("Autre contenu accentu\u00e9".getBytes("UTF-8"));
        bm.addStream(batchId, "1", (InputStream)is, "Mon doc 2.txt", "text/plain");
        Blob blob1 = bm.getBlob(batchId, "0");
        Assert.assertEquals((Object)"Mon doc 1.txt", (Object)blob1.getFilename());
        Assert.assertEquals((Object)"text/plain", (Object)blob1.getMimeType());
        Assert.assertEquals((Object)"Contenu accentu\u00e9", (Object)blob1.getString());
        Blob blob2 = bm.getBlob(batchId, "1");
        Assert.assertEquals((Object)"Mon doc 2.txt", (Object)blob2.getFilename());
        Assert.assertEquals((Object)"text/plain", (Object)blob2.getMimeType());
        Assert.assertEquals((Object)"Autre contenu accentu\u00e9", (Object)blob2.getString());
        List blobs = bm.getBlobs(batchId);
        Assert.assertEquals((long)2L, (long)blobs.size());
        Assert.assertEquals((Object)blob1, blobs.get(0));
        Assert.assertEquals((Object)blob2, blobs.get(1));
        Batch batch = ((BatchManagerComponent)bm).getBatch(batchId);
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((Object)batchId, (Object)batch.getKey());
        Assert.assertEquals((Object)blob1, (Object)batch.getBlob("0"));
        Assert.assertEquals((Object)blob2, (Object)batch.getBlob("1"));
        Assert.assertTrue((boolean)ListUtils.isEqualList((Collection)blobs, (Collection)batch.getBlobs()));
        List batchFileEntries = batch.getFileEntries();
        Assert.assertEquals((long)2L, (long)batchFileEntries.size());
        BatchFileEntry fileEntry1 = (BatchFileEntry)batchFileEntries.get(0);
        Assert.assertEquals((Object)(batchId + "_0"), (Object)fileEntry1.getKey());
        Assert.assertFalse((boolean)fileEntry1.isChunked());
        Assert.assertEquals((Object)"Mon doc 1.txt", (Object)fileEntry1.getFileName());
        Assert.assertEquals((Object)"text/plain", (Object)fileEntry1.getMimeType());
        Assert.assertEquals((long)17L, (long)fileEntry1.getFileSize());
        Assert.assertEquals((Object)blob1, (Object)fileEntry1.getBlob());
        BatchFileEntry fileEntry2 = (BatchFileEntry)batchFileEntries.get(1);
        Assert.assertEquals((Object)(batchId + "_1"), (Object)fileEntry2.getKey());
        Assert.assertFalse((boolean)fileEntry2.isChunked());
        Assert.assertEquals((Object)"Mon doc 2.txt", (Object)fileEntry2.getFileName());
        Assert.assertEquals((Object)"text/plain", (Object)fileEntry2.getMimeType());
        Assert.assertEquals((long)23L, (long)fileEntry2.getFileSize());
        Assert.assertEquals((Object)blob2, (Object)fileEntry2.getBlob());
        Assert.assertEquals((long)40L, (long)((AbstractTransientStore)bm.getTransientStore()).getStorageSize());
    }

    @Test
    public void testAddChunkStream() throws IOException {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        String batchId = bm.initBatch();
        String fileContent = "Contenu accentu\u00e9 compos\u00e9 de 3 chunks";
        String chunk1 = "Contenu accentu";
        String chunk2 = "\u00e9 compos\u00e9 de ";
        String chunk3 = "3 chunks";
        long fileSize = fileContent.getBytes().length;
        bm.addStream(batchId, "0", (InputStream)new ByteArrayInputStream(chunk1.getBytes("UTF-8")), 3, 0, "Mon doc.txt", "text/plain", fileSize);
        bm.addStream(batchId, "0", (InputStream)new ByteArrayInputStream(chunk3.getBytes("UTF-8")), 3, 2, "Mon doc.txt", "text/plain", fileSize);
        bm.addStream(batchId, "0", (InputStream)new ByteArrayInputStream(chunk2.getBytes("UTF-8")), 3, 1, "Mon doc.txt", "text/plain", fileSize);
        Blob blob = bm.getBlob(batchId, "0");
        bm.getBlob(batchId, "0");
        Assert.assertEquals((Object)"Mon doc.txt", (Object)blob.getFilename());
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertEquals((Object)fileContent, (Object)blob.getString());
        Batch batch = ((BatchManagerComponent)bm).getBatch(batchId);
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((Object)batchId, (Object)batch.getKey());
        Assert.assertEquals((Object)blob, (Object)batch.getBlob("0"));
        List batchFileEntries = batch.getFileEntries();
        Assert.assertEquals((long)1L, (long)batchFileEntries.size());
        BatchFileEntry fileEntry = (BatchFileEntry)batchFileEntries.get(0);
        Assert.assertEquals((Object)(batchId + "_0"), (Object)fileEntry.getKey());
        Assert.assertTrue((boolean)fileEntry.isChunked());
        Assert.assertEquals((Object)"Mon doc.txt", (Object)fileEntry.getFileName());
        Assert.assertEquals((Object)"text/plain", (Object)fileEntry.getMimeType());
        Assert.assertEquals((long)fileSize, (long)fileEntry.getFileSize());
        Assert.assertEquals((long)3L, (long)fileEntry.getChunkCount());
        Assert.assertEquals(Arrays.asList(0, 1, 2), (Object)fileEntry.getOrderedChunkIndexes());
        Assert.assertEquals((Object)blob, (Object)fileEntry.getBlob());
        Collection chunkEntryKeys = fileEntry.getChunkEntryKeys();
        Assert.assertEquals((long)3L, (long)chunkEntryKeys.size());
        String chunkEntryKey1 = batchId + "_0_0";
        Assert.assertTrue((boolean)chunkEntryKeys.contains(chunkEntryKey1));
        TransientStore ts = bm.getTransientStore();
        List chunkEntryBlobs = ts.getBlobs(chunkEntryKey1);
        Assert.assertEquals((long)1L, (long)chunkEntryBlobs.size());
        Blob blob1 = (Blob)chunkEntryBlobs.get(0);
        Assert.assertEquals((Object)chunk1, (Object)blob1.getString());
        Assert.assertEquals((long)15L, (long)blob1.getLength());
        String chunkEntryKey2 = batchId + "_0_1";
        Assert.assertTrue((boolean)chunkEntryKeys.contains(chunkEntryKey2));
        chunkEntryBlobs = ts.getBlobs(chunkEntryKey2);
        Assert.assertEquals((long)1L, (long)chunkEntryBlobs.size());
        Blob blob2 = (Blob)chunkEntryBlobs.get(0);
        Assert.assertEquals((Object)chunk2, (Object)blob2.getString());
        Assert.assertEquals((long)15L, (long)blob2.getLength());
        String chunkEntryKey3 = batchId + "_0_2";
        Assert.assertTrue((boolean)chunkEntryKeys.contains(chunkEntryKey3));
        chunkEntryBlobs = ts.getBlobs(chunkEntryKey3);
        Assert.assertEquals((long)1L, (long)chunkEntryBlobs.size());
        Blob blob3 = (Blob)chunkEntryBlobs.get(0);
        Assert.assertEquals((Object)chunk3, (Object)blob3.getString());
        Assert.assertEquals((long)8L, (long)blob3.getLength());
        Assert.assertEquals((long)38L, (long)((AbstractTransientStore)ts).getStorageSize());
        bm.clean(batchId);
        Assert.assertEquals((long)0L, (long)ts.getStorageSizeMB());
    }

    @Test
    public void testBatchCleanup() throws IOException {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        String batchId = bm.initBatch();
        Assert.assertNotNull((Object)batchId);
        for (int i = 0; i < 10; ++i) {
            bm.addStream(batchId, "" + i, (InputStream)new ByteArrayInputStream(("SomeContent" + i).getBytes()), i + ".txt", "text/plain");
        }
        bm.addStream(batchId, "10", (InputStream)new ByteArrayInputStream("Chunk 1 ".getBytes()), 2, 0, "chunkedFile.txt", "text/plain", 16L);
        bm.addStream(batchId, "10", (InputStream)new ByteArrayInputStream("Chunk 2 ".getBytes()), 2, 1, "chunkedFile.txt", "text/plain", 16L);
        List blobs = bm.getBlobs(batchId);
        Assert.assertNotNull((Object)blobs);
        Assert.assertEquals((long)11L, (long)blobs.size());
        Assert.assertEquals((Object)"4.txt", (Object)((Blob)blobs.get(4)).getFilename());
        Assert.assertEquals((Object)"SomeContent7", (Object)((Blob)blobs.get(7)).getString());
        Assert.assertEquals((Object)"Chunk 1 Chunk 2 ", (Object)((Blob)blobs.get(10)).getString());
        TransientStore ts = bm.getTransientStore();
        Assert.assertTrue((boolean)ts.exists(batchId));
        Assert.assertTrue((boolean)ts.exists(batchId + "_5"));
        Assert.assertTrue((boolean)ts.exists(batchId + "_10"));
        Assert.assertTrue((boolean)ts.exists(batchId + "_10_0"));
        Assert.assertTrue((boolean)ts.exists(batchId + "_10_1"));
        FileBlob fileBlob = (FileBlob)blobs.get(9);
        File tmpFile = fileBlob.getFile();
        Assert.assertNotNull((Object)tmpFile);
        Assert.assertTrue((boolean)tmpFile.exists());
        FileBlob chunkedFileBlob = (FileBlob)blobs.get(10);
        File tmpChunkedFile = chunkedFileBlob.getFile();
        Assert.assertNotNull((Object)tmpChunkedFile);
        Assert.assertTrue((boolean)tmpChunkedFile.exists());
        bm.clean(batchId);
        Assert.assertFalse((boolean)ts.exists(batchId));
        Assert.assertFalse((boolean)ts.exists(batchId + "_5"));
        Assert.assertFalse((boolean)ts.exists(batchId + "_10"));
        Assert.assertFalse((boolean)ts.exists(batchId + "_10_0"));
        Assert.assertFalse((boolean)ts.exists(batchId + "_10_1"));
        Assert.assertFalse((boolean)tmpChunkedFile.exists());
        Assert.assertFalse((boolean)tmpFile.exists());
        Assert.assertEquals((long)0L, (long)ts.getStorageSizeMB());
    }

    @Test
    public void testBatchConcurrency() throws Exception {
        final BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        int nbBatches = 100;
        final String[] batchIds = new String[nbBatches];
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(5, 5, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(nbBatches + 1));
        int i = 0;
        while (i < nbBatches) {
            final int batchIndex = i++;
            tpe.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        String batchId = bm.initBatch();
                        bm.addStream(batchId, "0", (InputStream)new ByteArrayInputStream(("SomeContent_" + batchId).getBytes(StandardCharsets.UTF_8)), "MyBatchFile.txt", "text/plain");
                        batchIds[batchIndex] = batchId;
                    }
                    catch (IOException e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
            });
        }
        tpe.shutdown();
        boolean finish = tpe.awaitTermination(20L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"timeout", (boolean)finish);
        for (String batchId : batchIds) {
            Assert.assertNotNull((Object)batchId);
        }
        int nbDigits = (int)(Math.log10(nbBatches) + 1.0);
        int divisor = nbBatches;
        for (int i2 = 0; i2 < nbDigits; ++i2) {
            int batchIndex = nbBatches / divisor - 1;
            String batchId = batchIds[batchIndex];
            Blob blob = bm.getBlob(batchId, "0");
            Assert.assertNotNull((Object)blob);
            Assert.assertEquals((Object)"MyBatchFile.txt", (Object)blob.getFilename());
            Assert.assertEquals((Object)("SomeContent_" + batchId), (Object)blob.getString());
            divisor /= 10;
        }
        TransientStore ts = bm.getTransientStore();
        Assert.assertTrue((((AbstractTransientStore)ts).getStorageSize() > (long)(12 * nbBatches) ? 1 : 0) != 0);
        for (String batchId : batchIds) {
            bm.clean(batchId);
        }
        Assert.assertEquals((long)ts.getStorageSizeMB(), (long)0L);
    }

    @Test
    public void testFileConcurrency() throws Exception {
        final BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        final String batchId = bm.initBatch();
        int nbFiles = 100;
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(5, 5, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(nbFiles + 1));
        for (int i = 0; i < nbFiles; ++i) {
            final String fileIndex = String.valueOf(i);
            tpe.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        bm.addStream(batchId, fileIndex, (InputStream)new ByteArrayInputStream(("SomeContent_" + fileIndex).getBytes(StandardCharsets.UTF_8)), fileIndex + ".txt", "text/plain");
                    }
                    catch (IOException e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
            });
        }
        tpe.shutdown();
        boolean finish = tpe.awaitTermination(20L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"timeout", (boolean)finish);
        List blobs = bm.getBlobs(batchId);
        Assert.assertEquals((long)nbFiles, (long)blobs.size());
        int nbDigits = (int)(Math.log10(nbFiles) + 1.0);
        int divisor = nbFiles;
        for (int i = 0; i < nbDigits; ++i) {
            int fileIndex = nbFiles / divisor - 1;
            Assert.assertEquals((Object)(fileIndex + ".txt"), (Object)((Blob)blobs.get(fileIndex)).getFilename());
            Assert.assertEquals((Object)("SomeContent_" + fileIndex), (Object)((Blob)blobs.get(fileIndex)).getString());
            divisor /= 10;
        }
        TransientStore ts = bm.getTransientStore();
        Assert.assertTrue((((AbstractTransientStore)ts).getStorageSize() > (long)(12 * nbFiles) ? 1 : 0) != 0);
        bm.clean(batchId);
        Assert.assertEquals((long)ts.getStorageSizeMB(), (long)0L);
    }

    @Test
    public void testChunkConcurrency() throws Exception {
        final BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        final String batchId = bm.initBatch();
        final int nbChunks = 100;
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(5, 5, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(nbChunks + 1));
        int i = 0;
        while (i < nbChunks) {
            final int chunkIndex = i++;
            tpe.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        bm.addStream(batchId, "0", (InputStream)new ByteArrayInputStream(("SomeChunkContent_" + chunkIndex + " ").getBytes(StandardCharsets.UTF_8)), nbChunks, chunkIndex, "MyChunkedFile.txt", "text/plain", 0L);
                    }
                    catch (IOException e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
            });
        }
        tpe.shutdown();
        boolean finish = tpe.awaitTermination(20L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"timeout", (boolean)finish);
        Blob blob = bm.getBlob(batchId, "0");
        Assert.assertNotNull((Object)blob);
        int nbOccurrences = 0;
        Pattern p = Pattern.compile("SomeChunkContent_");
        Matcher m = p.matcher(blob.getString());
        while (m.find()) {
            ++nbOccurrences;
        }
        Assert.assertEquals((long)nbChunks, (long)nbOccurrences);
        TransientStore ts = bm.getTransientStore();
        Assert.assertTrue((((AbstractTransientStore)ts).getStorageSize() > (long)(17 * nbChunks) ? 1 : 0) != 0);
        bm.clean(batchId);
        Assert.assertEquals((long)ts.getStorageSizeMB(), (long)0L);
    }
}

