/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.automation.test.EmbeddedAutomationServerFeature;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.Jetty;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.nuxeo.transientstore.test.TransientStoreFeature;

@Deprecated
@RunWith(value=FeaturesRunner.class)
@Features(value={TransientStoreFeature.class, EmbeddedAutomationServerFeature.class})
@Jetty(port=18080)
public class TestBatchResource {
    @Inject
    protected RuntimeHarness harness;
    @Inject
    protected CoreSession session;
    @Inject
    protected Session clientSession;
    protected ObjectMapper mapper;
    protected String uploadURL = "http://localhost:18080/automation/batch/upload";
    protected String fileIndex = "0";
    protected String fileName = "New file.txt";
    protected String mimeType = "text/plain";
    protected String content = "This is the content of a new file.";

    @Before
    public void doBefore() throws Exception {
        this.mapper = new ObjectMapper();
    }

    @Test(expected=NuxeoException.class)
    public void testBatchUploadClientGeneratedIdNotAllowed() throws IOException {
        String batchId = UUID.randomUUID().toString();
        this.batchUpload(this.uploadURL, batchId, this.fileIndex, this.fileName, this.mimeType, this.content);
    }

    @Test
    public void testBatchUploadClientGeneratedIdAllowed() throws Exception {
        this.harness.deployContrib("org.nuxeo.ecm.automation.test.test", "test-batchmanager-client-generated-id-allowed-contrib.xml");
        String batchId = UUID.randomUUID().toString();
        String responseBatchId = this.batchUpload(this.uploadURL, batchId, this.fileIndex, this.fileName, this.mimeType, this.content);
        Assert.assertEquals((Object)batchId, (Object)responseBatchId);
        this.harness.undeployContrib("org.nuxeo.ecm.automation.test.test", "test-batchmanager-client-generated-id-allowed-contrib.xml");
    }

    @Test
    public void testBatchUploadServerGeneratedId() throws IOException {
        String batchId = ((BatchManager)Framework.getService(BatchManager.class)).initBatch();
        Assert.assertEquals((Object)batchId, (Object)this.batchUpload(this.uploadURL, batchId, this.fileIndex, this.fileName, this.mimeType, this.content));
    }

    @Test
    public void testBatchUpload() throws Exception {
        DocumentModel file = this.session.createDocumentModel("/", "testFile", "File");
        file = this.session.createDocument(file);
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        String executeURL = "http://localhost:18080/automation/batch/execute";
        String docPath = file.getPathAsString();
        String batchId = this.batchUpload(this.uploadURL, null, this.fileIndex, this.fileName, this.mimeType, this.content);
        this.batchExecuteAttachBlob(executeURL, batchId, this.fileIndex, docPath);
        Blob blob = (Blob)this.clientSession.newRequest("Document.GetBlob").setInput((Object)file.getPathAsString()).execute();
        Assert.assertNotNull((Object)blob);
        String blobString = new String(IOUtils.toByteArray((InputStream)blob.getStream()));
        Assert.assertEquals((Object)"This is the content of a new file.", (Object)blobString);
    }

    /*
     * Loose catch block
     */
    protected String batchUpload(String urlStr, String batchId, String fileIndex, String fileName, String mimeType, String content) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            byte[] bytes = content.getBytes();
            String fileSize = Integer.toString(bytes.length);
            conn.setRequestProperty("Authorization", this.getAuthHeader("Administrator", "Administrator"));
            if (batchId != null) {
                conn.setRequestProperty("X-Batch-Id", batchId);
            }
            conn.setRequestProperty("X-File-Idx", fileIndex);
            conn.setRequestProperty("X-File-Name", fileName);
            conn.setRequestProperty("X-File-Size", fileSize);
            conn.setRequestProperty("X-File-Type", mimeType);
            conn.setRequestProperty("Content-Type", "application/octet-stream");
            conn.setRequestProperty("Content-Length", fileSize);
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                IOUtils.write((String)content, (OutputStream)os);
            }
            if (conn.getResponseCode() != 200) {
                throw new NuxeoException("Batch upload request failed with status code " + conn.getResponseCode());
            }
            var12_12 = null;
            try (InputStream is = conn.getInputStream();){
                JsonNode node = this.mapper.readTree(is);
                String string = node.get("batchId").getValueAsText();
                return string;
            }
            catch (Throwable throwable) {
                var12_12 = throwable;
                throw throwable;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            conn.disconnect();
        }
    }

    /*
     * Loose catch block
     */
    protected boolean batchExecuteAttachBlob(String urlStr, String batchId, String fileIndex, String docPath) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            conn.setRequestProperty("Authorization", this.getAuthHeader("Administrator", "Administrator"));
            conn.setRequestProperty("Content-Type", "application/json+nxrequest");
            conn.setRequestProperty("Accept", "application/json+nxentity, */*");
            conn.setRequestProperty("X-NXDocumentProperties", "*");
            conn.setDoOutput(true);
            String JSONData = String.format("{\"params\": {\"operationId\": \"%s\", \"batchId\": \"%s\", \"fileIdx\": \"%s\", \"document\": \"%s\"}}", "Blob.Attach", batchId, fileIndex, docPath);
            try (OutputStream os = conn.getOutputStream();){
                IOUtils.write((String)JSONData, (OutputStream)os);
            }
            var9_9 = null;
            try (InputStream is = conn.getInputStream();){
                IOUtils.toByteArray((InputStream)is);
                boolean bl = conn.getResponseCode() == 200;
                return bl;
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            conn.disconnect();
        }
    }

    protected String getAuthHeader(String userName, String password) {
        return "Basic " + new String(Base64.encodeBase64((byte[])(userName + ":" + password).getBytes()));
    }
}

