/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.number.IsCloseTo;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.RemoteException;
import org.nuxeo.ecm.automation.client.RemoteThrowable;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.BusinessService;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshalling;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.PojoMarshaller;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.DateUtils;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.IdRef;
import org.nuxeo.ecm.automation.client.model.OperationDocumentation;
import org.nuxeo.ecm.automation.client.model.PaginableDocuments;
import org.nuxeo.ecm.automation.client.model.PathRef;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodec;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodecService;
import org.nuxeo.ecm.automation.server.AutomationServerComponent;
import org.nuxeo.ecm.automation.server.test.AbstractAutomationClientTest;
import org.nuxeo.ecm.automation.server.test.MyObject;
import org.nuxeo.ecm.automation.server.test.MyObjectCodec;
import org.nuxeo.ecm.automation.server.test.MyObjectMarshaller;
import org.nuxeo.ecm.automation.server.test.MyObjectOperation;
import org.nuxeo.ecm.automation.server.test.TestDataCapsule;
import org.nuxeo.ecm.automation.server.test.business.client.BusinessBean;
import org.nuxeo.ecm.automation.server.test.json.JSONOperationWithArrays;
import org.nuxeo.ecm.automation.server.test.json.POJOObject;
import org.nuxeo.ecm.automation.server.test.json.SimplePojoObjectMarshaller;
import org.nuxeo.ecm.automation.test.EmbeddedAutomationServerFeature;
import org.nuxeo.ecm.automation.test.helpers.ExceptionTest;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.platform.audit.AuditFeature;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.Jetty;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Deploy(value={"org.nuxeo.ecm.platform.url.api", "org.nuxeo.ecm.platform.url.core", "org.nuxeo.ecm.platform.types.api", "org.nuxeo.ecm.platform.types.core", "org.nuxeo.ecm.platform.notification.core:OSGI-INF/NotificationService.xml", "org.nuxeo.ecm.automation.test"})
@LocalDeploy(value={"org.nuxeo.ecm.automation.test:test-bindings.xml", "org.nuxeo.ecm.automation.test:test-mvalues.xml", "org.nuxeo.ecm.automation.test:operation-contrib.xml"})
@Features(value={EmbeddedAutomationServerFeature.class, AuditFeature.class})
@Jetty(port=18080)
@RepositoryConfig(cleanup=Granularity.METHOD)
public class EmbeddedAutomationClientTest
extends AbstractAutomationClientTest {
    protected static String[] attachments = new String[]{"att1", "att2", "att3"};
    @Inject
    UserManager userManager;

    @BeforeClass
    public static void setupCodecs() throws Exception {
        ((ObjectCodecService)Framework.getLocalService(ObjectCodecService.class)).addCodec((ObjectCodec)new MyObjectCodec());
        ((AutomationService)Framework.getLocalService(AutomationService.class)).putOperation(MyObjectOperation.class);
        ComponentInstance componentInstance = Framework.getRuntime().getComponentInstance("org.nuxeo.ecm.automation.server.AutomationServer");
        AutomationServerComponent automationServerComponent = (AutomationServerComponent)componentInstance.getInstance();
        automationServerComponent.applicationStarted((ComponentContext)componentInstance);
    }

    public void setupComplexDocuments() throws Exception {
        Document root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
        this.createDocumentWithComplexProperties(root);
    }

    public void createDocumentWithComplexProperties(Document root) throws Exception {
        HashMap<String, Object> creationProps = new HashMap<String, Object>();
        creationProps.put("ds:tableName", "MyTable");
        creationProps.put("ds:attachments", attachments);
        File fieldAsJsonFile = FileUtils.getResourceFileFromContext((String)"creationFields.json");
        Assert.assertNotNull((Object)fieldAsJsonFile);
        String fieldsDataAsJSon = FileUtils.readFile((File)fieldAsJsonFile);
        fieldsDataAsJSon = fieldsDataAsJSon.replaceAll("\n", "");
        fieldsDataAsJSon = fieldsDataAsJSon.replaceAll("\r", "");
        creationProps.put("ds:fields", fieldsDataAsJSon);
        creationProps.put("dc:title", "testDoc");
        this.session.newRequest("Document.Create").setInput((Object)root).set("type", (Object)"DataSet").set("name", (Object)"testDoc").set("properties", (Object)new PropertyMap(creationProps).toString()).execute();
    }

    @BeforeClass
    public static void addDataCapsuleOperation() throws OperationException {
        ((AutomationService)Framework.getLocalService(AutomationService.class)).putOperation(TestDataCapsule.class);
    }

    @Test
    public void testBlobSummaries() throws Exception {
        Blob blob = (Blob)this.session.newRequest("TestDataCapsule").execute();
        Assert.assertEquals((Object)"TestDataCapsule - application/json - 25 B", (Object)blob.toString());
    }

    @Test
    public void testCodecs() throws Exception {
        JsonMarshalling.addMarshaller((JsonMarshaller)new MyObjectMarshaller());
        MyObject msg = (MyObject)this.session.newRequest("Operation.MyObjectTest").execute();
        Assert.assertEquals((Object)"hello world", (Object)msg.getMessage());
    }

    @Test
    public void testMultiValued() throws Exception {
        Document root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
        Document note = (Document)this.session.newRequest("Document.Create").setHeader("X-NXDocumentProperties", "*").setInput((Object)root).set("type", (Object)"MV").set("name", (Object)"pfff").set("properties", (Object)"mv:sl=s1,s2\nmv:ss=s1,s2\nmv:bl=true,false\nmv:b=true\n").execute();
        this.checkHasCorrectMultiValues(note);
        PaginableDocuments docs = (PaginableDocuments)this.session.newRequest("Repository.PageProvider").setHeader("X-NXDocumentProperties", "*").set("query", (Object)"SELECT * from MV").set("queryParams", (Object)new String[0]).set("pageSize", (Object)2).execute();
        Assert.assertThat((Object)docs, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)docs.size(), (Matcher)Matchers.is((Object)1));
        this.checkHasCorrectMultiValues(docs.get(0));
    }

    private void checkHasCorrectMultiValues(Document note) {
        Assert.assertThat((Object)note, (Matcher)Matchers.notNullValue());
        PropertyMap properties = note.getProperties();
        Assert.assertThat((Object)properties, (Matcher)Matchers.notNullValue());
        PropertyList sl = properties.getList("mv:sl");
        Assert.assertThat((Object)sl, (Matcher)Matchers.notNullValue());
        List slValues = sl.list();
        Assert.assertThat((Object)slValues, (Matcher)Matchers.hasItem((Object)"s1"));
        Assert.assertThat((Object)slValues, (Matcher)Matchers.hasItem((Object)"s2"));
        PropertyList ss = properties.getList("mv:ss");
        Assert.assertThat((Object)ss, (Matcher)Matchers.notNullValue());
        List ssValues = ss.list();
        Assert.assertThat((Object)ssValues, (Matcher)Matchers.hasItem((Object)"s1"));
        Assert.assertThat((Object)ssValues, (Matcher)Matchers.hasItem((Object)"s2"));
        Boolean b = properties.getBoolean("mv:b");
        Assert.assertThat((Object)b, (Matcher)Matchers.is((Object)true));
        PropertyList bl = properties.getList("mv:bl");
        Assert.assertThat((Object)bl, (Matcher)Matchers.notNullValue());
        List blValues = bl.list();
        Assert.assertThat((Object)blValues, (Matcher)Matchers.hasItem((Object)"true"));
        Assert.assertThat((Object)blValues, (Matcher)Matchers.hasItem((Object)"false"));
        Assert.assertThat((Object)bl.getBoolean(0), (Matcher)Matchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)bl.getBoolean(1), (Matcher)Matchers.is((Object)Boolean.FALSE));
    }

    @Test
    public void testChain() throws Exception {
        OperationDocumentation opd = this.session.getOperation("testchain");
        Assert.assertNotNull((Object)opd);
        Document root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
        Document folder = (Document)this.session.newRequest("Document.Create").setInput((Object)root).set("type", (Object)"Folder").set("name", (Object)"chainTest").execute();
        Document doc = (Document)this.session.newRequest("testchain").setInput((Object)folder).execute();
        Assert.assertEquals((Object)"/chainTest/chain.doc", (Object)doc.getPath());
        Assert.assertEquals((Object)"Note", (Object)doc.getType());
        doc = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)doc).execute();
        Assert.assertEquals((Object)"/chainTest/chain.doc", (Object)doc.getPath());
        Assert.assertEquals((Object)"Note", (Object)doc.getType());
    }

    @Test
    public void testRemoteChain() throws Exception {
        OperationDocumentation opd = this.session.getOperation("principals");
        Assert.assertNotNull((Object)opd);
        Document doc = (Document)this.session.newRequest("principals").setInput((Object)DocRef.newRef((String)"/")).execute();
        Assert.assertNotNull((Object)doc);
    }

    @Test(expected=RemoteException.class)
    public void testTxTimeout() throws Exception {
        this.session.newRequest("WaitForTxTimeout").setHeader("Nuxeo-Transaction-Timeout", "1").execute();
    }

    @Test
    public void testBaseInputAndReturnValues() throws Exception {
        Object r = this.session.newRequest("TestReturn").setInput((Object)Boolean.TRUE).execute();
        Assert.assertThat((Object)((Boolean)r), (Matcher)Matchers.is((Object)Boolean.TRUE));
        r = this.session.newRequest("TestReturn").setInput((Object)"hello").execute();
        Assert.assertThat((Object)((String)r), (Matcher)Matchers.is((Object)"hello"));
        r = this.session.newRequest("TestReturn").setInput((Object)1).execute();
        Assert.assertThat((Object)((Number)r).intValue(), (Matcher)Matchers.is((Object)1));
        r = this.session.newRequest("TestReturn").setInput((Object)1000000000000000000L).execute();
        Assert.assertThat((Object)((Number)r).longValue(), (Matcher)Matchers.is((Object)1000000000000000000L));
        r = this.session.newRequest("TestReturn").setInput((Object)1.1).execute();
        Assert.assertThat((Object)((Number)r).doubleValue(), (Matcher)IsCloseTo.closeTo((double)1.1, (double)0.1));
        Date now = DateUtils.parseDate((String)DateUtils.formatDate((Date)new Date(0L)));
        r = this.session.newRequest("TestReturn").setInput((Object)now).execute();
        Assert.assertThat((Object)((Date)r), (Matcher)Matchers.is((Object)now));
    }

    @Test
    public void testNumberParamAdapters() throws Exception {
        Long longParam = 500L;
        Object r = this.session.newRequest("TestNumberParamAdaptersOperation").set("longParam", (Object)longParam).execute();
        Assert.assertThat((Object)((Integer)r), (Matcher)Matchers.is((Object)500));
        Integer integerParam = 500;
        r = this.session.newRequest("TestNumberParamAdaptersOperation").set("longParam", (Object)integerParam).execute();
        Assert.assertThat((Object)((Integer)r), (Matcher)Matchers.is((Object)500));
    }

    @Test
    public void testChainRollback() throws Exception {
        Document root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
        Document doc = (Document)this.session.newRequest("exitNoRollback").setInput((Object)root).execute();
        Assert.assertEquals((Object)"/test-exit1", (Object)doc.getPath());
        Document note = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/test-exit1").execute();
        Assert.assertEquals((Object)doc.getPath(), (Object)note.getPath());
        doc = (Document)this.session.newRequest("exitRollback").setInput((Object)root).execute();
        Assert.assertEquals((Object)"/test-exit2", (Object)doc.getPath());
        try {
            note = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/test-exit2").execute();
            Assert.fail((String)"document should not exist");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        try {
            doc = (Document)this.session.newRequest("exitError").setInput((Object)root).execute();
            Assert.fail((String)"expected error");
        }
        catch (RemoteException t) {
            Assert.assertTrue((boolean)t.getRemoteStackTrace().contains("termination error"));
        }
        try {
            note = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/test-exit3").execute();
            Assert.fail((String)"document should not exist");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Test
    public void testSendMail() throws Exception {
        File file = new File(Environment.getDefault().getConfig(), "mail.properties");
        file.getParentFile().mkdirs();
        ArrayList<String> mailProperties = new ArrayList<String>();
        mailProperties.add(String.format("mail.smtp.host = %s", "badHostName"));
        mailProperties.add(String.format("mail.smtp.port = %s", "2525"));
        mailProperties.add(String.format("mail.smtp.connectiontimeout = %s", "1000"));
        mailProperties.add(String.format("mail.smtp.timeout = %s", "1000"));
        FileUtils.writeLines((File)file, mailProperties);
        Document rootDoc = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
        Assert.assertNotNull((Object)rootDoc);
        OperationRequest operationRequest = this.session.newRequest("Document.Mail").setInput((Object)rootDoc).set("from", (Object)"sender@nuxeo.com").set("to", (Object)"recipient@nuxeo.com").set("subject", (Object)"My test mail").set("message", (Object)"The message content.");
        try {
            operationRequest.execute();
            Assert.fail((String)"Call to SendMail operation should have thrown a RemoteException since the SMTP server is not reachable");
        }
        catch (RemoteException re) {
            Assert.assertEquals((Object)"Failed to invoke operation: Document.Mail", (Object)re.getMessage());
        }
        Object result = operationRequest.set("rollbackOnError", (Object)"false").execute();
        Assert.assertNotNull((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthenticationAndAuthorizationErrors() throws Exception {
        String testUserName = "automation-test-user";
        NuxeoPrincipal principal = this.userManager.getPrincipal(testUserName);
        if (principal != null) {
            this.userManager.deleteUser(testUserName);
        }
        try {
            DocumentModel user = this.userManager.getBareUserModel();
            user.setPropertyValue("user:username", (Serializable)((Object)testUserName));
            user.setPropertyValue("user:password", (Serializable)((Object)"secret"));
            this.userManager.createUser(user);
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
            try {
                this.client.getSession(testUserName, "badpassword");
                Assert.fail((String)"session should not have be created with bad password");
            }
            catch (RemoteException e) {
                Assert.assertEquals((long)e.getStatus(), (long)401L);
            }
            Session userSession = this.client.getSession(testUserName, "secret");
            try {
                userSession.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
                Assert.fail((String)"test user should not have read access to the root document");
            }
            catch (RemoteException e) {
                Assert.assertEquals((long)e.getStatus(), (long)403L);
            }
        }
        finally {
            this.userManager.deleteUser(testUserName);
        }
    }

    @Test
    public void sampleAutomationRemoteAccessWithComplexDocuments() throws Exception {
        this.setupComplexDocuments();
        Document testDoc = (Document)this.session.newRequest("Document.GetChild").setInput((Object)new PathRef("/")).set("name", (Object)"testDoc").execute();
        Assert.assertNotNull((Object)testDoc);
        Assert.assertEquals((Object)"testDoc", (Object)testDoc.getTitle());
        Assert.assertEquals((Object)"testDoc", (Object)testDoc.getProperties().get("dc:title"));
        Assert.assertNull((Object)testDoc.getProperties().get("ds:tableName"));
        Assert.assertNull((Object)testDoc.getProperties().get("ds:fields"));
        testDoc = (Document)this.session.newRequest("Repository.GetDocument").setHeader("X-NXDocumentProperties", "*").set("value", (Object)"/testDoc").execute();
        Assert.assertNotNull((Object)testDoc);
        Assert.assertEquals((Object)"testDoc", (Object)testDoc.getTitle());
        Assert.assertEquals((Object)"MyTable", (Object)testDoc.getProperties().get("ds:tableName"));
        Assert.assertNotNull((Object)testDoc.getProperties().get("ds:fields"));
        PropertyList dbFields = testDoc.getProperties().getList("ds:fields");
        Assert.assertEquals((long)5L, (long)dbFields.size());
        PropertyMap dbField0 = dbFields.getMap(0);
        Assert.assertNotNull((Object)dbField0);
        Assert.assertEquals((Object)"field0", (Object)dbField0.getString("name"));
        Assert.assertEquals((Object)"Decision", (Object)dbField0.getList("roles").getString(0));
        Assert.assertEquals((Object)"Score", (Object)dbField0.getList("roles").getString(1));
        HashMap<String, String> updateProps = new HashMap<String, String>();
        updateProps.put("ds:tableName", "newTableName");
        updateProps.put("ds:attachments", "new1,new2,new3,new4");
        File fieldAsJsonFile = FileUtils.getResourceFileFromContext((String)"updateFields.json");
        Assert.assertNotNull((Object)fieldAsJsonFile);
        String fieldsDataAsJSon = FileUtils.readFile((File)fieldAsJsonFile);
        fieldsDataAsJSon = fieldsDataAsJSon.replaceAll("\n", "");
        fieldsDataAsJSon = fieldsDataAsJSon.replaceAll("\r", "");
        updateProps.put("ds:fields", fieldsDataAsJSon);
        testDoc = (Document)this.session.newRequest("Document.Update").setHeader("X-NXDocumentProperties", "*").setInput((Object)new IdRef(testDoc.getId())).set("properties", (Object)new PropertyMap(updateProps).toString()).execute();
        Assert.assertEquals((Object)"testDoc", (Object)testDoc.getTitle());
        Assert.assertEquals((Object)"newTableName", (Object)testDoc.getProperties().get("ds:tableName"));
        PropertyList atts = testDoc.getProperties().getList("ds:attachments");
        Assert.assertNotNull((Object)atts);
        Assert.assertEquals((long)4L, (long)atts.size());
        Assert.assertEquals((Object)"new1", (Object)atts.getString(0));
        Assert.assertEquals((Object)"new4", (Object)atts.getString(3));
        dbFields = testDoc.getProperties().getList("ds:fields");
        Assert.assertEquals((long)2L, (long)dbFields.size());
        PropertyMap dbFieldA = dbFields.getMap(0);
        Assert.assertNotNull((Object)dbFieldA);
        Assert.assertEquals((Object)"fieldA", (Object)dbFieldA.getString("name"));
    }

    @Test
    public void testRawJSONDatastructuresAsParameters() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        POJOObject obj1 = new POJOObject("[obj1 text]", Arrays.asList("1", "2"));
        POJOObject obj2 = new POJOObject("[obj2 text]", Arrays.asList("2", "3"));
        String obj1JSON = mapper.writeValueAsString((Object)obj1);
        String obj2JSON = mapper.writeValueAsString((Object)obj2);
        Map map1 = (Map)mapper.readValue(obj1JSON, Map.class);
        Map map2 = (Map)mapper.readValue(obj2JSON, Map.class);
        POJOObject expectedObj12 = new POJOObject("Merged texts: [obj1 text][obj2 text]", Arrays.asList("1", "2", "2", "3"));
        POJOObject returnedObj12 = (POJOObject)this.session.newRequest("Operation.NestedJSONOperation").set("pojo", (Object)obj1).set("map", (Object)map2).execute();
        Assert.assertEquals((Object)expectedObj12, (Object)returnedObj12);
        returnedObj12 = (POJOObject)this.session.newRequest("Operation.NestedJSONOperation").set("pojo", (Object)map1).set("map", (Object)obj2).execute();
        Assert.assertEquals((Object)expectedObj12, (Object)returnedObj12);
        POJOObject expectedObj1AndDouble = new POJOObject("Merged texts: [obj1 text]", Arrays.asList("1", "2", "3.0"));
        POJOObject returnedObj1AndDouble = (POJOObject)this.session.newRequest("Operation.NestedJSONOperation").set("pojo", (Object)map1).set("doubleParam", (Object)3.0).execute();
        Assert.assertEquals((Object)expectedObj1AndDouble, (Object)returnedObj1AndDouble);
    }

    @Test
    public void testRawJSONDatastructuresAsInput() throws Exception {
        POJOObject expectedListObj = new POJOObject("Merged texts: ", Arrays.asList("a", "b", "c"));
        POJOObject returnedListObj = (POJOObject)this.session.newRequest("Operation.NestedJSONOperation").setInput(Arrays.asList("a", "b", "c")).execute();
        Assert.assertEquals((Object)expectedListObj, (Object)returnedListObj);
        POJOObject pojoInput = new POJOObject("input pojo", Arrays.asList("a", "b", "c"));
        returnedListObj = (POJOObject)this.session.newRequest("Operation.NestedJSONOperation").setInput((Object)pojoInput).execute();
        Assert.assertEquals((Object)expectedListObj, (Object)returnedListObj);
        ObjectMapper mapper = new ObjectMapper();
        Map mapInput = (Map)mapper.convertValue((Object)pojoInput, Map.class);
        returnedListObj = (POJOObject)this.session.newRequest("Operation.NestedJSONOperation").setInput((Object)mapInput).execute();
        Assert.assertEquals((Object)expectedListObj, (Object)returnedListObj);
        JsonMarshalling.addMarshaller((JsonMarshaller)PojoMarshaller.forClass(POJOObject.class));
        returnedListObj = (POJOObject)this.session.newRequest("Operation.NestedJSONOperation").setInput((Object)pojoInput).execute();
        Assert.assertEquals((Object)expectedListObj, (Object)returnedListObj);
    }

    @Test
    public void testArraysAsParametersAndResult() throws Exception {
        JsonMarshalling.addMarshaller((JsonMarshaller)new SimplePojoObjectMarshaller());
        ArrayList<JSONOperationWithArrays.SimplePojo> list = new ArrayList<JSONOperationWithArrays.SimplePojo>();
        list.add(new JSONOperationWithArrays.SimplePojo("test1"));
        list.add(new JSONOperationWithArrays.SimplePojo("test2"));
        list.add(new JSONOperationWithArrays.SimplePojo("test3"));
        ArrayList<ArrayList<JSONOperationWithArrays.SimplePojo>> listList = new ArrayList<ArrayList<JSONOperationWithArrays.SimplePojo>>();
        listList.add(list);
        JSONOperationWithArrays.SimplePojo[] simplePojos = list.toArray(new JSONOperationWithArrays.SimplePojo[list.size()]);
        JSONOperationWithArrays.SimplePojo result1 = (JSONOperationWithArrays.SimplePojo)this.session.newRequest("Operation.JSONOperationWithArrays").set("pojoList", list).set("whichPojo", (Object)"pojoList").execute();
        Assert.assertEquals((Object)result1.getName(), (Object)"test1");
        result1 = (JSONOperationWithArrays.SimplePojo)this.session.newRequest("Operation.JSONOperationWithArrays").set("pojo", (Object)new JSONOperationWithArrays.SimplePojo("nico")).set("whichPojo", (Object)"pojo").execute();
        Assert.assertEquals((Object)result1.getName(), (Object)"nico");
        result1 = (JSONOperationWithArrays.SimplePojo)this.session.newRequest("Operation.JSONOperationWithArrays").set("pojoListList", listList).set("whichPojo", (Object)"pojoListList").execute();
        Assert.assertEquals((Object)result1.getName(), (Object)"test1");
        result1 = (JSONOperationWithArrays.SimplePojo)this.session.newRequest("Operation.JSONOperationWithArrays").set("pojoArray", (Object)simplePojos).set("whichPojo", (Object)"pojoArray").execute();
        Assert.assertEquals((Object)result1.getName(), (Object)"test1");
        result1 = (JSONOperationWithArrays.SimplePojo)this.session.newRequest("Operation.JSONOperationWithArrays").set("pojoArray", (Object)new JSONOperationWithArrays.SimplePojo[0]).set("whichPojo", (Object)"empty").execute();
        Assert.assertNull((Object)result1);
    }

    @Test
    public void testNumericalValuesAsInputAndOuput() throws Exception {
        Object result = this.session.newRequest("Operation.NestedJSONOperation").setInput((Object)4.3).execute();
        Assert.assertEquals((Object)4, (Object)result);
    }

    @Test
    public void testDirtyProperties() throws Exception {
        this.setupComplexDocuments();
        Document testDoc = (Document)this.session.newRequest("Document.GetChild").setInput((Object)new PathRef("/")).set("name", (Object)"testDoc").execute();
        testDoc.set("ds:tableName", "newTableName");
        testDoc.set("ds:attachments", "new1,new2,new3,new4");
        File fieldAsJsonFile = FileUtils.getResourceFileFromContext((String)"updateFields.json");
        Assert.assertNotNull((Object)fieldAsJsonFile);
        String fieldsDataAsJSon = FileUtils.readFile((File)fieldAsJsonFile);
        fieldsDataAsJSon = fieldsDataAsJSon.replaceAll("\n", "");
        fieldsDataAsJSon = fieldsDataAsJSon.replaceAll("\r", "");
        testDoc.set("ds:fields", fieldsDataAsJSon);
        PropertyMap dirties = testDoc.getDirties();
        Assert.assertFalse((String)"The property dc:title should not be part of dirty properties", (boolean)dirties.getKeys().contains("dc:title"));
        testDoc = (Document)this.session.newRequest("Document.Update").setHeader("X-NXDocumentProperties", "*").setInput((Object)new IdRef(testDoc.getId())).set("properties", (Object)dirties.toString()).execute();
        Assert.assertEquals((Object)"testDoc", (Object)testDoc.getTitle());
        Assert.assertEquals((Object)"newTableName", (Object)testDoc.getProperties().get("ds:tableName"));
    }

    @Test
    public void testSetDocumentOperationMethod() throws Exception {
        Document document = new Document("myfolder2", "Folder");
        document.set("dc:title", "My Test Folder");
        document.set("dc:description", "test");
        document.set("dc:subjects", "a,b,c\\,d");
        Document folder = (Document)this.session.newRequest("Document.Create").setHeader("X-NXDocumentProperties", "*").setInput((Object)this.automationTestFolder).set("type", (Object)document.getType()).set("name", (Object)document.getId()).set("properties", (Object)document).execute();
        Assert.assertEquals((Object)"My Test Folder", (Object)folder.getString("dc:title"));
        Assert.assertEquals((Object)"test", (Object)folder.getString("dc:description"));
        this.setupComplexDocuments();
        Document testDoc = (Document)this.session.newRequest("Document.GetChild").setInput((Object)new PathRef("/")).set("name", (Object)"testDoc").execute();
        testDoc.set("ds:tableName", "newTableName");
        testDoc.set("ds:attachments", "new1,new2,new3,new4");
        File fieldAsJsonFile = FileUtils.getResourceFileFromContext((String)"updateFields.json");
        Assert.assertNotNull((Object)fieldAsJsonFile);
        String fieldsDataAsJSon = FileUtils.readFile((File)fieldAsJsonFile);
        fieldsDataAsJSon = fieldsDataAsJSon.replaceAll("\n", "");
        fieldsDataAsJSon = fieldsDataAsJSon.replaceAll("\r", "");
        testDoc.set("ds:fields", fieldsDataAsJSon);
        testDoc = (Document)this.session.newRequest("Document.Update").setHeader("X-NXDocumentProperties", "*").setInput((Object)new IdRef(testDoc.getId())).set("properties", (Object)testDoc).execute();
        Assert.assertEquals((Object)"testDoc", (Object)testDoc.getTitle());
        Assert.assertEquals((Object)"newTableName", (Object)testDoc.getProperties().get("ds:tableName"));
    }

    @Test
    public void testAutomationDocumentService() throws Exception {
        Document document = new Document("myfolder2", "Folder");
        document.set("dc:title", "My Test Folder");
        document.set("dc:description", "test");
        document.set("dc:subjects", "a,b,c\\,d");
        DocumentService documentService = (DocumentService)this.session.getAdapter(DocumentService.class);
        Document folder = documentService.createDocument(this.automationTestFolder.getId(), document);
        Assert.assertEquals((Object)"My Test Folder", (Object)folder.getTitle());
        folder = documentService.getDocument((DocRef)folder, "dublincore");
        Assert.assertEquals((Object)"My Test Folder", (Object)folder.getString("dc:title"));
        Assert.assertEquals((Object)"test", (Object)folder.getString("dc:description"));
        folder.set("dc:title", "New Title");
        documentService.update(folder);
        folder = documentService.getDocument((DocRef)folder, "*");
        Assert.assertEquals((Object)"New Title", (Object)folder.getString("dc:title"));
        this.setupComplexDocuments();
        Document testDoc = documentService.getDocument((DocRef)new PathRef("/testDoc"), "*");
        testDoc.set("ds:tableName", "newTableName");
        testDoc.set("ds:attachments", "new1,new2,new3,new4");
        PropertyList dbFields = testDoc.getProperties().getList("ds:fields");
        Assert.assertEquals((long)5L, (long)dbFields.size());
        PropertyMap dbField0 = dbFields.getMap(0);
        Assert.assertNotNull((Object)dbField0);
        Assert.assertEquals((Object)"field0", (Object)dbField0.getString("name"));
        Assert.assertEquals((Object)"Decision", (Object)dbField0.getList("roles").getString(0));
        Assert.assertEquals((Object)"Score", (Object)dbField0.getList("roles").getString(1));
        File fieldAsJsonFile = FileUtils.getResourceFileFromContext((String)"updateFields.json");
        Assert.assertNotNull((Object)fieldAsJsonFile);
        String fieldsDataAsJSon = FileUtils.readFile((File)fieldAsJsonFile);
        fieldsDataAsJSon = fieldsDataAsJSon.replaceAll("\n", "");
        fieldsDataAsJSon = fieldsDataAsJSon.replaceAll("\r", "");
        testDoc.set("ds:fields", fieldsDataAsJSon);
        documentService.update(testDoc);
        testDoc = documentService.getDocument((DocRef)testDoc, "*");
        Assert.assertEquals((Object)"testDoc", (Object)testDoc.getTitle());
        Assert.assertEquals((Object)"newTableName", (Object)testDoc.getProperties().get("ds:tableName"));
        PropertyList atts = testDoc.getProperties().getList("ds:attachments");
        Assert.assertNotNull((Object)atts);
        Assert.assertEquals((long)4L, (long)atts.size());
        Assert.assertEquals((Object)"new1", (Object)atts.getString(0));
        Assert.assertEquals((Object)"new4", (Object)atts.getString(3));
        dbFields = testDoc.getProperties().getList("ds:fields");
        Assert.assertEquals((long)2L, (long)dbFields.size());
        PropertyMap dbFieldA = dbFields.getMap(0);
        Assert.assertNotNull((Object)dbFieldA);
        Assert.assertEquals((Object)"fieldA", (Object)dbFieldA.getString("name"));
    }

    @Test
    public void testAutomationBusinessObjects() throws Exception {
        BusinessBean note = new BusinessBean("Note", "File description", "Note Content", "Note", new String("object"));
        BusinessService businessService = (BusinessService)this.session.getAdapter(BusinessService.class);
        Assert.assertNotNull((Object)businessService);
        this.client.registerPojoMarshaller(note.getClass());
        note = (BusinessBean)this.session.newRequest("Business.BusinessCreateOperation").setInput((Object)note).set("name", (Object)note.getTitle()).set("parentPath", (Object)"/").execute();
        Assert.assertNotNull((Object)note);
        note = (BusinessBean)this.session.newRequest("Business.BusinessFetchOperation").setInput((Object)note).execute();
        Assert.assertNotNull((Object)note.getId());
        note.setTitle("Update");
        note = (BusinessBean)this.session.newRequest("Business.BusinessUpdateOperation").setInput((Object)note).execute();
        Assert.assertEquals((Object)"Update", (Object)note.getTitle());
    }

    @Test
    public void testAutomationBusinessObjectsWithService() throws Exception {
        BusinessBean note = new BusinessBean("Note", "File description", "Note Content", "Note", new String("object"));
        BusinessService businessService = (BusinessService)this.session.getAdapter(BusinessService.class);
        Assert.assertNotNull((Object)businessService);
        note = (BusinessBean)businessService.create((Object)note, note.getTitle(), "/");
        Assert.assertNotNull((Object)note);
        note = (BusinessBean)businessService.fetch((Object)note);
        Assert.assertNotNull((Object)note.getId());
        note.setTitle("Update");
        note = (BusinessBean)businessService.update((Object)note);
        Assert.assertEquals((Object)"Update", (Object)note.getTitle());
    }

    @Test
    public void logAndThenQueryNoMapping() throws Exception {
        Assert.assertNotNull((Object)this.session);
        OperationRequest logRequest = this.session.newRequest("Audit.LogEvent", new HashMap());
        logRequest.getParameters().put("event", "testing");
        logRequest.setInput((Object)new PathRef("/"));
        logRequest.execute();
        OperationRequest queryRequest = this.session.newRequest("Audit.QueryWithPageProvider", new HashMap());
        queryRequest.getParameters().put("providerName", "AUDIT_BROWSER");
        Object result = queryRequest.execute();
        JsonNode node = (JsonNode)result;
        int count = node.get("currentPageSize").getValueAsInt();
        JsonNode entries = node.get("entries");
        for (int i = 0; i < count; ++i) {
            Assert.assertEquals((Object)"logEntry", (Object)entries.get(i).get("entity-type").getValueAsText());
        }
    }

    @Test
    public void testAutomationBusinessObjectsArray() throws Exception {
        BusinessBean[] businessBeans = new BusinessBean[2];
        BusinessService businessService = (BusinessService)this.session.getAdapter(BusinessService.class);
        Assert.assertNotNull((Object)businessService);
        this.client.registerPojoMarshaller(businessBeans.getClass());
        businessBeans = (BusinessBean[])this.session.newRequest("Business.TestBusinessArray").execute();
        Assert.assertNotNull((Object)businessBeans);
        Assert.assertEquals((long)2L, (long)businessBeans.length);
    }

    @Test
    public void testRemoteException() throws Exception {
        OperationDocumentation opd = this.session.getOperation("JsonStack.ToggleDisplay");
        Assert.assertNotNull((Object)opd);
        try {
            Document wrongDoc = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/test").execute();
            Assert.fail((String)("Unexpected " + wrongDoc));
        }
        catch (RemoteException e) {
            Assert.assertNotNull((Object)((Object)e));
            Assert.assertNotNull((Object)e.getRemoteStackTrace());
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void shouldReturnCustomHttpStatusWhenFailure() throws Exception {
        try {
            this.session.newRequest("Test.HttpStatus").set("isFailing", (Object)true).execute();
            Assert.fail();
        }
        catch (RemoteException e) {
            RemoteThrowable cause;
            Assert.assertNotNull((Object)((Object)e));
            Assert.assertEquals((Object)"Exception Message", (Object)e.getRemoteCause().getCause().getMessage());
            for (cause = (RemoteThrowable)e.getRemoteCause(); cause.getCause() != null && cause.getCause() != cause; cause = (RemoteThrowable)cause.getCause()) {
            }
            Assert.assertEquals((Object)ExceptionTest.class.getCanonicalName(), (Object)((JsonNode)cause.getOtherNodes().get("className")).getTextValue());
            Assert.assertEquals((long)405L, (long)e.getStatus());
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void shouldWriteAutomationContextWithDocuments() throws IOException {
        Document root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
        OperationRequest request = this.session.newRequest("RunOperationOnList");
        ArrayList<Document> list = new ArrayList<Document>();
        list.add(root);
        request.setContextProperty("users", list).set("isolate", (Object)"true").set("id", (Object)"TestContext").set("list", (Object)"users").set("item", (Object)"document");
        request.execute();
    }

    @Test
    public void shouldReadContentEnricher() throws IOException {
        Document root = (Document)this.session.newRequest("Repository.GetDocument").setHeader("X-NXenrichers.document", "breadcrumb").set("value", (Object)"/").execute();
        Assert.assertNotNull((Object)root.getContextParameters());
        Assert.assertEquals((long)1L, (long)root.getContextParameters().size());
        Assert.assertEquals((Object)"documents", (Object)((PropertyMap)root.getContextParameters().get("breadcrumb")).get("entity-type"));
    }

    @Test
    public void canSendCalendarParameters() throws IOException {
        Document root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
        OperationRequest request = this.session.newRequest("Document.AddPermission");
        GregorianCalendar begin = new GregorianCalendar(2015, 5, 20, 12, 34, 56);
        GregorianCalendar end = new GregorianCalendar(2015, 6, 14, 12, 34, 56);
        request.setInput((Object)root).set("username", (Object)"members").set("permission", (Object)"Write").set("begin", (Object)begin).set("end", (Object)end).execute();
    }

    @Test
    public void testContextInjection() throws IOException {
        Document root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
        Document folder = (Document)this.session.newRequest("ContextInjectionOperation").setHeader("X-NXDocumentProperties", "*").setInput((Object)root).setContextProperty("description", null).setContextProperty("title", (Object)"hello").execute();
        Assert.assertEquals((Object)"hello", (Object)folder.getString("dc:title"));
        Assert.assertNull((Object)folder.getString("dc:description"));
    }
}

