/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.test.EmbeddedAutomationServerFeature;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.Jetty;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={EmbeddedAutomationServerFeature.class})
@Deploy(value={"org.nuxeo.ecm.automation.scripting"})
@LocalDeploy(value={"org.nuxeo.ecm.automation.test:operation-contrib.xml"})
@Jetty(port=18080)
@RepositoryConfig(cleanup=Granularity.METHOD)
public class TestRemoteAutomationScript {
    ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private PrintStream outStream;
    @Inject
    Session session;
    @Inject
    HttpAutomationClient client;

    @Before
    public void setUpStreams() {
        this.outStream = System.out;
        System.setOut(new PrintStream(this.outContent));
    }

    @After
    public void cleanUpStreams() throws IOException {
        this.outContent.close();
        System.setOut(this.outStream);
    }

    protected Documents getDocuments() throws IOException {
        Document root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
        Document simple = (Document)this.session.newRequest("Document.Create").setInput((Object)root).set("type", (Object)"File").set("name", (Object)"Simple").set("properties", (Object)"dc:title=Simple\n").execute();
        Documents docs = new Documents();
        docs.add(simple);
        docs.add(root);
        return docs;
    }

    @Test
    public void canHandleDocumentSentRemotely() throws IOException {
        Document document = (Document)this.session.newRequest("javascript.RemoteScriptWithDoc").setInput((Object)this.getDocuments().get(0)).execute();
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)("Simple" + System.lineSeparator()), (Object)this.outContent.toString());
    }

    @Test
    public void canHandleDocumentsSentRemotely() throws IOException {
        Documents documents = (Documents)this.session.newRequest("javascript.RemoteScriptWithDocs").setInput((Object)this.getDocuments()).execute();
        Assert.assertNotNull((Object)documents);
        Assert.assertEquals((Object)("Simple" + System.lineSeparator()), (Object)this.outContent.toString());
    }
}

