/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.StreamBlob;

public class UploadFileSupport {
    protected final String rootPath;
    protected final Session session;

    public UploadFileSupport(Session session, String rootPath) {
        this.session = session;
        this.rootPath = rootPath;
    }

    public static MockInputStream newMockInput(long size, boolean digest) throws NoSuchAlgorithmException {
        if (digest) {
            return new DigestMockInputStream(size);
        }
        return new MockInputStream(size);
    }

    public FileInputStream testUploadFile(InputStream source) throws Exception {
        return this.testUploadFile(source, 0);
    }

    public FileInputStream testUploadFile(InputStream source, int timeout) throws Exception {
        StreamBlob blob = new StreamBlob(source, "big-blob", "application/octet-stream");
        Document root = (Document)this.session.newRequest("Document.Fetch").set("value", (Object)this.rootPath).execute();
        OperationRequest upload = this.session.newRequest("Document.Create").setInput((Object)root).set("type", (Object)"File").set("name", (Object)"bigfile").set("properties", (Object)"dc:title=Big File");
        if (timeout > 0) {
            upload = upload.setHeader("Nuxeo-Transaction-Timeout", Integer.toString(timeout));
        }
        Document doc = (Document)upload.execute();
        this.session.newRequest("Blob.Attach").setHeader("X-NXVoidOperation", "true").setInput((Object)blob).set("document", (Object)(this.rootPath + "/bigfile")).execute();
        FileBlob serverBlob = (FileBlob)this.session.newRequest("Blob.Get").setInput((Object)doc).set("xpath", (Object)"file:content").execute();
        return (FileInputStream)serverBlob.getStream();
    }

    public static class DigestMockInputStream
    extends MockInputStream {
        protected final Random rand = new Random();
        protected final MessageDigest digest = MessageDigest.getInstance("MD5");

        DigestMockInputStream(long size) throws NoSuchAlgorithmException {
            super(size);
        }

        @Override
        int getByte() {
            byte data = (byte)this.rand.nextInt(255);
            this.digest.update(data);
            return data;
        }
    }

    public static class MockInputStream
    extends InputStream {
        final long max;
        long consumed = 0L;

        public MockInputStream(long size) {
            this.max = size;
        }

        @Override
        public int read() throws IOException {
            if (this.consumed >= this.max) {
                return -1;
            }
            ++this.consumed;
            return this.getByte();
        }

        int getByte() {
            return 0;
        }
    }
}

