/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.adapters;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.preview.api.HtmlPreviewAdapter;
import org.nuxeo.ecm.platform.preview.helper.PreviewHelper;
import org.nuxeo.ecm.restapi.server.jaxrs.blob.BlobObject;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="preview", type="previewAdapter")
@Produces(value={"application/json"})
public class PreviewAdapter
extends DefaultAdapter {
    public static final String NAME = "preview";

    @GET
    public Object preview(@QueryParam(value="blobPostProcessing") boolean postProcessing, @Context HttpServletRequest request, @Context HttpServletResponse response) {
        DocumentBlobHolder bh = this.getBlobHolderToPreview();
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        try {
            URI uri = blobManager.getURI(bh.getBlob(), BlobManager.UsageHint.EMBED, null);
            if (uri != null) {
                return Response.seeOther((URI)uri).build();
            }
        }
        catch (IOException e) {
            throw WebException.wrap((Throwable)e);
        }
        List<Blob> previewBlobs = this.getPreviewBlobs(bh, postProcessing);
        if (previewBlobs == null || previewBlobs.isEmpty()) {
            throw new WebResourceNotFoundException("Preview not available");
        }
        try {
            Blob blob = previewBlobs.get(0);
            DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
            downloadService.downloadBlob(request, response, bh.getDocument(), bh.getXpath(), blob, blob.getFilename(), NAME, null, Boolean.valueOf(true));
        }
        catch (IOException e) {
            throw WebException.wrap((Throwable)e);
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="{subPath}")
    public Object subPath(@PathParam(value="subPath") String subPath, @QueryParam(value="blobPostProcessing") boolean postProcessing, @Context HttpServletRequest request, @Context HttpServletResponse response) {
        DocumentBlobHolder bh = this.getBlobHolderToPreview();
        List<Blob> previewBlobs = this.getPreviewBlobs(bh, postProcessing);
        if (previewBlobs == null || previewBlobs.isEmpty()) {
            throw new WebResourceNotFoundException("Preview not available");
        }
        Optional<Blob> subBlob = previewBlobs.stream().filter(b -> subPath.equals(b.getFilename())).findFirst();
        if (!subBlob.isPresent()) {
            throw new WebResourceNotFoundException(String.format("Preview blob %s not found", subPath));
        }
        try {
            Blob blob = subBlob.get();
            DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
            Map<String, String> extendedInfos = Collections.singletonMap("subPath", subPath);
            downloadService.downloadBlob(request, response, bh.getDocument(), bh.getXpath(), blob, blob.getFilename(), NAME, extendedInfos, Boolean.valueOf(true));
        }
        catch (IOException e) {
            throw WebException.wrap((Throwable)e);
        }
        return Response.ok().build();
    }

    private List<Blob> getPreviewBlobs(DocumentBlobHolder bh, boolean blobPostProcessing) {
        DocumentModel doc = bh.getDocument();
        String xpath = bh.getXpath();
        if (this.isBlobTarget() && !this.isBlobHolder(doc, xpath)) {
            HtmlPreviewAdapter preview = PreviewHelper.getBlobPreviewAdapter((DocumentModel)doc);
            return preview.getFilePreviewBlobs(xpath, blobPostProcessing);
        }
        HtmlPreviewAdapter preview = (HtmlPreviewAdapter)doc.getAdapter(HtmlPreviewAdapter.class);
        if (preview == null) {
            return null;
        }
        return preview.getFilePreviewBlobs(blobPostProcessing);
    }

    private DocumentBlobHolder getBlobHolderToPreview() {
        DocumentModel doc;
        if (this.isBlobTarget()) {
            BlobObject target = (BlobObject)this.getTarget();
            doc = target.getDocument();
            if (!this.isBlobHolder(doc, target.getXpath())) {
                return new DocumentBlobHolder(doc, target.getXpath());
            }
        } else {
            doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        }
        return (DocumentBlobHolder)doc.getAdapter(BlobHolder.class);
    }

    private boolean isBlobTarget() {
        return this.getTarget().isInstanceOf("blob");
    }

    private boolean isBlobHolder(DocumentModel doc, String xpath) {
        DocumentBlobHolder bh = (DocumentBlobHolder)doc.getAdapter(BlobHolder.class);
        return bh != null && bh.getXpath().equals(xpath);
    }
}

