/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.usermanager;

import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.restapi.server.jaxrs.usermanager.GroupRootObject;
import org.nuxeo.ecm.restapi.server.jaxrs.usermanager.UserRootObject;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="userToGroup")
public class UserToGroupObject
extends DefaultObject {
    private NuxeoGroup group;
    private NuxeoPrincipal principal;

    protected void initialize(Object ... args) {
        if (args.length != 2) {
            throw new IllegalArgumentException("UserToGroup object takes two parameters");
        }
        this.principal = (NuxeoPrincipal)args[0];
        this.group = (NuxeoGroup)args[1];
    }

    @POST
    public Response doAddUserToGroup() {
        try {
            UserManager um = (UserManager)Framework.getLocalService(UserManager.class);
            this.checkPrincipalCanAdministerGroupAndUser(um);
            List groups = this.principal.getGroups();
            groups.add(this.group.getName());
            this.principal.setGroups(groups);
            um.updateUser(this.principal.getModel());
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)um.getPrincipal(this.principal.getName())).build();
        }
        catch (NuxeoException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    private void checkPrincipalCanAdministerGroupAndUser(UserManager um) {
        NuxeoPrincipal currentPrincipal = (NuxeoPrincipal)this.getContext().getCoreSession().getPrincipal();
        if (!(currentPrincipal.isAdministrator() || this.principal.isMemberOf("powerusers") && UserRootObject.isAPowerUserEditableUser(this.principal) && GroupRootObject.isAPowerUserEditableGroup(this.group))) {
            throw new WebSecurityException("Cannot edit user");
        }
    }

    @DELETE
    public Response doRemoveUserFromGroup() {
        try {
            UserManager um = (UserManager)Framework.getLocalService(UserManager.class);
            this.checkPrincipalCanAdministerGroupAndUser(um);
            List groups = this.principal.getGroups();
            groups.remove(this.group.getName());
            this.principal.setGroups(groups);
            um.updateUser(this.principal.getModel());
            return Response.ok((Object)this.principal.getName()).build();
        }
        catch (NuxeoException e) {
            throw WebException.wrap((Throwable)e);
        }
    }
}

