/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.impl.ExtendedInfoImpl;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class LogEntryGen {
    protected static Map<String, ExtendedInfo> createExtendedInfos() {
        HashMap<String, ExtendedInfo> infos = new HashMap<String, ExtendedInfo>();
        ExtendedInfoImpl info = ExtendedInfoImpl.createExtendedInfo((Serializable)Long.valueOf(1L));
        infos.put("id", (ExtendedInfo)info);
        return infos;
    }

    public static LogEntry doCreateEntry(String docId, String eventId, String category) {
        LogEntryImpl createdEntry = new LogEntryImpl();
        createdEntry.setEventId(eventId);
        createdEntry.setCategory(category);
        createdEntry.setDocUUID(docId);
        createdEntry.setEventDate(new Date());
        createdEntry.setDocPath("/" + docId);
        createdEntry.setRepositoryId("test");
        createdEntry.setExtendedInfos(LogEntryGen.createExtendedInfos());
        return createdEntry;
    }

    public static void flushAndSync() throws Exception {
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        Assert.assertTrue((boolean)((AuditLogger)Framework.getLocalService(AuditLogger.class)).await(10L, TimeUnit.SECONDS));
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        esa.getClient().admin().indices().prepareFlush(new String[]{esa.getIndexNameForType("entry")}).execute().actionGet();
        esa.getClient().admin().indices().prepareRefresh(new String[]{esa.getIndexNameForType("entry")}).execute().actionGet();
    }

    public static void generate(String docName, String eventPrefix, String categoryPrefix, int max) throws Exception {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        AuditLogger logger = (AuditLogger)Framework.getLocalService(AuditLogger.class);
        Assert.assertNotNull((Object)logger);
        for (int i = 0; i < max; ++i) {
            entries.add(LogEntryGen.doCreateEntry(docName, eventPrefix + i, categoryPrefix + i % 2));
        }
        logger.addLogEntries(entries);
        LogEntryGen.flushAndSync();
    }
}

