/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.test.TransactionalFeature;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.DefaultAuditBackend;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.ecm.platform.audit.service.extension.AuditBackendDescriptor;
import org.nuxeo.elasticsearch.LogEntryGen;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.audit.ESAuditBackend;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.test.runner.RuntimeHarness;

@Deploy(value={"org.nuxeo.runtime.metrics", "org.nuxeo.ecm.platform.audit.api", "org.nuxeo.runtime.datasource", "org.nuxeo.ecm.core.persistence", "org.nuxeo.ecm.platform.audit", "org.nuxeo.ecm.platform.uidgen.core", "org.nuxeo.elasticsearch.seqgen", "org.nuxeo.elasticsearch.seqgen.test:elasticsearch-seqgen-index-test-contrib.xml", "org.nuxeo.elasticsearch.audit"})
@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.audit:nxaudit-ds.xml", "org.nuxeo.elasticsearch.audit:nxuidsequencer-ds.xml", "org.nuxeo.elasticsearch.audit:elasticsearch-test-contrib.xml", "org.nuxeo.elasticsearch.audit:elasticsearch-audit-index-test-contrib.xml", "org.nuxeo.elasticsearch.audit:audit-test-contrib.xml"})
public class TestAuditMigration {
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchAdmin esa;
    @Inject
    protected RuntimeHarness harness;
    @Inject
    TransactionalFeature txFeature;

    @Before
    public void setupIndex() throws Exception {
        this.esa.initIndexes(true);
    }

    @Test
    public void shouldMigrate() throws Exception {
        NXAuditEventsService audit = (NXAuditEventsService)Framework.getRuntime().getComponent(NXAuditEventsService.NAME);
        Assert.assertNotNull((Object)audit);
        DefaultAuditBackend jpaBackend = (DefaultAuditBackend)new AuditBackendDescriptor().newInstance(audit);
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        for (int i = 0; i < 1000; ++i) {
            entries.add(LogEntryGen.doCreateEntry("mydoc", "evt" + i, "cat" + i % 2));
        }
        jpaBackend.addLogEntries(entries);
        this.txFeature.nextTransaction();
        List res = jpaBackend.nativeQuery("select count(*) from LogEntry", 1, 20);
        long nbEntriesToMigrate = (Long)res.get(0);
        Assert.assertEquals((long)1000L, (long)nbEntriesToMigrate);
        AuditBackend backend = audit.getBackend();
        Assert.assertNotNull((Object)backend);
        Assert.assertTrue((boolean)(backend instanceof ESAuditBackend));
        ESAuditBackend esBackend = (ESAuditBackend)backend;
        esBackend.migrate(100);
        ((WorkManager)Framework.getLocalService(WorkManager.class)).awaitCompletion(1L, TimeUnit.MINUTES);
        LogEntryGen.flushAndSync();
        String singleQuery = "            {\n                \"bool\" : {\n                  \"must\" : {\n                    \"match\" : {\n                      \"docUUID\" : {\n                        \"query\" : \"mydoc\",\n                        \"type\" : \"boolean\"\n                      }\n                    }\n                  }\n                }\n              }          \n";
        List migratedEntries = backend.nativeQuery(singleQuery, 0, 1001);
        Assert.assertEquals((long)1000L, (long)migratedEntries.size());
    }
}

