/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.impl.ExtendedInfoImpl;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.elasticsearch.LogEntryGen;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Deploy(value={"org.nuxeo.runtime.metrics", "org.nuxeo.ecm.platform.audit.api", "org.nuxeo.ecm.platform.audit", "org.nuxeo.ecm.platform.uidgen.core", "org.nuxeo.elasticsearch.seqgen", "org.nuxeo.elasticsearch.seqgen.test:elasticsearch-seqgen-index-test-contrib.xml", "org.nuxeo.elasticsearch.audit"})
@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.audit:elasticsearch-test-contrib.xml", "org.nuxeo.elasticsearch.audit:elasticsearch-audit-index-test-contrib.xml", "org.nuxeo.elasticsearch.audit:audit-test-contrib.xml", "org.nuxeo.elasticsearch.audit:es-audit-pageprovider-test-contrib.xml"})
public class TestAuditPageProviderWithElasticSearch {
    @Inject
    protected CoreSession session;
    @Inject
    protected PageProviderService pps;
    @Inject
    protected ElasticSearchAdmin esa;

    @Before
    public void setupIndex() throws Exception {
        this.esa.initIndexes(true);
    }

    protected void flushAndSync() throws Exception {
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        Assert.assertTrue((boolean)((AuditLogger)Framework.getLocalService(AuditLogger.class)).await(10L, TimeUnit.SECONDS));
        this.esa.getClient().admin().indices().prepareFlush(new String[]{this.esa.getIndexNameForType("entry")}).execute().actionGet();
        this.esa.getClient().admin().indices().prepareRefresh(new String[]{this.esa.getIndexNameForType("entry")}).execute().actionGet();
    }

    protected Map<String, ExtendedInfo> createExtendedInfos() {
        HashMap<String, ExtendedInfo> infos = new HashMap<String, ExtendedInfo>();
        ExtendedInfoImpl info = ExtendedInfoImpl.createExtendedInfo((Serializable)new Long(1L));
        infos.put("id", (ExtendedInfo)info);
        return infos;
    }

    protected LogEntry doCreateEntry(String docId, String eventId, String category) {
        LogEntryImpl createdEntry = new LogEntryImpl();
        createdEntry.setEventId(eventId);
        createdEntry.setCategory(category);
        createdEntry.setDocUUID(docId);
        createdEntry.setEventDate(new Date());
        createdEntry.setDocPath("/" + docId);
        createdEntry.setRepositoryId("test");
        createdEntry.setExtendedInfos(this.createExtendedInfos());
        return createdEntry;
    }

    @Test
    public void testSimplePageProvider() throws Exception {
        LogEntryGen.generate("dummy", "entry", "category", 15);
        PageProvider pp = this.pps.getPageProvider("SimpleESAuditPP", null, Long.valueOf(5L), Long.valueOf(0L), new HashMap(), new Object[0]);
        Assert.assertNotNull((Object)pp);
        List entries = pp.getCurrentPage();
        Assert.assertEquals((long)5L, (long)entries.size());
        Assert.assertEquals((long)5L, (long)pp.getCurrentPageSize());
        Assert.assertEquals((long)7L, (long)pp.getResultsCount());
        Assert.assertTrue((((LogEntry)entries.get(0)).getId() < ((LogEntry)entries.get(1)).getId() ? 1 : 0) != 0);
        Assert.assertTrue((((LogEntry)entries.get(3)).getId() < ((LogEntry)entries.get(4)).getId() ? 1 : 0) != 0);
    }

    @Test
    public void testSimplePageProviderWithParams() throws Exception {
        LogEntryGen.generate("withParams", "entry", "category", 15);
        PageProvider pp = this.pps.getPageProvider("SimpleESAuditPPWithParams", null, Long.valueOf(5L), Long.valueOf(0L), new HashMap(), new Object[]{"category1"});
        Assert.assertNotNull((Object)pp);
        List entries = pp.getCurrentPage();
        Assert.assertEquals((long)2L, (long)entries.size());
        Assert.assertTrue((((LogEntry)entries.get(0)).getId() > ((LogEntry)entries.get(1)).getId() ? 1 : 0) != 0);
        pp = this.pps.getPageProvider("SimpleESAuditPPWithParams", null, Long.valueOf(5L), Long.valueOf(0L), new HashMap(), new Object[]{"category0"});
        entries = pp.getCurrentPage();
        Assert.assertEquals((long)1L, (long)entries.size());
    }

    @Test
    public void testSimplePageProviderWithUUID() throws Exception {
        LogEntryGen.generate("uuid1", "uentry", "ucategory", 10);
        PageProvider pp = this.pps.getPageProvider("SearchById", null, Long.valueOf(5L), Long.valueOf(0L), new HashMap(), new Object[]{"uuid1"});
        Assert.assertNotNull((Object)pp);
        List entries = pp.getCurrentPage();
        Assert.assertEquals((long)5L, (long)entries.size());
    }

    @Test
    public void testAdminPageProvider() throws Exception {
        LogEntryGen.generate("uuid2", "aentry", "acategory", 10);
        PageProvider pp = this.pps.getPageProvider("ADMIN_HISTORY", null, Long.valueOf(5L), Long.valueOf(0L), new HashMap(), new Object[0]);
        Assert.assertNotNull((Object)pp);
        List entries = pp.getCurrentPage();
        Assert.assertEquals((long)5L, (long)entries.size());
    }
}

