/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.elasticsearch.LogEntryGen;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.audit.ESAuditBackend;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@Deploy(value={"org.nuxeo.runtime.metrics", "org.nuxeo.ecm.platform.audit.api", "org.nuxeo.ecm.platform.audit", "org.nuxeo.ecm.platform.uidgen.core", "org.nuxeo.elasticsearch.seqgen", "org.nuxeo.elasticsearch.seqgen.test:elasticsearch-seqgen-index-test-contrib.xml", "org.nuxeo.elasticsearch.audit"})
@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.audit:elasticsearch-test-contrib.xml", "org.nuxeo.elasticsearch.audit:elasticsearch-audit-index-test-contrib.xml", "org.nuxeo.elasticsearch.audit:audit-test-contrib.xml"})
public class TestAuditWithElasticSearch {
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchAdmin esa;

    @Before
    public void setupIndex() throws Exception {
        this.esa.initIndexes(true);
    }

    @Test
    public void shouldUseESBackend() throws Exception {
        NXAuditEventsService audit = (NXAuditEventsService)Framework.getRuntime().getComponent(NXAuditEventsService.NAME);
        Assert.assertNotNull((Object)audit);
        AuditBackend backend = audit.getBackend();
        Assert.assertNotNull((Object)backend);
        Assert.assertTrue((boolean)(backend instanceof ESAuditBackend));
    }

    @Test
    public void shouldLogInAudit() throws Exception {
        DocumentModel doc = this.session.createDocumentModel("/", "a-file", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"A File"));
        doc = this.session.createDocument(doc);
        LogEntryGen.flushAndSync();
        doc.setPropertyValue("dc:title", (Serializable)((Object)"A modified File"));
        doc = this.session.saveDocument(doc);
        LogEntryGen.flushAndSync();
        AuditReader reader = (AuditReader)Framework.getLocalService(AuditReader.class);
        List trail = reader.getLogEntriesFor(doc.getId());
        Assert.assertNotNull((Object)trail);
        Assert.assertEquals((long)2L, (long)trail.size());
        LogEntry entry = (LogEntry)trail.get(0);
        Long startId = entry.getId();
        Assert.assertEquals((Object)"documentCreated", (Object)entry.getEventId());
        Assert.assertEquals((Object)"eventDocumentCategory", (Object)entry.getCategory());
        Assert.assertEquals((Object)"A File", (Object)((ExtendedInfo)entry.getExtendedInfos().get("title")).getValue(String.class));
        Assert.assertEquals((long)(startId + 1L), (long)((LogEntry)trail.get(1)).getId());
        Assert.assertEquals((Object)"documentModified", (Object)((LogEntry)trail.get(1)).getEventId());
        Assert.assertEquals((Object)"eventDocumentCategory", (Object)((LogEntry)trail.get(1)).getCategory());
        Assert.assertEquals((Object)"A modified File", (Object)((ExtendedInfo)((LogEntry)trail.get(1)).getExtendedInfos().get("title")).getValue(String.class));
        LogEntry entryById = reader.getLogEntryByID(entry.getId());
        Assert.assertEquals((long)entry.getId(), (long)entryById.getId());
        entryById = reader.getLogEntryByID(123L);
        Assert.assertNull((Object)entryById);
        NXAuditEventsService audit = (NXAuditEventsService)Framework.getRuntime().getComponent(NXAuditEventsService.NAME);
        AuditBackend backend = audit.getBackend();
        Assert.assertEquals((long)1L, (long)backend.getEventsCount(entry.getEventId()));
    }

    @Test
    public void shouldSupportMultiCriteriaQueries() throws Exception {
        LogEntryGen.generate("mydoc", "evt", "cat", 9);
        AuditReader reader = (AuditReader)Framework.getLocalService(AuditReader.class);
        String[] evts = new String[]{"evt1", "evt2"};
        List res = reader.queryLogs(evts, null);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((long)2L, (long)res.size());
        evts = new String[]{"evt1"};
        res = reader.queryLogs(evts, null);
        Assert.assertEquals((long)1L, (long)res.size());
        evts = new String[]{"evt"};
        res = reader.queryLogs(evts, null);
        Assert.assertEquals((long)0L, (long)res.size());
        evts = new String[]{"evt1", "evt2"};
        String[] cats = new String[]{"cat1"};
        res = reader.queryLogsByPage(evts, (Date)null, cats, null, 0, 5);
        Assert.assertEquals((long)1L, (long)res.size());
        evts = new String[]{"evt1", "evt2"};
        cats = new String[]{"cat1", "cat0"};
        res = reader.queryLogsByPage(evts, (Date)null, cats, null, 0, 5);
        Assert.assertEquals((long)2L, (long)res.size());
        res = reader.queryLogsByPage((String[])null, (Date)null, (String[])null, "/mydoc", 0, 5);
        Assert.assertEquals((long)5L, (long)res.size());
        res = reader.queryLogsByPage((String[])null, (Date)null, (String[])null, "/mydoc", 1, 5);
        Assert.assertEquals((long)4L, (long)res.size());
    }

    @Test
    public void shouldSupportNativeQueries() throws Exception {
        LogEntryGen.generate("dummy", "entry", "category", 9);
        AuditReader reader = (AuditReader)Framework.getLocalService(AuditReader.class);
        String jsonQuery = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("filtredQuery.json"), (String)"UTF-8");
        List res = reader.nativeQuery(jsonQuery, 0, 5);
        Assert.assertEquals((long)2L, (long)res.size());
        jsonQuery = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("filtredQueryWithParams.json"), (String)"UTF-8");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("category", "category1");
        res = reader.nativeQuery(jsonQuery, params, 0, 5);
        Assert.assertEquals((long)1L, (long)res.size());
    }
}

