/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.elasticsearch.LogEntryGen;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Deploy(value={"org.nuxeo.ecm.platform.audit.api", "org.nuxeo.runtime.metrics", "org.nuxeo.ecm.platform.audit", "org.nuxeo.ecm.platform.uidgen.core", "org.nuxeo.elasticsearch.seqgen", "org.nuxeo.elasticsearch.seqgen.test:elasticsearch-seqgen-index-test-contrib.xml", "org.nuxeo.elasticsearch.audit"})
@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.audit:elasticsearch-test-contrib.xml", "org.nuxeo.elasticsearch.audit:elasticsearch-audit-index-test-contrib.xml", "org.nuxeo.elasticsearch.audit:audit-test-contrib.xml"})
public class TestESHistoryProvider {
    protected static final Calendar testDate = Calendar.getInstance();
    protected DocumentModel doc;
    protected DocumentModel proxy;
    protected List<DocumentModel> versions;
    protected Date t1;
    protected Date t2;
    protected boolean verbose = false;
    @Inject
    protected CoreSession session;

    protected void dump(Object ob) {
        System.out.println(ob.toString());
    }

    protected void dump(List<?> obs) {
        for (Object ob : obs) {
            this.dump(ob);
        }
    }

    protected void waitForAsyncCompletion() throws InterruptedException {
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        Assert.assertTrue((boolean)((AuditLogger)Framework.getLocalService(AuditLogger.class)).await(10L, TimeUnit.SECONDS));
    }

    protected void createTestEntries() throws Exception {
        int i;
        AuditReader reader = (AuditReader)Framework.getLocalService(AuditReader.class);
        DocumentModel section = this.session.createDocumentModel("/", "section", "Folder");
        section = this.session.createDocument(section);
        this.doc = this.session.createDocumentModel("/", "doc", "File");
        this.doc.setPropertyValue("dc:title", (Serializable)((Object)"TestDoc"));
        this.doc = this.session.createDocument(this.doc);
        Thread.sleep(500L);
        this.t1 = new Date();
        Thread.sleep(600L);
        for (i = 0; i < 5; ++i) {
            this.doc.setPropertyValue("dc:description", (Serializable)((Object)("Update " + i)));
            this.doc.getContextData().put((Object)"comment", (Object)("Update " + i));
            this.doc = this.session.saveDocument(this.doc);
            this.waitForAsyncCompletion();
        }
        Thread.sleep(600L);
        this.t2 = new Date();
        Thread.sleep(500L);
        this.doc.putContextData("VersioningOption", (Serializable)VersioningOption.MINOR);
        this.doc = this.session.saveDocument(this.doc);
        this.session.save();
        this.waitForAsyncCompletion();
        Thread.sleep(1100L);
        for (i = 5; i < 10; ++i) {
            this.doc.setPropertyValue("dc:description", (Serializable)((Object)("Update " + i)));
            this.doc.getContextData().put((Object)"comment", (Object)("Update " + i));
            this.doc = this.session.saveDocument(this.doc);
            this.session.save();
            this.waitForAsyncCompletion();
        }
        Thread.sleep(1100L);
        this.proxy = this.session.publishDocument(this.doc, section);
        this.session.save();
        this.waitForAsyncCompletion();
        Thread.sleep(1100L);
        for (i = 10; i < 15; ++i) {
            this.doc.setPropertyValue("dc:description", (Serializable)((Object)("Update " + i)));
            this.doc.getContextData().put((Object)"comment", (Object)("Update " + i));
            this.doc = this.session.saveDocument(this.doc);
            this.session.save();
        }
        Thread.sleep(500L);
        this.waitForAsyncCompletion();
        this.versions = this.session.getVersions(this.doc.getRef());
        Assert.assertEquals((long)2L, (long)this.versions.size());
        if (this.verbose) {
            for (DocumentModel version : this.versions) {
                System.out.println("version: " + version.getId());
                System.out.println("version series: " + version.getVersionSeriesId());
                System.out.println("version label: " + version.getVersionLabel());
                System.out.println("version date: " + ((Calendar)version.getPropertyValue("dc:modified")).getTime());
            }
        }
        LogEntryGen.flushAndSync();
        LogEntryImpl createdEntry = new LogEntryImpl();
        createdEntry.setEventId("bonusEvent");
        createdEntry.setCategory("bonusCategory");
        createdEntry.setDocUUID(this.doc.getId());
        createdEntry.setEventDate(new Date());
        createdEntry.setDocPath(this.doc.getPathAsString());
        createdEntry.setRepositoryId("test");
        ArrayList<LogEntryImpl> entries = new ArrayList<LogEntryImpl>();
        entries.add(createdEntry);
        ((AuditLogger)Framework.getLocalService(AuditLogger.class)).addLogEntries(entries);
        LogEntryGen.flushAndSync();
        List logs = reader.getLogEntriesFor(this.doc.getId());
        if (this.verbose) {
            this.dump(logs);
        }
        if (this.verbose) {
            String matchAll = "{\n            \"match_all\" : { }\n        }";
            logs = reader.nativeQuery(matchAll, 0, 30);
            System.out.println("Total entries = " + logs.size());
            this.dump(logs);
        }
    }

    @Test
    public void testDocumentHistoryPageProvider() throws Exception {
        int version1EntriesCount;
        List entries;
        PageProvider pp;
        this.createTestEntries();
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("DOCUMENT_HISTORY_PROVIDER");
        Assert.assertNotNull((Object)ppdef);
        long startIdx = 0L;
        List<SortInfo> si = Arrays.asList(new SortInfo("id", true));
        DocumentModel searchDoc = this.session.createDocumentModel("BasicAuditSearch");
        searchDoc.setPathInfo("/", "auditsearch");
        searchDoc = this.session.createDocument(searchDoc);
        for (String ppName : new String[]{"DOCUMENT_HISTORY_PROVIDER_OLD", "DOCUMENT_HISTORY_PROVIDER"}) {
            pp = ppName.endsWith("OLD") ? pps.getPageProvider(ppName, si, Long.valueOf(20L), Long.valueOf(0L), new HashMap(), new Object[]{this.doc.getId()}) : pps.getPageProvider(ppName, si, Long.valueOf(20L), Long.valueOf(0L), new HashMap(), new Object[]{this.doc});
            Assert.assertNotNull((Object)pp);
            searchDoc.setPropertyValue("basicauditsearch:eventIds", null);
            searchDoc.setPropertyValue("basicauditsearch:eventCategories", null);
            searchDoc.setPropertyValue("basicauditsearch:startDate", null);
            searchDoc.setPropertyValue("basicauditsearch:endDate", null);
            pp.setSearchDocumentModel(searchDoc);
            entries = pp.getCurrentPage();
            if (this.verbose) {
                System.out.println("Live doc history");
                this.dump(entries);
            }
            Assert.assertEquals((long)20L, (long)entries.size());
            startIdx = ((LogEntry)entries.get(0)).getId();
            searchDoc.setPropertyValue("basicauditsearch:eventIds", (Serializable)new String[]{"documentModified"});
            searchDoc.setPropertyValue("basicauditsearch:eventCategories", null);
            pp.setSearchDocumentModel(searchDoc);
            entries = pp.getCurrentPage();
            Assert.assertEquals((long)16L, (long)entries.size());
            searchDoc.setPropertyValue("basicauditsearch:eventIds", null);
            searchDoc.setPropertyValue("basicauditsearch:eventCategories", (Serializable)new String[]{"eventDocumentCategory"});
            pp.setSearchDocumentModel(searchDoc);
            entries = pp.getCurrentPage();
            Assert.assertEquals((long)19L, (long)entries.size());
            searchDoc.setPropertyValue("basicauditsearch:eventIds", null);
            searchDoc.setPropertyValue("basicauditsearch:eventCategories", (Serializable)new String[]{"eventDocumentCategory", "bonusCategory"});
            pp.setSearchDocumentModel(searchDoc);
            entries = pp.getCurrentPage();
            Assert.assertEquals((long)20L, (long)entries.size());
            searchDoc.setPropertyValue("basicauditsearch:eventIds", null);
            searchDoc.setPropertyValue("basicauditsearch:eventCategories", null);
            searchDoc.setPropertyValue("basicauditsearch:startDate", (Serializable)this.t1);
            searchDoc.setPropertyValue("basicauditsearch:endDate", (Serializable)this.t2);
            pp.setSearchDocumentModel(searchDoc);
            entries = pp.getCurrentPage();
            Assert.assertEquals((long)5L, (long)entries.size());
        }
        searchDoc.setPropertyValue("basicauditsearch:eventIds", null);
        searchDoc.setPropertyValue("basicauditsearch:eventCategories", null);
        searchDoc.setPropertyValue("basicauditsearch:startDate", null);
        searchDoc.setPropertyValue("basicauditsearch:endDate", null);
        pp = pps.getPageProvider("DOCUMENT_HISTORY_PROVIDER", si, Long.valueOf(30L), Long.valueOf(0L), new HashMap(), new Object[]{this.proxy});
        pp.setSearchDocumentModel(searchDoc);
        entries = pp.getCurrentPage();
        if (this.verbose) {
            System.out.println("Proxy doc history");
            this.dump(entries);
        }
        int proxyEntriesCount = 16;
        Assert.assertEquals((long)proxyEntriesCount, (long)entries.size());
        Assert.assertEquals((long)startIdx, (long)((LogEntry)entries.get(0)).getId());
        Assert.assertEquals((long)(startIdx + (long)proxyEntriesCount + 1L), (long)((LogEntry)entries.get(proxyEntriesCount - 1)).getId());
        pp = pps.getPageProvider("DOCUMENT_HISTORY_PROVIDER", si, Long.valueOf(20L), Long.valueOf(0L), new HashMap(), new Object[]{this.versions.get(0)});
        pp.setSearchDocumentModel(searchDoc);
        entries = pp.getCurrentPage();
        if (this.verbose) {
            System.out.println("Version " + this.versions.get(0).getVersionLabel() + " doc history");
            this.dump(entries);
        }
        if ((version1EntriesCount = 9) == entries.size()) {
            Assert.assertEquals((long)startIdx, (long)((LogEntry)entries.get(0)).getId());
            Assert.assertEquals((long)(startIdx + (long)version1EntriesCount - 1L), (long)((LogEntry)entries.get(version1EntriesCount - 1)).getId());
        } else {
            Assert.assertEquals((long)(version1EntriesCount - 1), (long)entries.size());
        }
        pp = pps.getPageProvider("DOCUMENT_HISTORY_PROVIDER", si, Long.valueOf(20L), Long.valueOf(0L), new HashMap(), new Object[]{this.versions.get(1)});
        pp.setSearchDocumentModel(searchDoc);
        entries = pp.getCurrentPage();
        if (this.verbose) {
            System.out.println("Version " + this.versions.get(1).getVersionLabel() + " doc history");
            this.dump(entries);
        }
        int versin2EntriesCount = 15;
        Assert.assertEquals((long)versin2EntriesCount, (long)entries.size());
        Assert.assertEquals((long)startIdx, (long)((LogEntry)entries.get(0)).getId());
        Assert.assertEquals((long)(startIdx + (long)versin2EntriesCount), (long)((LogEntry)entries.get(versin2EntriesCount - 1)).getId());
    }
}

