/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.elasticsearch.LogEntryGen;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@Deploy(value={"org.nuxeo.runtime.metrics", "org.nuxeo.ecm.platform.audit.api", "org.nuxeo.ecm.platform.audit", "org.nuxeo.ecm.platform.uidgen.core", "org.nuxeo.elasticsearch.seqgen", "org.nuxeo.elasticsearch.seqgen.test:elasticsearch-seqgen-index-test-contrib.xml", "org.nuxeo.elasticsearch.audit"})
@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.audit:elasticsearch-test-contrib.xml", "org.nuxeo.elasticsearch.audit:elasticsearch-audit-index-test-contrib.xml", "org.nuxeo.elasticsearch.audit:audit-test-contrib.xml", "org.nuxeo.elasticsearch.audit:test-pageprovider-track-contrib.xml"})
public class TestPageProviderTracking {
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchAdmin esa;
    @Inject
    protected PageProviderService pps;

    @Before
    public void setupIndex() throws Exception {
        this.esa.initIndexes(true);
    }

    @Test
    public void shouldLogPageProviderCallsInAudit() throws Exception {
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        PageProvider pp = this.pps.getPageProvider("CURRENT_DOCUMENT_CHILDREN_TRACK", null, Long.valueOf(10L), Long.valueOf(0L), props, new Object[]{this.session.getRootDocument().getId()});
        Assert.assertNotNull((Object)pp);
        AuditReader reader = (AuditReader)Framework.getLocalService(AuditReader.class);
        List trail = reader.queryLogs(new String[]{"search"}, null);
        Assert.assertEquals((long)0L, (long)trail.size());
        pp.getCurrentPage();
        LogEntryGen.flushAndSync();
        trail = reader.queryLogs(new String[]{"search"}, null);
        Assert.assertEquals((long)1L, (long)trail.size());
        LogEntry entry = (LogEntry)trail.get(0);
        Assert.assertEquals((Object)this.session.getPrincipal().getName(), (Object)entry.getPrincipalName());
        Assert.assertEquals((Object)"search", (Object)entry.getEventId());
        Assert.assertEquals((Object)"CURRENT_DOCUMENT_CHILDREN_TRACK", (Object)((ExtendedInfo)entry.getExtendedInfos().get("pageProviderName")).getSerializableValue());
        Assert.assertEquals((Object)0L, (Object)((ExtendedInfo)entry.getExtendedInfos().get("pageIndex")).getSerializableValue());
        Assert.assertEquals((Object)0L, (Object)((ExtendedInfo)entry.getExtendedInfos().get("resultsCountInPage")).getSerializableValue());
        Assert.assertTrue((boolean)((String)((Object)((ExtendedInfo)entry.getExtendedInfos().get("params")).getSerializableValue())).contains(this.session.getRootDocument().getId()));
        pp.getCurrentPage();
        LogEntryGen.flushAndSync();
        trail = reader.queryLogs(new String[]{"search"}, null);
        Assert.assertEquals((long)2L, (long)trail.size());
    }
}

