/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.test.PlatformFeature;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.elasticsearch.LogEntryGen;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@Deploy(value={"org.nuxeo.runtime.metrics", "org.nuxeo.ecm.platform.audit.api", "org.nuxeo.ecm.platform.audit", "org.nuxeo.ecm.platform.uidgen.core", "org.nuxeo.elasticsearch.seqgen", "org.nuxeo.elasticsearch.seqgen.test:elasticsearch-seqgen-index-test-contrib.xml", "org.nuxeo.elasticsearch.audit"})
@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class, PlatformFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.audit:elasticsearch-test-contrib.xml", "org.nuxeo.elasticsearch.audit:elasticsearch-audit-index-test-contrib.xml", "org.nuxeo.elasticsearch.audit:audit-test-contrib.xml"})
public class TestUserGroupAudit {
    @Inject
    protected ElasticSearchAdmin esa;
    @Inject
    protected UserManager userManager;
    @Inject
    protected PageProviderService pps;
    @Inject
    protected CoreSession session;

    @Before
    public void setupIndex() throws Exception {
        this.esa.initIndexes(true);
    }

    @Test
    public void testAuditEntriesForUserCUD() throws Exception {
        AuditReader reader = (AuditReader)Framework.getLocalService(AuditReader.class);
        List entries = null;
        String userName = "testUser";
        entries = reader.queryLogs(new String[]{"user_created"}, null);
        Assert.assertEquals((long)0L, (long)entries.size());
        DocumentModel newUser = this.userManager.getBareUserModel();
        newUser.setProperty("user", "username", (Object)userName);
        newUser = this.userManager.createUser(newUser);
        LogEntryGen.flushAndSync();
        entries = reader.queryLogs(new String[]{"user_created"}, null);
        Assert.assertEquals((long)1L, (long)entries.size());
        entries = reader.queryLogs(new String[]{"user_modified"}, null);
        Assert.assertEquals((long)0L, (long)entries.size());
        ArrayList<String> staticGroups = new ArrayList<String>();
        staticGroups.add("StaticGroup");
        newUser = this.userManager.getUserModel(userName);
        newUser.setProperty("user", "groups", staticGroups);
        this.userManager.updateUser(newUser);
        LogEntryGen.flushAndSync();
        entries = reader.queryLogs(new String[]{"user_modified"}, null);
        Assert.assertEquals((long)1L, (long)entries.size());
        entries = reader.queryLogs(new String[]{"user_deleted"}, null);
        Assert.assertEquals((long)0L, (long)entries.size());
        this.userManager.deleteUser(newUser);
        LogEntryGen.flushAndSync();
        entries = reader.queryLogs(new String[]{"user_deleted"}, null);
        Assert.assertEquals((long)1L, (long)entries.size());
    }

    @Test
    public void testAuditEntriesForGroupCUD() throws Exception {
        AuditReader reader = (AuditReader)Framework.getLocalService(AuditReader.class);
        List entries = null;
        String groupName = "testGroup";
        entries = reader.queryLogs(new String[]{"group_created"}, null);
        Assert.assertEquals((long)0L, (long)entries.size());
        DocumentModel groupModel = this.userManager.getBareGroupModel();
        groupModel.setProperty("group", "groupname", (Object)groupName);
        groupModel = this.userManager.createGroup(groupModel);
        LogEntryGen.flushAndSync();
        entries = reader.queryLogs(new String[]{"group_created"}, null);
        Assert.assertEquals((long)1L, (long)entries.size());
        entries = reader.queryLogs(new String[]{"group_modified"}, null);
        Assert.assertEquals((long)0L, (long)entries.size());
        this.userManager.updateGroup(groupModel);
        LogEntryGen.flushAndSync();
        entries = reader.queryLogs(new String[]{"group_modified"}, null);
        Assert.assertEquals((long)1L, (long)entries.size());
        entries = reader.queryLogs(new String[]{"group_deleted"}, null);
        Assert.assertEquals((long)0L, (long)entries.size());
        this.userManager.deleteGroup(groupModel);
        LogEntryGen.flushAndSync();
        entries = reader.queryLogs(new String[]{"group_deleted"}, null);
        Assert.assertEquals((long)1L, (long)entries.size());
    }

    @Test
    public void testRetrieveLatestCreatedUsersOrGroups() throws Exception {
        String userName = "testUser";
        String groupName = "testGroup";
        long LIMIT = 10L;
        int i = 0;
        while ((long)i < 10L) {
            if (i % 2 == 0) {
                DocumentModel newUser = this.userManager.getBareUserModel();
                newUser.setProperty("user", "username", (Object)(userName + i));
                newUser = this.userManager.createUser(newUser);
            } else {
                DocumentModel groupModel = this.userManager.getBareGroupModel();
                groupModel.setProperty("group", "groupname", (Object)(groupName + i));
                groupModel = this.userManager.createGroup(groupModel);
            }
            ++i;
        }
        LogEntryGen.flushAndSync();
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        PageProvider pp = this.pps.getPageProvider("LATEST_CREATED_USERS_OR_GROUPS_PROVIDER", null, Long.valueOf(10L), Long.valueOf(0L), props, new Object[]{this.session.getRootDocument().getId()});
        List latestCreatedUsers = pp.getCurrentPage();
        Assert.assertEquals((long)10L, (long)latestCreatedUsers.size());
    }
}

