/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.service;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.AuditBulker;
import org.nuxeo.ecm.platform.audit.service.extension.AuditBulkerDescriptor;
import org.nuxeo.ecm.platform.audit.service.management.AuditBulkerMBean;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.ResourcePublisher;
import org.nuxeo.runtime.metrics.MetricsService;

public class DefaultAuditBulker
implements AuditBulkerMBean,
AuditBulker {
    final Log log = LogFactory.getLog(DefaultAuditBulker.class);
    final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    final Gauge<Integer> sizeGauge = new Gauge<Integer>(){

        public Integer getValue() {
            return DefaultAuditBulker.this.queue.size();
        }
    };
    final AuditBackend backend;
    final Counter queuedCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"audit", "queued"}));
    final Counter drainedCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"audit", "drained"}));
    int timeout;
    int size;
    Thread thread;
    final ReentrantLock lock = new ReentrantLock();
    final Condition isEmpty = this.lock.newCondition();
    final Condition isFilled = this.lock.newCondition();
    final Queue<LogEntry> queue = new ConcurrentLinkedQueue<LogEntry>();
    volatile boolean stopped;

    DefaultAuditBulker(AuditBackend backend, AuditBulkerDescriptor config) {
        this.backend = backend;
        this.timeout = config.timeout;
        this.size = config.size;
    }

    @Override
    public void onApplicationStarted() {
        this.thread = new Thread((Runnable)new Consumer(), "Nuxeo-Audit-Bulker");
        this.thread.start();
        ResourcePublisher publisher = (ResourcePublisher)Framework.getService(ResourcePublisher.class);
        if (publisher != null) {
            publisher.registerResource("audit-bulker", "audit-bulker", AuditBulkerMBean.class, (Object)this);
        }
        this.registry.register(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"audit", "size"}), this.sizeGauge);
    }

    @Override
    public void onShutdown() {
        this.registry.remove(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"audit", "size"}));
        ResourcePublisher publisher = (ResourcePublisher)Framework.getService(ResourcePublisher.class);
        if (publisher != null) {
            publisher.unregisterResource("audit-bulker", "audit-bulker");
        }
        this.stopped = true;
        try {
            this.thread.interrupt();
        }
        finally {
            this.thread = null;
        }
    }

    @Override
    public void offer(LogEntry entry) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("offered " + entry));
        }
        this.queue.add(entry);
        this.queuedCount.inc();
        if (this.queue.size() >= this.size) {
            this.lock.lock();
            try {
                this.isFilled.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        if (this.queue.isEmpty()) {
            return true;
        }
        this.lock.lock();
        try {
            this.isFilled.signalAll();
            boolean bl = this.isEmpty.await(time, unit);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    int drain() {
        LinkedList<LogEntry> entries = new LinkedList<LogEntry>();
        while (!this.queue.isEmpty()) {
            entries.add(this.queue.remove());
        }
        this.backend.addLogEntries(entries);
        this.drainedCount.inc((long)entries.size());
        if (this.queue.isEmpty()) {
            this.lock.lock();
            try {
                this.isEmpty.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
        return entries.size();
    }

    @Override
    public int getBulkTimeout() {
        return this.timeout;
    }

    @Override
    public void setBulkTimeout(int value) {
        this.timeout = value;
    }

    @Override
    public int getBulkSize() {
        return this.size;
    }

    @Override
    public void setBulkSize(int value) {
        this.size = value;
    }

    @Override
    public void resetMetrics() {
        this.queuedCount.dec(this.queuedCount.getCount());
        this.drainedCount.dec(this.drainedCount.getCount());
    }

    class Consumer
    implements Runnable {
        Consumer() {
        }

        @Override
        public void run() {
            DefaultAuditBulker.this.log.info((Object)"bulk audit logger started");
            while (!DefaultAuditBulker.this.stopped) {
                DefaultAuditBulker.this.lock.lock();
                try {
                    DefaultAuditBulker.this.isFilled.await(DefaultAuditBulker.this.timeout, TimeUnit.MILLISECONDS);
                    if (DefaultAuditBulker.this.queue.isEmpty()) {
                        continue;
                    }
                }
                catch (InterruptedException cause) {
                    Thread.currentThread().interrupt();
                    return;
                }
                finally {
                    DefaultAuditBulker.this.lock.unlock();
                    continue;
                }
                try {
                    int count = DefaultAuditBulker.this.drain();
                    if (!DefaultAuditBulker.this.log.isDebugEnabled()) continue;
                    DefaultAuditBulker.this.log.debug((Object)("flushed " + count + " events"));
                }
                catch (RuntimeException cause) {
                    DefaultAuditBulker.this.log.error((Object)"caught error while draining audit queue", (Throwable)cause);
                }
            }
            DefaultAuditBulker.this.log.info((Object)"bulk audit logger stopped");
        }
    }
}

