/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.InverseReference;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.ecm.directory.sql.SQLStaticFilter;
import org.nuxeo.ecm.directory.sql.TableReference;

@XObject(value="directory")
public class SQLDirectoryDescriptor
extends BaseDirectoryDescriptor {
    private static final Log log = LogFactory.getLog(SQLDirectoryDescriptor.class);
    public static final int QUERY_SIZE_LIMIT_DEFAULT = 0;
    public static final boolean AUTO_INCREMENT_ID_FIELD_DEFAULT = false;
    public static final char DEFAULT_CHARACTER_SEPARATOR = ',';
    public static final String[] CREATE_TABLE_POLICIES = new String[]{"never", "on_missing_columns", "always"};
    public static final String CREATE_TABLE_POLICY_DEFAULT = "never";
    @XNode(value="dataSource")
    public String dataSourceName;
    @XNode(value="dbDriver")
    public String dbDriver;
    @XNode(value="dbUrl")
    public String dbUrl;
    @XNode(value="dbUser")
    public String dbUser;
    @XNode(value="dbPassword")
    public String dbPassword;
    @XNode(value="dataFile")
    public String dataFileName;
    @XNode(value="dataFileCharacterSeparator", trim=false)
    public String dataFileCharacterSeparator = ",";
    public String createTablePolicy;
    @XNode(value="autoincrementIdField")
    public Boolean autoincrementIdField;
    @XNode(value="querySizeLimit")
    private Integer querySizeLimit;
    @XNodeList(value="references/tableReference", type=TableReference[].class, componentType=TableReference.class)
    private TableReference[] tableReferences;
    @XNodeList(value="references/inverseReference", type=InverseReference[].class, componentType=InverseReference.class)
    private InverseReference[] inverseReferences;
    @XNodeList(value="filters/staticFilter", type=SQLStaticFilter[].class, componentType=SQLStaticFilter.class)
    private SQLStaticFilter[] staticFilters;
    @XNode(value="nativeCase")
    public Boolean nativeCase;
    @XNode(value="computeMultiTenantId")
    private boolean computeMultiTenantId = true;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public char getDataFileCharacterSeparator() {
        if (this.dataFileCharacterSeparator == null || this.dataFileCharacterSeparator.length() == 0) {
            log.info((Object)"Character separator not well set will take the default value, \",\"");
            return ',';
        }
        if (this.dataFileCharacterSeparator.length() > 1) {
            log.warn((Object)("More than one character found for character separator, will take the first one \"" + this.dataFileCharacterSeparator.charAt(0) + "\""));
        }
        return this.dataFileCharacterSeparator.charAt(0);
    }

    public String getCreateTablePolicy() {
        return this.createTablePolicy;
    }

    @XNode(value="createTablePolicy")
    public void setCreateTablePolicy(String createTablePolicy) throws DirectoryException {
        if (createTablePolicy == null) {
            this.createTablePolicy = CREATE_TABLE_POLICY_DEFAULT;
            return;
        }
        createTablePolicy = createTablePolicy.toLowerCase();
        boolean validPolicy = false;
        for (String policy : CREATE_TABLE_POLICIES) {
            if (!createTablePolicy.equals(policy)) continue;
            validPolicy = true;
            break;
        }
        if (!validPolicy) {
            throw new DirectoryException("invalid value for createTablePolicy: " + createTablePolicy + ". It should be one of 'never', " + "'on_missing_columns',  or 'always'.");
        }
        this.createTablePolicy = createTablePolicy;
    }

    public Reference[] getInverseReferences() {
        return this.inverseReferences;
    }

    public Reference[] getTableReferences() {
        return this.tableReferences;
    }

    public boolean isAutoincrementIdField() {
        return this.autoincrementIdField == null ? false : this.autoincrementIdField;
    }

    public void setAutoincrementIdField(boolean autoincrementIdField) {
        this.autoincrementIdField = autoincrementIdField;
    }

    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public void setInverseReferences(InverseReference[] inverseReferences) {
        this.inverseReferences = inverseReferences;
    }

    public void setDataFileName(String dataFile) {
        this.dataFileName = dataFile;
    }

    public void setTableReferences(TableReference[] tableReferences) {
        this.tableReferences = tableReferences;
    }

    public int getQuerySizeLimit() {
        return this.querySizeLimit == null ? 0 : this.querySizeLimit;
    }

    public void setQuerySizeLimit(int querySizeLimit) {
        this.querySizeLimit = querySizeLimit;
    }

    public SQLStaticFilter[] getStaticFilters() {
        if (this.staticFilters == null) {
            return new SQLStaticFilter[0];
        }
        return this.staticFilters;
    }

    public boolean isComputeMultiTenantId() {
        return this.computeMultiTenantId;
    }

    public void merge(BaseDirectoryDescriptor other) {
        super.merge(other);
        if (other instanceof SQLDirectoryDescriptor) {
            this.merge((SQLDirectoryDescriptor)other);
        }
    }

    protected void merge(SQLDirectoryDescriptor other) {
        if (other.dataSourceName != null) {
            this.dataSourceName = other.dataSourceName;
        }
        if (other.dbDriver != null) {
            this.dbDriver = other.dbDriver;
        }
        if (other.dbUrl != null) {
            this.dbUrl = other.dbUrl;
        }
        if (other.dbUser != null) {
            this.dbUser = other.dbUser;
        }
        if (other.dbPassword != null) {
            this.dbPassword = other.dbPassword;
        }
        if (other.dataFileName != null) {
            this.dataFileName = other.dataFileName;
        }
        if (other.dataFileCharacterSeparator != null) {
            this.dataFileCharacterSeparator = other.dataFileCharacterSeparator;
        }
        if (other.createTablePolicy != null) {
            this.createTablePolicy = other.createTablePolicy;
        }
        if (other.autoincrementIdField != null) {
            this.autoincrementIdField = other.autoincrementIdField;
        }
        if (other.querySizeLimit != null) {
            this.querySizeLimit = other.querySizeLimit;
        }
        if (other.inverseReferences != null && other.inverseReferences.length != 0) {
            this.inverseReferences = other.inverseReferences;
        }
        if (other.tableReferences != null && other.tableReferences.length != 0) {
            this.tableReferences = other.tableReferences;
        }
        if (other.staticFilters != null && other.staticFilters.length != 0) {
            this.staticFilters = other.staticFilters;
        }
        if (other.nativeCase != null) {
            this.nativeCase = other.nativeCase;
        }
        this.computeMultiTenantId = other.computeMultiTenantId;
    }

    public SQLDirectoryDescriptor clone() {
        int i;
        SQLDirectoryDescriptor clone = (SQLDirectoryDescriptor)super.clone();
        if (this.tableReferences != null) {
            clone.tableReferences = new TableReference[this.tableReferences.length];
            for (i = 0; i < this.tableReferences.length; ++i) {
                clone.tableReferences[i] = this.tableReferences[i].clone();
            }
        }
        if (this.inverseReferences != null) {
            clone.inverseReferences = new InverseReference[this.inverseReferences.length];
            for (i = 0; i < this.inverseReferences.length; ++i) {
                clone.inverseReferences[i] = this.inverseReferences[i].clone();
            }
        }
        if (this.staticFilters != null) {
            clone.staticFilters = new SQLStaticFilter[this.staticFilters.length];
            for (i = 0; i < this.staticFilters.length; ++i) {
                clone.staticFilters[i] = this.staticFilters[i].clone();
            }
        }
        return clone;
    }

    public SQLDirectory newDirectory() {
        return new SQLDirectory(this);
    }
}

