/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.test;

import com.google.inject.Scope;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.core.test.CoreScope;
import org.nuxeo.ecm.core.test.StorageConfiguration;
import org.nuxeo.ecm.core.test.TransactionalFeature;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.core.test.annotations.RepositoryInit;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.model.StreamRef;
import org.nuxeo.runtime.model.URLStreamRef;
import org.nuxeo.runtime.test.runner.Defaults;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.test.runner.ServiceProvider;
import org.nuxeo.runtime.test.runner.SimpleFeature;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Deploy(value={"org.nuxeo.runtime.management", "org.nuxeo.runtime.metrics", "org.nuxeo.ecm.core.schema", "org.nuxeo.ecm.core.query", "org.nuxeo.ecm.core.api", "org.nuxeo.ecm.core.event", "org.nuxeo.ecm.core", "org.nuxeo.ecm.core.test", "org.nuxeo.ecm.core.mimetype", "org.nuxeo.ecm.core.convert", "org.nuxeo.ecm.core.convert.plugins", "org.nuxeo.ecm.core.storage", "org.nuxeo.ecm.core.storage.sql", "org.nuxeo.ecm.core.storage.sql.test", "org.nuxeo.ecm.core.storage.dbs", "org.nuxeo.ecm.core.storage.mem", "org.nuxeo.ecm.core.storage.mongodb"})
@Features(value={RuntimeFeature.class, TransactionalFeature.class})
@LocalDeploy(value={"org.nuxeo.ecm.core.event:test-queuing.xml"})
public class CoreFeature
extends SimpleFeature {
    private static final Log log = LogFactory.getLog(CoreFeature.class);
    protected StorageConfiguration storageConfiguration;
    protected RepositoryInit repositoryInit;
    protected Granularity granularity;
    protected CoreSession session;
    protected boolean cleaned;
    protected TransactionalFeature txFeature;

    public StorageConfiguration getStorageConfiguration() {
        return this.storageConfiguration;
    }

    public void initialize(FeaturesRunner runner) {
        this.storageConfiguration = new StorageConfiguration(this);
        this.txFeature = (TransactionalFeature)runner.getFeature(TransactionalFeature.class);
        this.txFeature.addWaiter(new TransactionalFeature.Waiter(){

            @Override
            public boolean await(long deadline) throws InterruptedException {
                return ((WorkManager)Framework.getService(WorkManager.class)).awaitCompletion(deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
        });
        ((RuntimeFeature)runner.getFeature(RuntimeFeature.class)).addServiceProvider((ServiceProvider)new CoreSessionServiceProvider());
        RepositoryConfig repositoryConfig = (RepositoryConfig)runner.getConfig(RepositoryConfig.class);
        if (repositoryConfig == null) {
            repositoryConfig = (RepositoryConfig)Defaults.of(RepositoryConfig.class);
        }
        try {
            this.repositoryInit = repositoryConfig.init().newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
        Granularity cleanup = repositoryConfig.cleanup();
        this.granularity = cleanup == Granularity.UNDEFINED ? Granularity.CLASS : cleanup;
    }

    public Granularity getGranularity() {
        return this.granularity;
    }

    public void start(FeaturesRunner runner) {
        try {
            RuntimeHarness harness = ((RuntimeFeature)runner.getFeature(RuntimeFeature.class)).getHarness();
            this.storageConfiguration.init();
            URL blobContribUrl = this.storageConfiguration.getBlobManagerContrib(runner);
            harness.getContext().deploy((StreamRef)new URLStreamRef(blobContribUrl));
            URL repoContribUrl = this.storageConfiguration.getRepositoryContrib(runner);
            harness.getContext().deploy((StreamRef)new URLStreamRef(repoContribUrl));
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public void beforeRun(FeaturesRunner runner) throws InterruptedException {
        this.txFeature.nextTransaction(10L, TimeUnit.SECONDS);
        if (this.granularity != Granularity.METHOD) {
            TransactionHelper.startTransaction();
            this.initializeSession(runner);
            TransactionHelper.commitOrRollbackTransaction();
        }
    }

    public void afterRun(FeaturesRunner runner) {
        Collection leakedInfos;
        this.waitForAsyncCompletion();
        if (this.granularity != Granularity.METHOD) {
            this.cleanupSession(runner);
        }
        if (this.session != null) {
            this.releaseCoreSession();
        }
        if ((leakedInfos = CoreInstance.getInstance().getRegistrationInfos()).size() == 0) {
            return;
        }
        AssertionError leakedErrors = new AssertionError((Object)String.format("leaked %d sessions", leakedInfos.size()));
        for (CoreInstance.RegistrationInfo info : leakedInfos) {
            try {
                info.session.close();
                ((Throwable)((Object)leakedErrors)).addSuppressed((Throwable)info);
            }
            catch (RuntimeException cause) {
                ((Throwable)((Object)leakedErrors)).addSuppressed(cause);
            }
        }
        throw leakedErrors;
    }

    public void beforeSetup(FeaturesRunner runner) {
        if (this.granularity == Granularity.METHOD) {
            this.initializeSession(runner);
        }
    }

    public void afterTeardown(FeaturesRunner runner) {
        if (this.granularity == Granularity.METHOD) {
            this.cleanupSession(runner);
        } else {
            this.waitForAsyncCompletion();
        }
    }

    protected void waitForAsyncCompletion() {
        this.txFeature.nextTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupSession(FeaturesRunner runner) {
        this.waitForAsyncCompletion();
        if (TransactionHelper.isTransactionMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
        if (this.session == null) {
            this.createCoreSession();
        }
        try {
            Throwable throwable;
            IterableQueryResult results2;
            log.trace((Object)"remove everything except root");
            try {
                results2 = this.session.queryAndFetch("SELECT ecm:uuid FROM Document WHERE ecm:isProxy = 1", "NXQL", new Object[0]);
                throwable = null;
                try {
                    this.batchRemoveDocuments(results2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (results2 != null) {
                        if (throwable != null) {
                            try {
                                results2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            results2.close();
                        }
                    }
                }
            }
            catch (QueryParseException results2) {
                // empty catch block
            }
            this.session.removeChildren((DocumentRef)new PathRef("/"));
            log.trace((Object)"remove orphan versions as OrphanVersionRemoverListener is not triggered by CoreSession#removeChildren");
            results2 = this.session.queryAndFetch("SELECT ecm:uuid FROM Document, Relation", "NXQL", new Object[0]);
            throwable = null;
            try {
                this.batchRemoveDocuments(results2);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (results2 != null) {
                    if (throwable != null) {
                        try {
                            results2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        results2.close();
                    }
                }
            }
            this.session.save();
            this.waitForAsyncCompletion();
            if (!this.session.query("SELECT * FROM Document, Relation").isEmpty()) {
                log.error((Object)"Fail to cleanupSession, repository will not be empty for the next test.");
            }
        }
        catch (NuxeoException e) {
            log.error((Object)"Unable to reset repository", (Throwable)e);
        }
        finally {
            CoreScope.INSTANCE.exit();
        }
        this.releaseCoreSession();
        this.cleaned = true;
    }

    protected void batchRemoveDocuments(IterableQueryResult results) {
        String rootDocumentId = this.session.getRootDocument().getId();
        ArrayList<DocumentRef> ids = new ArrayList<DocumentRef>();
        for (Map result : results) {
            String id = (String)result.get("ecm:uuid");
            if (id.equals(rootDocumentId)) continue;
            ids.add((DocumentRef)new IdRef(id));
            if (ids.size() < 100) continue;
            this.batchRemoveDocuments(ids);
            ids.clear();
        }
        if (!ids.isEmpty()) {
            this.batchRemoveDocuments(ids);
        }
    }

    protected void batchRemoveDocuments(List<DocumentRef> ids) {
        this.session.removeDocuments(ids.toArray(new DocumentRef[0]));
    }

    protected void initializeSession(FeaturesRunner runner) {
        if (this.cleaned) {
            RepositoryService repositoryService = (RepositoryService)Framework.getLocalService(RepositoryService.class);
            repositoryService.applicationStarted(null);
            this.cleaned = false;
        }
        CoreScope.INSTANCE.enter();
        this.createCoreSession();
        if (this.repositoryInit != null) {
            this.repositoryInit.populate(this.session);
            this.session.save();
            this.waitForAsyncCompletion();
        }
    }

    public String getRepositoryName() {
        return this.getStorageConfiguration().getRepositoryName();
    }

    public CoreSession openCoreSession(String username) {
        return CoreInstance.openCoreSession((String)this.getRepositoryName(), (String)username);
    }

    public CoreSession openCoreSession(NuxeoPrincipal principal) {
        return CoreInstance.openCoreSession((String)this.getRepositoryName(), (NuxeoPrincipal)principal);
    }

    public CoreSession openCoreSession() {
        return CoreInstance.openCoreSession((String)this.getRepositoryName());
    }

    public CoreSession openCoreSessionSystem() {
        return CoreInstance.openCoreSessionSystem((String)this.getRepositoryName());
    }

    public CoreSession createCoreSession() {
        UserPrincipal principal = new UserPrincipal("Administrator", new ArrayList(), false, true);
        this.session = CoreInstance.openCoreSession((String)this.getRepositoryName(), (NuxeoPrincipal)principal);
        return this.session;
    }

    public CoreSession getCoreSession() {
        return this.session;
    }

    public void releaseCoreSession() {
        this.session.close();
        this.session = null;
    }

    public CoreSession reopenCoreSession() {
        this.releaseCoreSession();
        this.waitForAsyncCompletion();
        NuxeoContainer.resetConnectionManager();
        this.createCoreSession();
        return this.session;
    }

    protected class CoreSessionServiceProvider
    extends ServiceProvider<CoreSession> {
        public CoreSessionServiceProvider() {
            super(CoreSession.class);
        }

        public Scope getScope() {
            return CoreScope.INSTANCE;
        }

        public CoreSession get() {
            return CoreFeature.this.session;
        }
    }
}

