/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.test;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.inject.Inject;
import org.apache.commons.logging.LogFactory;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.nuxeo.runtime.management.jvm.ThreadDeadlocksDetector;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.SimpleFeature;

public class DetectThreadDeadlocksFeature
extends SimpleFeature {
    @Inject
    protected RunNotifier notifier;
    protected ThreadDeadlocksDetector detector = new ThreadDeadlocksDetector();
    protected Config config;
    protected final RunListener listener = new RunListener(){

        public void testFailure(Failure failure) throws Exception {
            DetectThreadDeadlocksFeature.this.dump();
        }
    };

    public void initialize(FeaturesRunner runner) throws Exception {
        this.config = (Config)runner.getConfig(Config.class);
    }

    public void beforeRun(FeaturesRunner runner) throws Exception {
        runner.getInjector().injectMembers((Object)this);
        if (this.config.dumpOnFailure()) {
            this.notifier.addListener(this.listener);
        }
        this.detector.schedule(30000L, (ThreadDeadlocksDetector.Listener)new ThreadDeadlocksDetector.KillListener());
    }

    public void stop(FeaturesRunner runner) throws Exception {
        if (this.config.dumpOnFailure()) {
            this.notifier.removeListener(this.listener);
        }
        if (this.config.dumpAtTearDown()) {
            this.dump();
        }
        this.detector.cancel();
    }

    protected void dump() throws IOException {
        long[] detectThreadLock = this.detector.detectThreadLock();
        File dump = this.detector.dump(detectThreadLock);
        LogFactory.getLog(DetectThreadDeadlocksFeature.class).warn((Object)("Thread dump available at " + dump));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Config {
        public boolean dumpAtTearDown() default false;

        public boolean dumpOnFailure() default true;
    }
}

