/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.test;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepository;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.DatabaseDB2;
import org.nuxeo.ecm.core.storage.sql.DatabaseDerby;
import org.nuxeo.ecm.core.storage.sql.DatabaseH2;
import org.nuxeo.ecm.core.storage.sql.DatabaseHelper;
import org.nuxeo.ecm.core.storage.sql.DatabaseMySQL;
import org.nuxeo.ecm.core.storage.sql.DatabaseOracle;
import org.nuxeo.ecm.core.storage.sql.DatabasePostgreSQL;
import org.nuxeo.ecm.core.storage.sql.DatabaseSQLServer;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.RuntimeHarness;

public class StorageConfiguration {
    private static final Log log = LogFactory.getLog(StorageConfiguration.class);
    public static final String CORE_PROPERTY = "nuxeo.test.core";
    public static final String CORE_VCS = "vcs";
    public static final String CORE_MEM = "mem";
    public static final String CORE_MONGODB = "mongodb";
    public static final String DEFAULT_CORE = "vcs";
    private static final String MONGODB_SERVER_PROPERTY = "nuxeo.test.mongodb.server";
    private static final String MONGODB_DBNAME_PROPERTY = "nuxeo.test.mongodb.dbname";
    private static final String DEFAULT_MONGODB_SERVER = "localhost:27017";
    private static final String DEFAULT_MONGODB_DBNAME = "unittests";
    private String coreType = StorageConfiguration.defaultSystemProperty("nuxeo.test.core", "vcs");
    private boolean isVCS;
    private boolean isDBS;
    private DatabaseHelper databaseHelper;
    final CoreFeature feature;

    public StorageConfiguration(CoreFeature feature) {
        this.feature = feature;
    }

    protected static String defaultSystemProperty(String name, String def) {
        String value = System.getProperty(name);
        if (value == null || value.equals("") || value.equals("${" + name + "}")) {
            value = def;
            System.setProperty(name, value);
        }
        return value;
    }

    protected static String defaultProperty(String name, String def) {
        String value = System.getProperty(name);
        if (value == null || value.equals("") || value.equals("${" + name + "}")) {
            value = def;
        }
        Framework.getProperties().setProperty(name, value);
        return value;
    }

    protected void init() {
        this.initJDBC();
        switch (this.coreType) {
            case "vcs": {
                this.isVCS = true;
                break;
            }
            case "mem": {
                this.isDBS = true;
                break;
            }
            case "mongodb": {
                this.isDBS = true;
                this.initMongoDB();
                break;
            }
            default: {
                throw new ExceptionInInitializerError("Unknown test core mode: " + this.coreType);
            }
        }
    }

    protected void initJDBC() {
        this.databaseHelper = DatabaseHelper.DATABASE;
        String msg = "Deploying JDBC using " + this.databaseHelper.getClass().getSimpleName();
        System.out.println(this.getClass().getSimpleName() + ": " + msg);
        log.info((Object)msg);
        try {
            this.databaseHelper.setUp();
        }
        catch (SQLException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected void initMongoDB() {
        String server = StorageConfiguration.defaultProperty(MONGODB_SERVER_PROPERTY, DEFAULT_MONGODB_SERVER);
        String dbname = StorageConfiguration.defaultProperty(MONGODB_DBNAME_PROPERTY, DEFAULT_MONGODB_DBNAME);
        MongoDBRepositoryDescriptor descriptor = new MongoDBRepositoryDescriptor();
        descriptor.name = this.getRepositoryName();
        descriptor.server = server;
        descriptor.dbname = dbname;
        try {
            this.clearMongoDB(descriptor);
        }
        catch (UnknownHostException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearMongoDB(MongoDBRepositoryDescriptor descriptor) throws UnknownHostException {
        try (MongoClient mongoClient = MongoDBRepository.newMongoClient((MongoDBRepositoryDescriptor)descriptor);){
            DBCollection coll = MongoDBRepository.getCollection((MongoDBRepositoryDescriptor)descriptor, (MongoClient)mongoClient);
            coll.dropIndexes();
            coll.remove((DBObject)new BasicDBObject());
            coll = MongoDBRepository.getCountersCollection((MongoDBRepositoryDescriptor)descriptor, (MongoClient)mongoClient);
            coll.dropIndexes();
            coll.remove((DBObject)new BasicDBObject());
        }
    }

    public boolean isVCS() {
        return this.isVCS;
    }

    public boolean isVCSH2() {
        return this.isVCS && this.databaseHelper instanceof DatabaseH2;
    }

    public boolean isVCSDerby() {
        return this.isVCS && this.databaseHelper instanceof DatabaseDerby;
    }

    public boolean isVCSPostgreSQL() {
        return this.isVCS && this.databaseHelper instanceof DatabasePostgreSQL;
    }

    public boolean isVCSMySQL() {
        return this.isVCS && this.databaseHelper instanceof DatabaseMySQL;
    }

    public boolean isVCSOracle() {
        return this.isVCS && this.databaseHelper instanceof DatabaseOracle;
    }

    public boolean isVCSSQLServer() {
        return this.isVCS && this.databaseHelper instanceof DatabaseSQLServer;
    }

    public boolean isVCSDB2() {
        return this.isVCS && this.databaseHelper instanceof DatabaseDB2;
    }

    public boolean isDBS() {
        return this.isDBS;
    }

    public boolean isDBSMem() {
        return this.isDBS && CORE_MEM.equals(this.coreType);
    }

    public boolean isDBSMongoDB() {
        return this.isDBS && CORE_MONGODB.equals(this.coreType);
    }

    public String getRepositoryName() {
        return "test";
    }

    public void sleepForFulltext() {
        if (this.isVCS()) {
            this.databaseHelper.sleepForFulltext();
        }
    }

    public void maybeSleepToNextSecond() {
        if (this.isVCS()) {
            this.databaseHelper.maybeSleepToNextSecond();
        }
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public boolean hasSubSecondResolution() {
        if (this.isVCS()) {
            return this.databaseHelper.hasSubSecondResolution();
        }
        return true;
    }

    public void waitForAsyncCompletion() {
        this.feature.waitForAsyncCompletion();
    }

    public void waitForFulltextIndexing() {
        this.waitForAsyncCompletion();
        this.sleepForFulltext();
    }

    public boolean supportsMultipleFulltextIndexes() {
        if (this.isVCS()) {
            return this.databaseHelper.supportsMultipleFulltextIndexes();
        }
        return false;
    }

    public URL getBlobManagerContrib(FeaturesRunner runner) {
        String bundleName = "org.nuxeo.ecm.core.test";
        String contribPath = "OSGI-INF/test-storage-blob-contrib.xml";
        RuntimeHarness harness = ((RuntimeFeature)runner.getFeature(RuntimeFeature.class)).getHarness();
        BundleImpl bundle = harness.getOSGiAdapter().getRegistry().getBundle(bundleName);
        URL contribURL = bundle.getEntry(contribPath);
        Assert.assertNotNull((String)("deployment contrib " + contribPath + " not found"), (Object)contribURL);
        return contribURL;
    }

    public URL getRepositoryContrib(FeaturesRunner runner) {
        String contribPath;
        String bundleName;
        String msg;
        if (this.isVCS()) {
            msg = "Deploying a VCS repository";
        } else if (this.isDBS()) {
            msg = "Deploying a DBS repository using " + this.coreType;
        } else {
            throw new NuxeoException("Unkown test configuration (not vcs/dbs)");
        }
        System.out.println(this.getClass().getSimpleName() + ": " + msg);
        log.info((Object)msg);
        if (this.isVCS()) {
            bundleName = "org.nuxeo.ecm.core.storage.sql.test";
            contribPath = this.databaseHelper.getDeploymentContrib();
        } else {
            bundleName = "org.nuxeo.ecm.core.test";
            if (this.isDBSMem()) {
                contribPath = "OSGI-INF/test-storage-repo-mem-contrib.xml";
            } else if (this.isDBSMongoDB()) {
                contribPath = "OSGI-INF/test-storage-repo-mongodb-contrib.xml";
            } else {
                throw new NuxeoException("Unkown DBS test configuration (not mem/mongodb)");
            }
        }
        RuntimeHarness harness = ((RuntimeFeature)runner.getFeature(RuntimeFeature.class)).getHarness();
        BundleImpl bundle = harness.getOSGiAdapter().getRegistry().getBundle(bundleName);
        URL contribURL = bundle.getEntry(contribPath);
        Assert.assertNotNull((String)("deployment contrib " + contribPath + " not found"), (Object)contribURL);
        return contribURL;
    }

    public void assertEqualsTimestamp(Calendar expected, Calendar actual) {
        Assert.assertEquals((Object)this.convertToStoredCalendar(expected), (Object)this.convertToStoredCalendar(actual));
    }

    public void assertNotEqualsTimestamp(Calendar expected, Calendar actual) {
        Assert.assertNotEquals((Object)this.convertToStoredCalendar(expected), (Object)this.convertToStoredCalendar(actual));
    }

    public void assertBeforeTimestamp(Calendar expected, Calendar actual) {
        BiConsumer<Calendar, Calendar> assertTrue = (exp, act) -> Assert.assertTrue((String)String.format("expected=%s is not before actual=%s", exp, act), (boolean)exp.before(act));
        assertTrue.accept(this.convertToStoredCalendar(expected), this.convertToStoredCalendar(actual));
    }

    public void assertNotBeforeTimestamp(Calendar expected, Calendar actual) {
        BiConsumer<Calendar, Calendar> assertFalse = (exp, act) -> Assert.assertFalse((String)String.format("expected=%s is before actual=%s", exp, act), (boolean)exp.before(act));
        assertFalse.accept(this.convertToStoredCalendar(expected), this.convertToStoredCalendar(actual));
    }

    public void assertAfterTimestamp(Calendar expected, Calendar actual) {
        BiConsumer<Calendar, Calendar> assertTrue = (exp, act) -> Assert.assertTrue((String)String.format("expected=%s is not after actual=%s", exp, act), (boolean)exp.after(act));
        assertTrue.accept(this.convertToStoredCalendar(expected), this.convertToStoredCalendar(actual));
    }

    public void assertNotAfterTimestamp(Calendar expected, Calendar actual) {
        BiConsumer<Calendar, Calendar> assertFalse = (exp, act) -> Assert.assertFalse((String)String.format("expected=%s is after actual=%s", exp, act), (boolean)exp.after(act));
        assertFalse.accept(this.convertToStoredCalendar(expected), this.convertToStoredCalendar(actual));
    }

    private Calendar convertToStoredCalendar(Calendar calendar) {
        if (this.isVCSMySQL() || this.isVCSSQLServer()) {
            Calendar result = (Calendar)calendar.clone();
            result.setTimeInMillis(this.convertToStoredTimestamp(result.getTimeInMillis()));
            return result;
        }
        return calendar;
    }

    private long convertToStoredTimestamp(long timestamp) {
        if (this.isVCSMySQL()) {
            return timestamp / 1000L * 1000L;
        }
        if (this.isVCSSQLServer()) {
            long milliseconds = timestamp % 10L;
            long newTimestamp = timestamp - milliseconds;
            if (milliseconds == 9L) {
                newTimestamp += 10L;
            } else if (milliseconds >= 5L) {
                newTimestamp += 7L;
            } else if (milliseconds >= 2L) {
                newTimestamp += 3L;
            }
            return newTimestamp;
        }
        return timestamp;
    }
}

