/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.test;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.core.test.annotations.TransactionalConfig;
import org.nuxeo.runtime.management.jvm.ThreadDeadlocksDetector;
import org.nuxeo.runtime.test.runner.ContainerFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.SimpleFeature;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RepositoryConfig(cleanup=Granularity.METHOD)
@Features(value={ContainerFeature.class})
public class TransactionalFeature
extends SimpleFeature {
    protected TransactionalConfig config;
    protected String autoactivationValue;
    protected boolean nsOwner;
    protected boolean txStarted;
    final List<Waiter> waiters = new LinkedList<Waiter>();
    protected Class<? extends RepositoryFactory> defaultFactory;

    public void addWaiter(Waiter waiter) {
        this.waiters.add(waiter);
    }

    public void nextTransaction() {
        this.nextTransaction(2L, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void nextTransaction(long duration, TimeUnit unit) {
        long deadline = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(duration, unit);
        boolean tx = TransactionHelper.isTransactionActive();
        boolean rb = TransactionHelper.isTransactionMarkedRollback();
        if (tx || rb) {
            TransactionHelper.commitOrRollbackTransaction();
        }
        try {
            for (Waiter provider : this.waiters) {
                try {
                    Assert.assertTrue((boolean)this.await(provider, deadline));
                }
                catch (InterruptedException cause) {
                    Thread.currentThread().interrupt();
                    throw new AssertionError("interrupted while awaiting for asynch completion", cause);
                    return;
                }
            }
        }
        finally {
            if (tx || rb) {
                TransactionHelper.startTransaction();
                if (rb) {
                    TransactionHelper.setTransactionRollbackOnly();
                }
            }
        }
    }

    boolean await(Waiter waiter, long deadline) throws InterruptedException {
        if (waiter.await(deadline)) {
            return true;
        }
        try {
            File file = new ThreadDeadlocksDetector().dump(new long[0]);
            LogFactory.getLog(TransactionalFeature.class).warn((Object)("timed out in " + waiter.getClass() + ", thread dump available in " + file));
        }
        catch (IOException cause) {
            LogFactory.getLog(TransactionalFeature.class).warn((Object)("timed out in " + waiter.getClass() + ", cannot take thread dump"), (Throwable)cause);
        }
        return false;
    }

    public void initialize(FeaturesRunner runner) throws Exception {
        this.config = (TransactionalConfig)runner.getConfig(TransactionalConfig.class);
    }

    public void beforeSetup(FeaturesRunner runner) throws Exception {
        if (!this.config.autoStart()) {
            return;
        }
        this.txStarted = TransactionHelper.startTransaction();
    }

    public void afterTeardown(FeaturesRunner runner) throws Exception {
        if (!this.txStarted) {
            if (TransactionHelper.isTransactionActive()) {
                try {
                    TransactionHelper.setTransactionRollbackOnly();
                    TransactionHelper.commitOrRollbackTransaction();
                }
                finally {
                    Logger.getLogger(TransactionalFeature.class).warn((Object)"Committing a transaction for your, please do it yourself");
                }
            }
            return;
        }
        TransactionHelper.commitOrRollbackTransaction();
    }

    public static interface Waiter {
        public boolean await(long var1) throws InterruptedException;
    }
}

