/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.events;

import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.events.EventHandler;
import org.nuxeo.ecm.automation.core.events.EventRegistry;
import org.nuxeo.ecm.automation.core.events.OperationEventListener;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class EventHandlerRegistry {
    private static final Log log = LogFactory.getLog(OperationEventListener.class);
    protected final AutomationService svc;
    protected EventRegistry handlers;
    protected EventRegistry pchandlers;

    public EventHandlerRegistry(AutomationService svc) {
        this.svc = svc;
        this.handlers = new EventRegistry();
        this.pchandlers = new EventRegistry();
    }

    public List<EventHandler> getEventHandlers(String eventId) {
        return this.handlers.lookup().get(eventId);
    }

    public List<EventHandler> getPostCommitEventHandlers(String eventId) {
        return this.pchandlers.lookup().get(eventId);
    }

    public void putEventHandler(EventHandler handler) {
        this.handlers.addContribution(handler);
    }

    public synchronized void putPostCommitEventHandler(EventHandler handler) {
        this.pchandlers.addContribution(handler);
    }

    public synchronized void removePostCommitEventHandler(EventHandler handler) {
        this.pchandlers.removeContribution(handler);
    }

    public synchronized void removeEventHandler(EventHandler handler) {
        this.handlers.removeContribution(handler);
    }

    public synchronized void clear() {
        this.handlers = new EventRegistry();
        this.pchandlers = new EventRegistry();
    }

    public Set<String> getPostCommitEventNames() {
        return this.pchandlers.lookup().keySet();
    }

    public boolean acceptEvent(Event event, List<EventHandler> handlers) {
        OperationContext ctx;
        if (handlers == null || handlers.isEmpty()) {
            return false;
        }
        EventContext ectx = event.getContext();
        if (ectx instanceof DocumentEventContext) {
            ctx = new OperationContext(ectx.getCoreSession());
            ctx.setInput(((DocumentEventContext)ectx).getSourceDocument());
        } else {
            ctx = new OperationContext();
        }
        ctx.put("Event", (Object)event);
        for (EventHandler handler : handlers) {
            if (!handler.isEnabled(ctx, ectx, true)) continue;
            return true;
        }
        return false;
    }

    public void handleEvent(Event event, List<EventHandler> handlers, boolean saveSession) {
        if (handlers == null || handlers.isEmpty()) {
            return;
        }
        EventContext ectx = event.getContext();
        OperationContext ctx = null;
        for (EventHandler handler : handlers) {
            if (ectx instanceof DocumentEventContext) {
                ctx = new OperationContext(ectx.getCoreSession());
                ctx.setInput(((DocumentEventContext)ectx).getSourceDocument());
            } else {
                ctx = new OperationContext();
            }
            ctx.put("Event", (Object)event);
            ctx.setCommit(saveSession);
            try {
                if (!handler.isEnabled(ctx, ectx, false)) continue;
                this.svc.run(ctx, handler.getChainId());
            }
            catch (OperationException | NuxeoException e) {
                log.error((Object)("Failed to handle event " + event.getName() + " using chain: " + handler.getChainId()), e);
            }
        }
    }
}

