/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import java.util.List;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.BlobListCollector;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;

@Operation(id="Document.GetBlobsByProperty", category="Files", label="Get Document Files", description="Gets a list of files that are attached on the input document. The files location should be specified using the blob list property xpath. Returns a list of files.", aliases={"Blob.GetList"})
public class GetDocumentBlobs {
    public static final String ID = "Document.GetBlobsByProperty";
    @Param(name="xpath", required=false, values={"files:files"})
    protected String xpath = "files:files";

    @OperationMethod(collector=BlobListCollector.class)
    public BlobList run(DocumentModel doc) {
        BlobList blobs = new BlobList();
        ListProperty list = (ListProperty)doc.getProperty(this.xpath);
        if (list == null) {
            List docBlobs;
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (bh != null && (docBlobs = bh.getBlobs()) != null) {
                for (Blob blob : docBlobs) {
                    blobs.add(blob);
                }
            }
            return blobs;
        }
        for (Property p : list) {
            blobs.add((Blob)p.getValue("file"));
        }
        return blobs;
    }
}

