/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;

@Operation(id="Document.Copy", label="Copy", category="Document", description="Copy the input document into the given folder. The name parameter will be used as the copy name otherwise if not specified the original name will be preserved. The target folder can be specified as an absolute or relative path (relative to the input document) as an UID or by using an EL expression. Return the newly created document (the copy).")
public class CopyDocument {
    public static final String ID = "Document.Copy";
    @Context
    protected CoreSession session;
    @Param(name="target")
    protected DocumentRef target;
    @Param(name="name", required=false)
    protected String name;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        String n = this.name;
        if (this.name == null || this.name.length() == 0) {
            n = doc.getName();
        }
        return this.session.copy(doc.getRef(), this.target, n, new CoreSession.CopyOption[0]);
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef ref) {
        String n = this.name;
        if (this.name == null || this.name.length() == 0) {
            n = this.session.getDocument(ref).getName();
        }
        return this.session.copy(ref, this.target, n, new CoreSession.CopyOption[0]);
    }
}

