/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Document.ResetSchema", category="Document", label="Reset Schema", description="Reset all properties for a given schema or xpath. Activating the save parameter forces the changes to be written in database immediately (at the cost of performance loss), otherwise changes made to the document will be written in bulk when the chain succeeds.")
public class ResetSchema {
    public static final String ID = "Document.ResetSchema";
    @Context
    protected OperationContext context;
    @Context
    protected CoreSession session;
    @Param(name="schema", required=false)
    protected String schema;
    @Param(name="xpath", required=false)
    protected String xpath;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    private void resetSchemaProperties(DocumentModel target) throws OperationException {
        if (this.xpath != null) {
            target.setPropertyValue(this.xpath, null);
        } else if (this.schema != null) {
            for (String key : target.getProperties(this.schema).keySet()) {
                target.setProperty(this.schema, key, null);
            }
        } else {
            throw new OperationException("No schema or xpath was provided");
        }
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel target) throws OperationException {
        this.resetSchemaProperties(target);
        target = this.session.saveDocument(target);
        if (this.save) {
            this.session.save();
        }
        return target;
    }
}

