/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.arp.AsyncHandler;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.SocketChannelOutputBuffer;
import com.sun.grizzly.http.StatsThreadPool;
import com.sun.grizzly.ssl.SSLSelectorThread;
import com.sun.grizzly.util.ClassLoaderUtil;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.SelectorFactory;
import com.sun.grizzly.util.net.SSLImplementation;
import com.sun.grizzly.util.res.StringManager;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class SelectorThreadConfig {
    private static final String SELECTOR_TIMEOUT = "com.sun.grizzly.selector.timeout";
    private static final String MIN_THREAD = "com.sun.grizzly.minWorkerThreads";
    private static final String MAX_THREAD = "com.sun.grizzly.maxThreads";
    private static final String DISPLAY_CONFIGURATION = "com.sun.grizzly.displayConfiguration";
    private static final String MAX_KEEP_ALIVE_REQUEST = "com.sun.grizzly.maxKeepAliveRequests";
    private static final String DIRECT_BYTE_BUFFER_READ = "com.sun.grizzly.useDirectByteBuffer";
    private static final String THREAD_POOL_CLASS = "com.sun.grizzly.threadPoolClass";
    private static final String MAX_SELECTOR_READ_THREAD = "com.sun.grizzly.maxSelectorReadThread";
    private static final String BYTE_BUFFER_VIEW = "com.sun.grizzly.useByteBufferView";
    private static final String ALGORITHM_CLASS_NAME = "com.sun.grizzly.algorithmClassName";
    private static final String MAX_SELECTOR = "com.sun.grizzly.maxSelectors";
    private static final String FACTORY_TIMEOUT = "com.sun.grizzly.factoryTimeout";
    private static final String ASYNCH_HANDLER_CLASS = "com.sun.grizzly.asyncHandlerClass";
    private static final String ASYNCH_HANDLER_PORT = "com.sun.grizzly.asyncHandler.ports";
    private static final String SNOOP_LOGGING = "com.sun.grizzly.enableSnoop";
    private static final String TEMPORARY_SELECTOR_TIMEOUT = "com.sun.grizzly.readTimeout";
    private static final String WRITE_TIMEOUT = "com.sun.grizzly.writeTimeout";
    private static final String IDLE_THREAD_TIMEOUT = "com.sun.grizzly.idleThreadTimeout";
    private static final String BUFFER_RESPONSE = "com.sun.grizzly.http.bufferResponse";
    private static final String OOBInline = "com.sun.grizzly.OOBInline";
    private static final String MAX_BUFFERED_BYTES = "com.sun.grizzly.maxBufferedBytes";
    private static final String USE_FILE_CACHE = "com.sun.grizzly.useFileCache";
    private static final String IS_ASYNC_HTTP_WRITE = "com.sun.grizzly.http.asyncwrite.enabled";
    private static final String ASYNC_HTTP_WRITE_MAX_BUFFER_POOL_SIZE = "com.sun.grizzly.http.asyncwrite.maxBufferPoolSize";
    private static final String SSL_CONFIGURATION_WANTAUTH = "com.sun.grizzly.ssl.auth";
    private static final String SSL_CONFIGURATION_SSLIMPL = "com.sun.grizzly.ssl.sslImplementation";
    private static final String ASYNC_HANDLER_ENABLED_CONTEXT_PATH = "com.sun.grizzly.arp.asyncHandlerContextPath";
    public static final String REUSE_ADRESS = "com.sun.grizzly.http.reuseAddress";
    protected static final StringManager sm = StringManager.getManager("com.sun.grizzly.http.res");

    protected static void configureProperties(SelectorThread selectorThread) {
        String list;
        String auth;
        if (System.getProperty(SELECTOR_TIMEOUT) != null) {
            try {
                selectorThread.setSelectorTimeout(Integer.parseInt(System.getProperty(SELECTOR_TIMEOUT)));
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, sm.getString("selectorThread.invalidSelectorTimeout"));
            }
        }
        if (System.getProperty(TEMPORARY_SELECTOR_TIMEOUT) != null) {
            try {
                int timeout = Integer.parseInt(System.getProperty(TEMPORARY_SELECTOR_TIMEOUT));
                InputReader.setDefaultReadTimeout(timeout);
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, sm.getString("selectorThread.invalidReadTimeout"));
            }
        }
        if (System.getProperty(WRITE_TIMEOUT) != null) {
            try {
                int timeout = Integer.parseInt(System.getProperty(WRITE_TIMEOUT));
                OutputWriter.setDefaultWriteTimeout(timeout);
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, sm.getString("selectorThread.invalidWriteTimeout"));
            }
        }
        if (System.getProperty(IDLE_THREAD_TIMEOUT) != null) {
            try {
                int timeout = Integer.parseInt(System.getProperty(IDLE_THREAD_TIMEOUT));
                selectorThread.setTransactionTimeout(timeout);
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, sm.getString("selectorThread.invalidWriteTimeout"));
            }
        }
        String threadPoolClassname = null;
        int minWorkerThreads = StatsThreadPool.DEFAULT_MIN_THREAD_COUNT;
        int maxWorkerThreads = StatsThreadPool.DEFAULT_MAX_THREAD_COUNT;
        if (System.getProperty(THREAD_POOL_CLASS) != null) {
            threadPoolClassname = System.getProperty(THREAD_POOL_CLASS);
            selectorThread.setThreadPoolClassname(threadPoolClassname);
        }
        if (System.getProperty(MIN_THREAD) != null) {
            try {
                minWorkerThreads = Integer.parseInt(System.getProperty(MIN_THREAD));
                selectorThread.setCoreThreads(minWorkerThreads);
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, sm.getString("selectorThread.invalidMinThreads"));
            }
        }
        if (System.getProperty(MAX_THREAD) != null) {
            try {
                maxWorkerThreads = Integer.parseInt(System.getProperty(MAX_THREAD));
                selectorThread.setMaxThreads(maxWorkerThreads);
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, sm.getString("selectorThread.invalidMaxThreads"));
            }
        }
        if (System.getProperty(DISPLAY_CONFIGURATION) != null) {
            selectorThread.displayConfiguration = Boolean.valueOf(System.getProperty(DISPLAY_CONFIGURATION));
        }
        if (System.getProperty(REUSE_ADRESS) != null) {
            selectorThread.setReuseAddress(Boolean.valueOf(System.getProperty(REUSE_ADRESS)));
        }
        if (System.getProperty(ASYNCH_HANDLER_PORT) != null) {
            String ports = System.getProperty(ASYNCH_HANDLER_PORT);
            StringTokenizer st = new StringTokenizer(ports, ",");
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equals(String.valueOf(selectorThread.getPort())) || System.getProperty(ASYNCH_HANDLER_CLASS) == null) continue;
                selectorThread.asyncHandler = (AsyncHandler)ClassLoaderUtil.load(System.getProperty(ASYNCH_HANDLER_CLASS));
                selectorThread.asyncExecution = true;
            }
        }
        if (System.getProperty(DIRECT_BYTE_BUFFER_READ) != null) {
            selectorThread.useDirectByteBuffer = Boolean.valueOf(System.getProperty(DIRECT_BYTE_BUFFER_READ));
        }
        if (System.getProperty(MAX_KEEP_ALIVE_REQUEST) != null) {
            try {
                selectorThread.setMaxKeepAliveRequests(Integer.parseInt(System.getProperty(MAX_KEEP_ALIVE_REQUEST)));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (System.getProperty(ALGORITHM_CLASS_NAME) != null) {
            selectorThread.algorithmClassName = System.getProperty(ALGORITHM_CLASS_NAME);
        }
        if (System.getProperty(BYTE_BUFFER_VIEW) != null) {
            selectorThread.useByteBufferView = Boolean.valueOf(System.getProperty(BYTE_BUFFER_VIEW));
        }
        if (System.getProperty(MAX_SELECTOR_READ_THREAD) != null) {
            try {
                selectorThread.readThreadsCount = Integer.parseInt(System.getProperty(MAX_SELECTOR_READ_THREAD));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (System.getProperty(MAX_SELECTOR) != null) {
            try {
                SelectorFactory.setMaxSelectors(Integer.parseInt(System.getProperty(MAX_SELECTOR)));
            }
            catch (NumberFormatException ex) {
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (System.getProperty(SNOOP_LOGGING) != null) {
            SelectorThread.setEnableNioLogging(Boolean.valueOf(System.getProperty(SNOOP_LOGGING)));
        }
        if (System.getProperty(BUFFER_RESPONSE) != null) {
            selectorThread.setBufferResponse(Boolean.valueOf(System.getProperty(BUFFER_RESPONSE)));
        }
        if (System.getProperty(OOBInline) != null) {
            selectorThread.oOBInline = Boolean.valueOf(System.getProperty(OOBInline));
        }
        if (System.getProperty(MAX_BUFFERED_BYTES) != null) {
            try {
                SocketChannelOutputBuffer.setMaxBufferedBytes(Integer.parseInt(System.getProperty(MAX_BUFFERED_BYTES)));
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, sm.getString("selectorThread.invalidMaxBufferedBytes"));
            }
        }
        if (System.getProperty(USE_FILE_CACHE) != null) {
            selectorThread.setFileCacheIsEnabled(Boolean.valueOf(System.getProperty(USE_FILE_CACHE)));
            selectorThread.setLargeFileCacheEnabled(selectorThread.isFileCacheEnabled());
        }
        if (System.getProperty(IS_ASYNC_HTTP_WRITE) != null) {
            selectorThread.setAsyncHttpWriteEnabled(Boolean.getBoolean(IS_ASYNC_HTTP_WRITE));
        }
        if (System.getProperty(ASYNC_HTTP_WRITE_MAX_BUFFER_POOL_SIZE) != null) {
            SocketChannelOutputBuffer.setMaxBufferPoolSize(Integer.getInteger(ASYNC_HTTP_WRITE_MAX_BUFFER_POOL_SIZE, -1));
        }
        if ((auth = System.getProperty(SSL_CONFIGURATION_WANTAUTH)) != null && selectorThread instanceof SSLSelectorThread) {
            if (auth.trim().equalsIgnoreCase("want")) {
                ((SSLSelectorThread)selectorThread).setWantClientAuth(true);
            } else if (auth.trim().equalsIgnoreCase("need")) {
                ((SSLSelectorThread)selectorThread).setNeedClientAuth(true);
            }
        }
        if (System.getProperty(SSL_CONFIGURATION_SSLIMPL) != null) {
            SSLImplementation sslImplementation = (SSLImplementation)ClassLoaderUtil.load(System.getProperty(SSL_CONFIGURATION_SSLIMPL));
            if (selectorThread instanceof SSLSelectorThread) {
                ((SSLSelectorThread)selectorThread).setSSLImplementation(sslImplementation);
            }
        }
        if ((list = System.getProperty(ASYNC_HANDLER_ENABLED_CONTEXT_PATH)) != null) {
            StringTokenizer st = new StringTokenizer(list, ",");
            while (st.hasMoreTokens()) {
                selectorThread.addAsyncEnabledContextPath(st.nextToken());
            }
        }
    }

    public static void configure(SelectorThread selectorThread) {
        SelectorThreadConfig.configureProperties(selectorThread);
    }
}

