/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider.internal.convert;

import com.tngtech.java.junit.dataprovider.DataProvider;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringConverter {
    public Object[] convert(String data, boolean isVarArgs, Class<?>[] parameterTypes, DataProvider dataProvider, int rowIdx) {
        if (data == null) {
            return new Object[]{null};
        }
        if (isVarArgs && parameterTypes.length == 1 && data.isEmpty()) {
            return new Object[]{Array.newInstance(parameterTypes[0].getComponentType(), 0)};
        }
        String[] splitData = this.splitBy(data, dataProvider.splitBy());
        this.checkArgumentsAndParameterCount(splitData.length, parameterTypes.length, isVarArgs, rowIdx);
        Object[] result = new Object[parameterTypes.length];
        int nonVarArgParametersLength = parameterTypes.length - (isVarArgs ? 1 : 0);
        for (int idx = 0; idx < nonVarArgParametersLength; ++idx) {
            result[idx] = this.convertValue(splitData[idx], parameterTypes[idx], dataProvider);
        }
        if (isVarArgs) {
            Class<?> varArgComponentType = parameterTypes[nonVarArgParametersLength].getComponentType();
            Object varArgArray = Array.newInstance(varArgComponentType, splitData.length - parameterTypes.length + 1);
            for (int idx = nonVarArgParametersLength; idx < splitData.length; ++idx) {
                Array.set(varArgArray, idx - nonVarArgParametersLength, this.convertValue(splitData[idx], varArgComponentType, dataProvider));
            }
            result[nonVarArgParametersLength] = varArgArray;
        }
        return result;
    }

    private String[] splitBy(String data, String regex) {
        String[] splitData = (data + "\u0000").split(regex);
        int lastItemIdx = splitData.length - 1;
        splitData[lastItemIdx] = splitData[lastItemIdx].substring(0, splitData[lastItemIdx].length() - 1);
        return splitData;
    }

    private void checkArgumentsAndParameterCount(int argCount, int paramCount, boolean isVarArgs, int rowIdx) {
        if (isVarArgs && paramCount - 1 > argCount || !isVarArgs && paramCount != argCount) {
            throw new IllegalArgumentException(String.format("Test method expected %s %d parameters but got %d from @DataProvider row %d", isVarArgs ? "at least " : "", paramCount - 1, argCount, rowIdx));
        }
    }

    private Object convertValue(String data, Class<?> targetType, DataProvider dataProvider) {
        String toConvert;
        String string = toConvert = dataProvider.trimValues() ? data.trim() : data;
        if (dataProvider.convertNulls() && "null".equals(toConvert)) {
            return null;
        }
        return this.convertValue(toConvert, targetType);
    }

    private Object convertValue(String str, Class<?> targetType) {
        if (String.class.equals(targetType)) {
            return str;
        }
        try {
            if (Boolean.TYPE.equals(targetType) || Boolean.class.equals(targetType)) {
                return Boolean.valueOf(str);
            }
            if (Byte.TYPE.equals(targetType) || Byte.class.equals(targetType)) {
                return Byte.valueOf(str);
            }
            if (Character.TYPE.equals(targetType) || Character.class.equals(targetType)) {
                return this.convertToChar(str, targetType);
            }
            if (Short.TYPE.equals(targetType) || Short.class.equals(targetType)) {
                return Short.valueOf(str);
            }
            if (Integer.TYPE.equals(targetType) || Integer.class.equals(targetType)) {
                return Integer.valueOf(str);
            }
            if (Long.TYPE.equals(targetType) || Long.class.equals(targetType)) {
                return this.convertToLong(str);
            }
            if (Float.TYPE.equals(targetType) || Float.class.equals(targetType)) {
                return Float.valueOf(str);
            }
            if (Double.TYPE.equals(targetType) || Double.class.equals(targetType)) {
                return Double.valueOf(str);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot convert %s to %s", str, targetType.getSimpleName()));
        }
        if (targetType.isEnum()) {
            return this.convertToEnumValue(str, targetType);
        }
        Object result = this.tryConvertUsingSingleStringParamConstructor(str, targetType);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("'" + targetType.getSimpleName() + "' is not supported as parameter type of test methods" + ". Supported types are primitive types and their wrappers, case-sensitive 'Enum'" + " values, 'String's, and types having a single 'String' parameter constructor.");
    }

    private Object convertToChar(String str, Class<?> charType) {
        if (str.length() == 1) {
            return Character.valueOf(str.charAt(0));
        }
        throw new IllegalArgumentException(String.format("'%s' cannot be converted to %s.", str, charType.getSimpleName()));
    }

    private Object convertToLong(String str) {
        String longStr = str;
        if (longStr.endsWith("l")) {
            longStr = longStr.substring(0, longStr.length() - 1);
        }
        return Long.valueOf(longStr);
    }

    private Object convertToEnumValue(String str, Class<?> enumType) {
        try {
            Object result = Enum.valueOf(enumType, str);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid value of enum %s. Please be aware of case sensitivity.", str, enumType.getSimpleName()));
        }
    }

    private Object tryConvertUsingSingleStringParamConstructor(String str, Class<?> targetType) {
        for (Constructor<?> constructor : targetType.getConstructors()) {
            if (constructor.getParameterTypes().length != 1 || !String.class.equals(constructor.getParameterTypes()[0])) continue;
            try {
                return constructor.newInstance(str);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Tried to invoke '%s' for argument '%s'. Exception: %s", constructor, str, e.getMessage()), e);
            }
        }
        return null;
    }
}

