/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.nuxeo.runtime.test.TargetResourceLocator;
import org.nuxeo.runtime.test.runner.AnnotationScanner;
import org.nuxeo.runtime.test.runner.Defaults;
import org.nuxeo.runtime.test.runner.FeaturesLoader;
import org.nuxeo.runtime.test.runner.MethodSorter;
import org.nuxeo.runtime.test.runner.RunnerFeature;

public class FeaturesRunner
extends BlockJUnit4ClassRunner {
    protected static final AnnotationScanner scanner = new AnnotationScanner();
    protected Injector injector;
    protected final FeaturesLoader loader = new FeaturesLoader(this);
    protected final TargetResourceLocator locator;
    protected Object underTest;

    public static AnnotationScanner getScanner() {
        return scanner;
    }

    public FeaturesRunner(Class<?> classToRun) throws InitializationError {
        super(classToRun);
        this.locator = new TargetResourceLocator(classToRun);
        try {
            this.loader.loadFeatures(this.getTargetTestClass());
        }
        catch (Throwable t) {
            throw new InitializationError(Collections.singletonList(t));
        }
    }

    public Class<?> getTargetTestClass() {
        return super.getTestClass().getJavaClass();
    }

    public Path getTargetTestBasepath() {
        return this.locator.getBasepath();
    }

    public URL getTargetTestResource(String name) throws IOException {
        return this.locator.getTargetTestResource(name);
    }

    public Iterable<RunnerFeature> getFeatures() {
        return this.loader.features();
    }

    public <T extends Annotation> T getConfig(final Class<T> type) {
        final ArrayList<T> configs = new ArrayList<T>();
        T annotation = scanner.getAnnotation(this.getTargetTestClass(), type);
        if (annotation != null) {
            configs.add(annotation);
        }
        this.loader.apply(FeaturesLoader.Direction.BACKWARD, new FeaturesLoader.Callable(){

            @Override
            public void call(FeaturesLoader.Holder holder) throws Exception {
                Object hAnnotation = scanner.getAnnotation(holder.type, type);
                if (hAnnotation != null) {
                    configs.add(hAnnotation);
                }
            }
        });
        return Defaults.of(type, configs);
    }

    public <T extends Annotation> T getConfig(FrameworkMethod method, Class<T> type) {
        Annotation config = method.getAnnotation(type);
        if (config != null) {
            return (T)config;
        }
        return this.getConfig(type);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        ArrayList<FrameworkMethod> methods = super.computeTestMethods();
        methods = new ArrayList<FrameworkMethod>(methods);
        MethodSorter.sortMethodsUsingSourceOrder(methods);
        return methods;
    }

    protected void initialize() throws Exception {
        for (RunnerFeature each : this.getFeatures()) {
            each.initialize(this);
        }
    }

    protected void beforeRun() throws Exception {
        this.loader.apply(FeaturesLoader.Direction.FORWARD, new FeaturesLoader.Callable(){

            @Override
            public void call(FeaturesLoader.Holder holder) throws Exception {
                holder.feature.beforeRun(FeaturesRunner.this);
            }
        });
    }

    protected void beforeMethodRun(final FrameworkMethod method, final Object test) throws Exception {
        this.loader.apply(FeaturesLoader.Direction.FORWARD, new FeaturesLoader.Callable(){

            @Override
            public void call(FeaturesLoader.Holder holder) throws Exception {
                holder.feature.beforeMethodRun(FeaturesRunner.this, method, test);
            }
        });
    }

    protected void afterMethodRun(final FrameworkMethod method, final Object test) throws Exception {
        this.loader.apply(FeaturesLoader.Direction.FORWARD, new FeaturesLoader.Callable(){

            @Override
            public void call(FeaturesLoader.Holder holder) throws Exception {
                holder.feature.afterMethodRun(FeaturesRunner.this, method, test);
            }
        });
    }

    protected void afterRun() throws Exception {
        this.loader.apply(FeaturesLoader.Direction.BACKWARD, new FeaturesLoader.Callable(){

            @Override
            public void call(FeaturesLoader.Holder holder) throws Exception {
                holder.feature.afterRun(FeaturesRunner.this);
            }
        });
    }

    protected void start() throws Exception {
        this.loader.apply(FeaturesLoader.Direction.FORWARD, new FeaturesLoader.Callable(){

            @Override
            public void call(FeaturesLoader.Holder holder) throws Exception {
                holder.feature.start(FeaturesRunner.this);
            }
        });
    }

    protected void stop() throws Exception {
        this.loader.apply(FeaturesLoader.Direction.BACKWARD, new FeaturesLoader.Callable(){

            @Override
            public void call(FeaturesLoader.Holder holder) throws Exception {
                holder.feature.stop(FeaturesRunner.this);
            }
        });
    }

    protected void beforeSetup() throws Exception {
        this.loader.apply(FeaturesLoader.Direction.FORWARD, new FeaturesLoader.Callable(){

            @Override
            public void call(FeaturesLoader.Holder holder) throws Exception {
                holder.feature.beforeSetup(FeaturesRunner.this);
            }
        });
        this.injector.injectMembers(this.underTest);
    }

    protected void afterTeardown() {
        this.loader.apply(FeaturesLoader.Direction.BACKWARD, new FeaturesLoader.Callable(){

            @Override
            public void call(FeaturesLoader.Holder holder) throws Exception {
                holder.feature.afterTeardown(FeaturesRunner.this);
            }
        });
    }

    public Injector getInjector() {
        return this.injector;
    }

    protected Injector onInjector(final RunNotifier aNotifier) {
        return Guice.createInjector((Stage)Stage.DEVELOPMENT, (Module[])new Module[]{new Module(){

            public void configure(Binder aBinder) {
                aBinder.bind(FeaturesRunner.class).toInstance((Object)FeaturesRunner.this);
                aBinder.bind(RunNotifier.class).toInstance((Object)aNotifier);
                aBinder.bind(TargetResourceLocator.class).toInstance((Object)FeaturesRunner.this.locator);
            }
        }});
    }

    protected Statement withAfterClasses(Statement statement) {
        Statement actual = statement;
        actual = super.withAfterClasses(actual);
        actual = new AfterClassStatement(actual);
        return actual;
    }

    protected Statement classBlock(RunNotifier aNotifier) {
        this.injector = this.onInjector(aNotifier);
        return super.classBlock(aNotifier);
    }

    protected List<TestRule> classRules() {
        final RulesFactory<ClassRule, TestRule> factory = new RulesFactory<ClassRule, TestRule>(ClassRule.class, TestRule.class);
        factory.withRule(new TestRule(){

            public Statement apply(Statement base, Description description) {
                return new BeforeClassStatement(base);
            }
        }).withRules(super.classRules());
        this.loader.apply(FeaturesLoader.Direction.FORWARD, new FeaturesLoader.Callable(){

            @Override
            public void call(FeaturesLoader.Holder holder) throws Exception {
                factory.withRules(holder.testClass, null);
            }
        });
        return factory.build();
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        Statement actual = statement;
        actual = new BeforeMethodRunStatement(method, target, actual);
        actual = super.withBefores(method, target, actual);
        actual = new BeforeSetupStatement(actual);
        return actual;
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        Statement actual = statement;
        actual = new AfterMethodRunStatement(method, target, actual);
        actual = super.withAfters(method, target, actual);
        actual = new AfterTeardownStatement(actual);
        return actual;
    }

    protected List<TestRule> getTestRules(Object target) {
        final RulesFactory<Rule, TestRule> factory = new RulesFactory<Rule, TestRule>(Rule.class, TestRule.class);
        this.loader.apply(FeaturesLoader.Direction.FORWARD, new FeaturesLoader.Callable(){

            @Override
            public void call(FeaturesLoader.Holder holder) throws Exception {
                factory.withRules(holder.testClass, holder.feature);
            }
        });
        factory.withRules(this.getTestClass(), target);
        return factory.build();
    }

    protected List<MethodRule> rules(Object target) {
        final RulesFactory<Rule, MethodRule> factory = new RulesFactory<Rule, MethodRule>(Rule.class, MethodRule.class);
        this.loader.apply(FeaturesLoader.Direction.FORWARD, new FeaturesLoader.Callable(){

            @Override
            public void call(FeaturesLoader.Holder holder) throws Exception {
                factory.withRules(holder.testClass, holder.feature);
            }
        });
        factory.withRules(this.getTestClass(), target);
        return factory.build();
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        final Statement actual = super.methodInvoker(method, test);
        return new Statement(){

            public void evaluate() throws Throwable {
                FeaturesRunner.this.injector.injectMembers(FeaturesRunner.this.underTest);
                actual.evaluate();
            }
        };
    }

    public Object createTest() throws Exception {
        this.underTest = super.createTest();
        this.loader.apply(FeaturesLoader.Direction.FORWARD, new FeaturesLoader.Callable(){

            @Override
            public void call(FeaturesLoader.Holder holder) throws Exception {
                holder.feature.testCreated(FeaturesRunner.this.underTest);
            }
        });
        return this.underTest;
    }

    protected void validateZeroArgConstructor(List<Throwable> errors) {
    }

    public String toString() {
        return "FeaturesRunner [fTest=" + this.getTargetTestClass() + "]";
    }

    public <T extends RunnerFeature> T getFeature(Class<T> aType) {
        return this.loader.getFeature(aType);
    }

    protected class RulesFactory<A extends Annotation, R> {
        protected final Class<A> annotationType;
        protected final Class<R> ruleType;
        protected ArrayList<R> rules = new ArrayList();

        protected Statement build(final Statement base, final String name) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    FeaturesRunner.this.injector = FeaturesRunner.this.injector.createChildInjector(new Module[]{new Module(){

                        public void configure(Binder binder) {
                            for (Object each : RulesFactory.this.rules) {
                                binder.bind(each.getClass()).annotatedWith((Annotation)Names.named((String)name)).toInstance(each);
                                binder.requestInjection(each);
                            }
                        }
                    }});
                    try {
                        base.evaluate();
                    }
                    finally {
                        FeaturesRunner.this.injector = FeaturesRunner.this.injector.getParent();
                    }
                }
            };
        }

        protected RulesFactory(Class<A> anAnnotationType, Class<R> aRuleType) {
            this.annotationType = anAnnotationType;
            this.ruleType = aRuleType;
        }

        public RulesFactory<A, R> withRules(List<R> someRules) {
            this.rules.addAll(someRules);
            return this;
        }

        public RulesFactory<A, R> withRule(R aRule) {
            FeaturesRunner.this.injector.injectMembers(aRule);
            this.rules.add(aRule);
            return this;
        }

        public RulesFactory<A, R> withRules(TestClass aType, Object aTest) {
            for (Object each : aType.getAnnotatedFieldValues(aTest, this.annotationType, this.ruleType)) {
                this.withRule(each);
            }
            for (Object each : aType.getAnnotatedMethods(this.annotationType)) {
                if (!this.ruleType.isAssignableFrom(each.getMethod().getReturnType())) continue;
                this.withRule(this.onMethod(this.ruleType, (FrameworkMethod)each, aTest, new Object[0]));
            }
            return this;
        }

        public List<R> build() {
            return Collections.singletonList(this.ruleType.cast(new BindRule()));
        }

        protected R onMethod(Class<R> aRuleType, FrameworkMethod aMethod, Object aTarget, Object ... someParms) {
            try {
                return aRuleType.cast(aMethod.invokeExplosively(aTarget, someParms));
            }
            catch (Throwable cause) {
                throw new RuntimeException("Errors in rules factory " + aMethod, cause);
            }
        }

        protected class BindRule
        implements TestRule,
        MethodRule {
            protected BindRule() {
            }

            public Statement apply(Statement base, FrameworkMethod method, Object target) {
                Statement statement = RulesFactory.this.build(base, "method");
                for (Object each : RulesFactory.this.rules) {
                    statement = ((MethodRule)each).apply(statement, method, target);
                }
                return statement;
            }

            public Statement apply(Statement base, Description description) {
                if (RulesFactory.this.rules.isEmpty()) {
                    return base;
                }
                Statement statement = RulesFactory.this.build(base, "test");
                for (Object each : RulesFactory.this.rules) {
                    statement = ((TestRule)each).apply(statement, description);
                }
                return statement;
            }
        }
    }

    protected class AfterTeardownStatement
    extends Statement {
        protected final Statement previous;

        protected AfterTeardownStatement(Statement aStatement) {
            this.previous = aStatement;
        }

        public void evaluate() throws Throwable {
            try {
                this.previous.evaluate();
            }
            finally {
                FeaturesRunner.this.afterTeardown();
            }
        }
    }

    protected class AfterMethodRunStatement
    extends Statement {
        protected final Statement previous;
        protected final FrameworkMethod method;
        protected final Object target;

        protected AfterMethodRunStatement(FrameworkMethod aMethod, Object aTarget, Statement aStatement) {
            this.method = aMethod;
            this.target = aTarget;
            this.previous = aStatement;
        }

        public void evaluate() throws Throwable {
            try {
                this.previous.evaluate();
            }
            finally {
                FeaturesRunner.this.afterMethodRun(this.method, this.target);
            }
        }
    }

    protected class BeforeSetupStatement
    extends Statement {
        protected final Statement next;

        protected BeforeSetupStatement(Statement aStatement) {
            this.next = aStatement;
        }

        public void evaluate() throws Throwable {
            FeaturesRunner.this.beforeSetup();
            this.next.evaluate();
        }
    }

    protected class BeforeMethodRunStatement
    extends Statement {
        protected final Statement next;
        protected final FrameworkMethod method;
        protected final Object target;

        protected BeforeMethodRunStatement(FrameworkMethod aMethod, Object aTarget, Statement aStatement) {
            this.method = aMethod;
            this.target = aTarget;
            this.next = aStatement;
        }

        public void evaluate() throws Throwable {
            FeaturesRunner.this.beforeMethodRun(this.method, this.target);
            this.next.evaluate();
        }
    }

    protected class AfterClassStatement
    extends Statement {
        protected final Statement previous;

        protected AfterClassStatement(Statement aStatement) {
            this.previous = aStatement;
        }

        public void evaluate() throws Throwable {
            this.previous.evaluate();
            try {
                FeaturesRunner.this.afterRun();
            }
            finally {
                FeaturesRunner.this.stop();
            }
        }
    }

    protected class BeforeClassStatement
    extends Statement {
        protected final Statement next;

        protected BeforeClassStatement(Statement aStatement) {
            this.next = aStatement;
        }

        public void evaluate() throws Throwable {
            FeaturesRunner.this.initialize();
            FeaturesRunner.this.start();
            FeaturesRunner.this.beforeRun();
            FeaturesRunner.this.injector = FeaturesRunner.this.injector.createChildInjector(new Module[]{FeaturesRunner.this.loader.onModule()});
            try {
                this.next.evaluate();
            }
            finally {
                FeaturesRunner.this.injector = FeaturesRunner.this.injector.getParent();
            }
        }
    }
}

