/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import com.google.inject.Binder;
import org.apache.log4j.MDC;
import org.junit.runners.model.FrameworkMethod;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;

public class MDCFeature
implements RunnerFeature {
    protected static final String F_TEST = "fTest";
    protected static final String F_SUITE = "fSuite";
    protected static final String F_STATE = "fState";

    @Override
    public void initialize(FeaturesRunner runner) throws Exception {
        MDC.put((String)F_STATE, (Object)"initialize");
    }

    @Override
    public void configure(FeaturesRunner runner, Binder binder) {
        MDC.put((String)F_STATE, (Object)"configure");
    }

    @Override
    public void beforeRun(FeaturesRunner runner) throws Exception {
        MDC.put((String)F_STATE, (Object)"beforeRun");
    }

    @Override
    public void afterRun(FeaturesRunner runner) throws Exception {
        MDC.put((String)F_STATE, (Object)"afterRun");
    }

    @Override
    public void start(FeaturesRunner runner) throws Exception {
        MDC.put((String)F_STATE, (Object)"start");
    }

    @Override
    public void testCreated(Object test) throws Exception {
        MDC.put((String)F_STATE, (Object)"testCreated");
        MDC.put((String)F_SUITE, test.getClass());
    }

    @Override
    public void stop(FeaturesRunner runner) throws Exception {
        MDC.remove((String)F_STATE);
        MDC.remove((String)F_SUITE);
        MDC.remove((String)F_TEST);
    }

    @Override
    public void beforeSetup(FeaturesRunner runner) throws Exception {
        MDC.put((String)F_STATE, (Object)"beforeSetup");
    }

    @Override
    public void afterTeardown(FeaturesRunner runner) throws Exception {
        MDC.put((String)F_STATE, (Object)"afterTeardown");
    }

    @Override
    public void beforeMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) throws Exception {
        MDC.put((String)F_STATE, (Object)"beforeMethodRun");
        MDC.put((String)F_TEST, (Object)method.getMethod().getName());
    }

    @Override
    public void afterMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) throws Exception {
        MDC.put((String)F_STATE, (Object)"afterMethodRun");
        MDC.remove((String)F_TEST);
    }
}

