/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.loader.ClassProxy;
import org.nuxeo.ecm.webengine.loader.WebLoader;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AdapterDescriptor;
import org.nuxeo.ecm.webengine.model.impl.TypeDescriptor;
import org.nuxeo.ecm.webengine.model.impl.TypeRegistry;

public class GroovyTypeLoader {
    public static final Log log = LogFactory.getLog(GroovyTypeLoader.class);
    public static final String CRLF = System.getProperty("line.separator");
    public static final String WEB_TYPES_FILE = "META-INF/groovy-web-types";
    protected final WebLoader loader;
    protected final TypeRegistry typeReg;
    protected final File root;

    public GroovyTypeLoader(WebEngine engine, TypeRegistry typeReg, File root) {
        this.typeReg = typeReg;
        this.root = root;
        this.loader = engine.getWebLoader();
    }

    public synchronized void flushCache() {
        log.info((Object)"Flush directory type provider cache");
        File cache = new File(this.root, WEB_TYPES_FILE);
        cache.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load() {
        block20: {
            try {
                File cache = new File(this.root, WEB_TYPES_FILE);
                if (cache.isFile()) {
                    for (String line : FileUtils.readLines((File)cache)) {
                        TypeDescriptor td;
                        if (line.equals("") || (td = this.loadType(line)) == null) continue;
                        this.typeReg.registerTypeDescriptor(td);
                    }
                    break block20;
                }
                cache.getParentFile().mkdirs();
                boolean completedAbruptly = true;
                try (BufferedWriter w = new BufferedWriter(new FileWriter(cache));){
                    this.scan(this.root, null, w);
                    completedAbruptly = false;
                }
                finally {
                    if (completedAbruptly) {
                        cache.delete();
                    }
                }
            }
            catch (IOException | ClassNotFoundException e) {
                throw WebException.wrap(e);
            }
        }
    }

    protected void scan(File root, String path, Writer cache) {
        for (File file : root.listFiles()) {
            String name = file.getName();
            if (file.isDirectory() && !"skin".equals(name) && !"samples".equals(name)) {
                this.scan(file, path == null ? name : path + '.' + name, cache);
                continue;
            }
            if (!name.endsWith(".groovy") || !Character.isUpperCase(name.charAt(0))) continue;
            String className = null;
            if (path == null) {
                className = name.substring(0, name.length() - 7);
            } else {
                StringBuilder buf = new StringBuilder().append(path).append('.').append(name);
                buf.setLength(buf.length() - 7);
                className = buf.toString();
            }
            try {
                TypeDescriptor td = this.loadTypeAndRecord(cache, className);
                if (td == null) continue;
                this.typeReg.registerTypeDescriptor(td);
            }
            catch (IOException | ClassNotFoundException e) {
                throw WebException.wrap(e);
            }
        }
    }

    protected TypeDescriptor loadTypeAndRecord(Writer cache, String className) throws ClassNotFoundException, IOException {
        TypeDescriptor td = this.loadType(className);
        if (td != null) {
            cache.write(className);
            cache.write(CRLF);
        }
        return td;
    }

    protected TypeDescriptor loadType(String className) throws ClassNotFoundException {
        ClassProxy clazz = this.loader.getGroovyClassProxy(className);
        WebObject type = clazz.get().getAnnotation(WebObject.class);
        if (type != null) {
            return TypeDescriptor.fromAnnotation(clazz, type);
        }
        WebAdapter ws = clazz.get().getAnnotation(WebAdapter.class);
        if (ws != null) {
            return AdapterDescriptor.fromAnnotation(clazz, ws);
        }
        return null;
    }
}

