/*
 * (C) Copyright 2006-2011 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     bstefanescu
 */
package org.nuxeo.ecm.automation.core.rendering;

import java.io.IOException;
import java.util.Map;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.platform.rendering.api.RenderingException;

import freemarker.template.TemplateException;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 */
public class RenderingService {

    // TODO use a runtime service
    private static RenderingService instance = new RenderingService();

    public static RenderingService getInstance() {
        return instance;
    }

    protected MvelRender mvel = new MvelRender();

    protected FreemarkerRender ftl = new FreemarkerRender();

    public String render(String type, String uriOrContent, OperationContext ctx) throws OperationException,
            RenderingException, TemplateException, IOException {
        Map<String, Object> map = Scripting.initBindings(ctx);
        // map.put("DocUrl", MailTemplateHelper.getDocumentUrl(doc, viewId));
        return getRenderer(type).render(uriOrContent, map);
    }

    public Renderer getRenderer(String type) {
        if ("mvel".equals(type)) {
            return mvel;
        } else {
            return ftl;
        }
    }

}
