// $ANTLR 2.7.4: "ACIItemChecker.g" -> "AntlrACIItemChecker.java"$

/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */


package org.apache.directory.shared.ldap.aci;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Enumeration;

import javax.naming.directory.Attribute;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import javax.naming.NamingException;

import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParserImpl;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecificationModifier;
import org.apache.directory.shared.ldap.util.ComponentsMonitor;
import org.apache.directory.shared.ldap.util.MandatoryAndOptionalComponentsMonitor;
import org.apache.directory.shared.ldap.util.MandatoryComponentsMonitor;
import org.apache.directory.shared.ldap.util.NamespaceTools;
import org.apache.directory.shared.ldap.util.NoDuplicateKeysMap;
import org.apache.directory.shared.ldap.util.OptionalComponentsMonitor;
import org.apache.directory.shared.ldap.name.LdapDN;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;

/**
 * The antlr generated ACIItem checker.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 * @version $Rev$
 */
public class AntlrACIItemChecker extends antlr.LLkParser       implements AntlrACIItemCheckerTokenTypes
 {

    // subordinate parser instances
    private final FilterParserImpl filterParser = new FilterParserImpl();
    
    private boolean isNormalizing = false;
    NameComponentNormalizer normalizer;
    
    /**
     * Creates a (normalizing) subordinate DnParser for parsing Names.
     * This method MUST be called for each instance while we cannot do
     * constructor overloading for this class.
     *
     * @return the DnParser to be used for parsing Names
     */
    public void init()
    {
    }

    /**
     * Sets the NameComponentNormalizer for this parser's dnParser.
     */
    public void setNormalizer(NameComponentNormalizer normalizer)
    {
        this.normalizer = normalizer;
        this.isNormalizing = true;
    }

    private int token2Integer( Token token ) throws RecognitionException
    {
        int i = 0;
        
        try
        {
            i = Integer.parseInt( token.getText());
        }
        catch ( NumberFormatException e )
        {
            throw new RecognitionException( "Value of INTEGER token " +
                                            token.getText() +
                                            " cannot be converted to an Integer" );
        }
        
        return i;
    }

protected AntlrACIItemChecker(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public AntlrACIItemChecker(TokenBuffer tokenBuf) {
  this(tokenBuf,1);
}

protected AntlrACIItemChecker(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public AntlrACIItemChecker(TokenStream lexer) {
  this(lexer,1);
}

public AntlrACIItemChecker(ParserSharedInputState state) {
  super(state,1);
  tokenNames = _tokenNames;
}

	public final void wrapperEntryPoint() throws RecognitionException, TokenStreamException {
		
		
		{
		_loop562:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop562;
			}
			
		} while (true);
		}
		theACIItem();
		{
		_loop564:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop564;
			}
			
		} while (true);
		}
		match(Token.EOF_TYPE);
	}
	
	public final void theACIItem() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop567:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop567;
			}
			
		} while (true);
		}
		mainACIItemComponent();
		{
		_loop569:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop569;
			}
			
		} while (true);
		}
		{
		_loop575:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop572:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop572;
					}
					
				} while (true);
				}
				mainACIItemComponent();
				{
				_loop574:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop574;
					}
					
				} while (true);
				}
			}
			else {
				break _loop575;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void mainACIItemComponent() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_identificationTag:
		{
			aci_identificationTag();
			break;
		}
		case ID_precedence:
		{
			aci_precedence();
			break;
		}
		case ID_authenticationLevel:
		{
			aci_authenticationLevel();
			break;
		}
		case ID_itemOrUserFirst:
		{
			aci_itemOrUserFirst();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void aci_identificationTag() throws RecognitionException, TokenStreamException {
		
		
		match(ID_identificationTag);
		{
		int _cnt579=0;
		_loop579:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt579>=1 ) { break _loop579; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt579++;
		} while (true);
		}
		match(SAFEUTF8STRING);
	}
	
	public final void aci_precedence() throws RecognitionException, TokenStreamException {
		
		
		precedence();
	}
	
	public final void aci_authenticationLevel() throws RecognitionException, TokenStreamException {
		
		
		match(ID_authenticationLevel);
		{
		int _cnt586=0;
		_loop586:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt586>=1 ) { break _loop586; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt586++;
		} while (true);
		}
		authenticationLevel();
	}
	
	public final void aci_itemOrUserFirst() throws RecognitionException, TokenStreamException {
		
		
		match(ID_itemOrUserFirst);
		{
		int _cnt590=0;
		_loop590:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt590>=1 ) { break _loop590; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt590++;
		} while (true);
		}
		itemOrUserFirst();
	}
	
	public final void precedence() throws RecognitionException, TokenStreamException {
		
		
		match(ID_precedence);
		{
		int _cnt583=0;
		_loop583:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt583>=1 ) { break _loop583; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt583++;
		} while (true);
		}
		match(INTEGER);
	}
	
	public final void authenticationLevel() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_none:
		{
			match(ID_none);
			break;
		}
		case ID_simple:
		{
			match(ID_simple);
			break;
		}
		case ID_strong:
		{
			match(ID_strong);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void itemOrUserFirst() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_itemFirst:
		{
			itemFirst();
			break;
		}
		case ID_userFirst:
		{
			userFirst();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void itemFirst() throws RecognitionException, TokenStreamException {
		
		
		match(ID_itemFirst);
		{
		_loop594:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop594;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop596:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop596;
			}
			
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop598:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop598;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_protectedItems:
		{
			protectedItems();
			{
			_loop601:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop601;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop603:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop603;
				}
				
			} while (true);
			}
			itemPermissions();
			break;
		}
		case ID_itemPermissions:
		{
			itemPermissions();
			{
			_loop605:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop605;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop607:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop607;
				}
				
			} while (true);
			}
			protectedItems();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop609:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop609;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void userFirst() throws RecognitionException, TokenStreamException {
		
		
		match(ID_userFirst);
		{
		_loop612:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop612;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop614:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop614;
			}
			
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop616:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop616;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_userClasses:
		{
			userClasses();
			{
			_loop619:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop619;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop621:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop621;
				}
				
			} while (true);
			}
			userPermissions();
			break;
		}
		case ID_userPermissions:
		{
			userPermissions();
			{
			_loop623:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop623;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop625:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop625;
				}
				
			} while (true);
			}
			userClasses();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop627:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop627;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void protectedItems() throws RecognitionException, TokenStreamException {
		
		
		match(ID_protectedItems);
		{
		_loop630:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop630;
			}
			
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop632:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop632;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ATTRIBUTE_VALUE_CANDIDATE:
		case RANGE_OF_VALUES_CANDIDATE:
		case ID_entry:
		case ID_allUserAttributeTypes:
		case ID_attributeType:
		case ID_allAttributeValues:
		case ID_allUserAttributeTypesAndValues:
		case ID_selfValue:
		case ID_maxValueCount:
		case ID_maxImmSub:
		case ID_restrictedBy:
		case ID_classes:
		{
			protectedItem();
			{
			_loop635:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop635;
				}
				
			} while (true);
			}
			{
			_loop641:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop638:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop638;
						}
						
					} while (true);
					}
					protectedItem();
					{
					_loop640:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop640;
						}
						
					} while (true);
					}
				}
				else {
					break _loop641;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void itemPermissions() throws RecognitionException, TokenStreamException {
		
		
		match(ID_itemPermissions);
		{
		int _cnt746=0;
		_loop746:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt746>=1 ) { break _loop746; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt746++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop748:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop748;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case OPEN_CURLY:
		{
			itemPermission();
			{
			_loop751:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop751;
				}
				
			} while (true);
			}
			{
			_loop757:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop754:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop754;
						}
						
					} while (true);
					}
					itemPermission();
					{
					_loop756:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop756;
						}
						
					} while (true);
					}
				}
				else {
					break _loop757;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void userClasses() throws RecognitionException, TokenStreamException {
		
		
		match(ID_userClasses);
		{
		int _cnt787=0;
		_loop787:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt787>=1 ) { break _loop787; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt787++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop789:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop789;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_allUsers:
		case ID_thisEntry:
		case ID_name:
		case ID_userGroup:
		case ID_subtree:
		{
			userClass();
			{
			_loop792:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop792;
				}
				
			} while (true);
			}
			{
			_loop798:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop795:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop795;
						}
						
					} while (true);
					}
					userClass();
					{
					_loop797:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop797;
						}
						
					} while (true);
					}
				}
				else {
					break _loop798;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void userPermissions() throws RecognitionException, TokenStreamException {
		
		
		match(ID_userPermissions);
		{
		int _cnt843=0;
		_loop843:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt843>=1 ) { break _loop843; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt843++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop845:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop845;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case OPEN_CURLY:
		{
			userPermission();
			{
			_loop848:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop848;
				}
				
			} while (true);
			}
			{
			_loop854:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop851:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop851;
						}
						
					} while (true);
					}
					userPermission();
					{
					_loop853:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop853;
						}
						
					} while (true);
					}
				}
				else {
					break _loop854;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void protectedItem() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_entry:
		{
			entry();
			break;
		}
		case ID_allUserAttributeTypes:
		{
			allUserAttributeTypes();
			break;
		}
		case ID_attributeType:
		{
			attributeType();
			break;
		}
		case ID_allAttributeValues:
		{
			allAttributeValues();
			break;
		}
		case ID_allUserAttributeTypesAndValues:
		{
			allUserAttributeTypesAndValues();
			break;
		}
		case ATTRIBUTE_VALUE_CANDIDATE:
		{
			attributeValue();
			break;
		}
		case ID_selfValue:
		{
			selfValue();
			break;
		}
		case RANGE_OF_VALUES_CANDIDATE:
		{
			rangeOfValues();
			break;
		}
		case ID_maxValueCount:
		{
			maxValueCount();
			break;
		}
		case ID_maxImmSub:
		{
			maxImmSub();
			break;
		}
		case ID_restrictedBy:
		{
			restrictedBy();
			break;
		}
		case ID_classes:
		{
			classes();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void entry() throws RecognitionException, TokenStreamException {
		
		
		match(ID_entry);
	}
	
	public final void allUserAttributeTypes() throws RecognitionException, TokenStreamException {
		
		
		match(ID_allUserAttributeTypes);
	}
	
	public final void attributeType() throws RecognitionException, TokenStreamException {
		
		
		match(ID_attributeType);
		{
		int _cnt647=0;
		_loop647:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt647>=1 ) { break _loop647; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt647++;
		} while (true);
		}
		attributeTypeSet();
	}
	
	public final void allAttributeValues() throws RecognitionException, TokenStreamException {
		
		
		match(ID_allAttributeValues);
		{
		int _cnt650=0;
		_loop650:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt650>=1 ) { break _loop650; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt650++;
		} while (true);
		}
		attributeTypeSet();
	}
	
	public final void allUserAttributeTypesAndValues() throws RecognitionException, TokenStreamException {
		
		
		match(ID_allUserAttributeTypesAndValues);
	}
	
	public final void attributeValue() throws RecognitionException, TokenStreamException {
		
		
		match(ATTRIBUTE_VALUE_CANDIDATE);
	}
	
	public final void selfValue() throws RecognitionException, TokenStreamException {
		
		
		match(ID_selfValue);
		{
		int _cnt655=0;
		_loop655:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt655>=1 ) { break _loop655; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt655++;
		} while (true);
		}
		attributeTypeSet();
	}
	
	public final void rangeOfValues() throws RecognitionException, TokenStreamException {
		
		
		match(RANGE_OF_VALUES_CANDIDATE);
	}
	
	public final void maxValueCount() throws RecognitionException, TokenStreamException {
		
		
		match(ID_maxValueCount);
		{
		int _cnt659=0;
		_loop659:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt659>=1 ) { break _loop659; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt659++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop661:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop661;
			}
			
		} while (true);
		}
		aMaxValueCount();
		{
		_loop663:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop663;
			}
			
		} while (true);
		}
		{
		_loop669:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop666:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop666;
					}
					
				} while (true);
				}
				aMaxValueCount();
				{
				_loop668:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop668;
					}
					
				} while (true);
				}
			}
			else {
				break _loop669;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void maxImmSub() throws RecognitionException, TokenStreamException {
		
		
		match(ID_maxImmSub);
		{
		int _cnt694=0;
		_loop694:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt694>=1 ) { break _loop694; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt694++;
		} while (true);
		}
		match(INTEGER);
	}
	
	public final void restrictedBy() throws RecognitionException, TokenStreamException {
		
		
		match(ID_restrictedBy);
		{
		int _cnt697=0;
		_loop697:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt697>=1 ) { break _loop697; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt697++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop699:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop699;
			}
			
		} while (true);
		}
		restrictedValue();
		{
		_loop701:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop701;
			}
			
		} while (true);
		}
		{
		_loop707:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop704:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop704;
					}
					
				} while (true);
				}
				restrictedValue();
				{
				_loop706:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop706;
					}
					
				} while (true);
				}
			}
			else {
				break _loop707;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void classes() throws RecognitionException, TokenStreamException {
		
		
		match(ID_classes);
		{
		int _cnt743=0;
		_loop743:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt743>=1 ) { break _loop743; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt743++;
		} while (true);
		}
		refinement();
	}
	
	public final void attributeTypeSet() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop732:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop732;
			}
			
		} while (true);
		}
		oid();
		{
		_loop734:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop734;
			}
			
		} while (true);
		}
		{
		_loop740:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop737:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop737;
					}
					
				} while (true);
				}
				oid();
				{
				_loop739:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop739;
					}
					
				} while (true);
				}
			}
			else {
				break _loop740;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void aMaxValueCount() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop672:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop672;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_type:
		{
			match(ID_type);
			{
			int _cnt675=0;
			_loop675:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt675>=1 ) { break _loop675; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt675++;
			} while (true);
			}
			oid();
			{
			_loop677:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop677;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop679:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop679;
				}
				
			} while (true);
			}
			match(ID_maxCount);
			{
			int _cnt681=0;
			_loop681:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt681>=1 ) { break _loop681; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt681++;
			} while (true);
			}
			match(INTEGER);
			break;
		}
		case ID_maxCount:
		{
			match(ID_maxCount);
			{
			int _cnt683=0;
			_loop683:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt683>=1 ) { break _loop683; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt683++;
			} while (true);
			}
			match(INTEGER);
			{
			_loop685:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop685;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop687:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop687;
				}
				
			} while (true);
			}
			match(ID_type);
			{
			int _cnt689=0;
			_loop689:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt689>=1 ) { break _loop689; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt689++;
			} while (true);
			}
			oid();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop691:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop691;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void oid() throws RecognitionException, TokenStreamException {
		
		
		{
		switch ( LA(1)) {
		case DESCR:
		{
			match(DESCR);
			break;
		}
		case NUMERICOID:
		{
			match(NUMERICOID);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void restrictedValue() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop710:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop710;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_type:
		{
			match(ID_type);
			{
			int _cnt713=0;
			_loop713:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt713>=1 ) { break _loop713; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt713++;
			} while (true);
			}
			oid();
			{
			_loop715:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop715;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop717:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop717;
				}
				
			} while (true);
			}
			match(ID_valuesIn);
			{
			int _cnt719=0;
			_loop719:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt719>=1 ) { break _loop719; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt719++;
			} while (true);
			}
			oid();
			break;
		}
		case ID_valuesIn:
		{
			match(ID_valuesIn);
			{
			int _cnt721=0;
			_loop721:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt721>=1 ) { break _loop721; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt721++;
			} while (true);
			}
			oid();
			{
			_loop723:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop723;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop725:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop725;
				}
				
			} while (true);
			}
			match(ID_type);
			{
			int _cnt727=0;
			_loop727:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt727>=1 ) { break _loop727; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt727++;
			} while (true);
			}
			oid();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop729:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop729;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void refinement() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_item:
		{
			item();
			break;
		}
		case ID_and:
		{
			and();
			break;
		}
		case ID_or:
		{
			or();
			break;
		}
		case ID_not:
		{
			not();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void itemPermission() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop760:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop760;
			}
			
		} while (true);
		}
		anyItemPermission();
		{
		_loop762:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop762;
			}
			
		} while (true);
		}
		{
		_loop768:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop765:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop765;
					}
					
				} while (true);
				}
				anyItemPermission();
				{
				_loop767:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop767;
					}
					
				} while (true);
				}
			}
			else {
				break _loop768;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void anyItemPermission() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_precedence:
		{
			precedence();
			break;
		}
		case ID_userClasses:
		{
			userClasses();
			break;
		}
		case ID_grantsAndDenials:
		{
			grantsAndDenials();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void grantsAndDenials() throws RecognitionException, TokenStreamException {
		
		
		match(ID_grantsAndDenials);
		{
		int _cnt772=0;
		_loop772:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt772>=1 ) { break _loop772; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt772++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop774:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop774;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_grantAdd:
		case ID_denyAdd:
		case ID_grantDiscloseOnError:
		case ID_denyDiscloseOnError:
		case ID_grantRead:
		case ID_denyRead:
		case ID_grantRemove:
		case ID_denyRemove:
		case ID_grantBrowse:
		case ID_denyBrowse:
		case ID_grantExport:
		case ID_denyExport:
		case ID_grantImport:
		case ID_denyImport:
		case ID_grantModify:
		case ID_denyModify:
		case ID_grantRename:
		case ID_denyRename:
		case ID_grantReturnDN:
		case ID_denyReturnDN:
		case ID_grantCompare:
		case ID_denyCompare:
		case ID_grantFilterMatch:
		case ID_denyFilterMatch:
		case ID_grantInvoke:
		case ID_denyInvoke:
		{
			grantAndDenial();
			{
			_loop777:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop777;
				}
				
			} while (true);
			}
			{
			_loop783:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop780:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop780;
						}
						
					} while (true);
					}
					grantAndDenial();
					{
					_loop782:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop782;
						}
						
					} while (true);
					}
				}
				else {
					break _loop783;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void grantAndDenial() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_grantAdd:
		{
			match(ID_grantAdd);
			break;
		}
		case ID_denyAdd:
		{
			match(ID_denyAdd);
			break;
		}
		case ID_grantDiscloseOnError:
		{
			match(ID_grantDiscloseOnError);
			break;
		}
		case ID_denyDiscloseOnError:
		{
			match(ID_denyDiscloseOnError);
			break;
		}
		case ID_grantRead:
		{
			match(ID_grantRead);
			break;
		}
		case ID_denyRead:
		{
			match(ID_denyRead);
			break;
		}
		case ID_grantRemove:
		{
			match(ID_grantRemove);
			break;
		}
		case ID_denyRemove:
		{
			match(ID_denyRemove);
			break;
		}
		case ID_grantBrowse:
		{
			match(ID_grantBrowse);
			break;
		}
		case ID_denyBrowse:
		{
			match(ID_denyBrowse);
			break;
		}
		case ID_grantExport:
		{
			match(ID_grantExport);
			break;
		}
		case ID_denyExport:
		{
			match(ID_denyExport);
			break;
		}
		case ID_grantImport:
		{
			match(ID_grantImport);
			break;
		}
		case ID_denyImport:
		{
			match(ID_denyImport);
			break;
		}
		case ID_grantModify:
		{
			match(ID_grantModify);
			break;
		}
		case ID_denyModify:
		{
			match(ID_denyModify);
			break;
		}
		case ID_grantRename:
		{
			match(ID_grantRename);
			break;
		}
		case ID_denyRename:
		{
			match(ID_denyRename);
			break;
		}
		case ID_grantReturnDN:
		{
			match(ID_grantReturnDN);
			break;
		}
		case ID_denyReturnDN:
		{
			match(ID_denyReturnDN);
			break;
		}
		case ID_grantCompare:
		{
			match(ID_grantCompare);
			break;
		}
		case ID_denyCompare:
		{
			match(ID_denyCompare);
			break;
		}
		case ID_grantFilterMatch:
		{
			match(ID_grantFilterMatch);
			break;
		}
		case ID_denyFilterMatch:
		{
			match(ID_denyFilterMatch);
			break;
		}
		case ID_grantInvoke:
		{
			match(ID_grantInvoke);
			break;
		}
		case ID_denyInvoke:
		{
			match(ID_denyInvoke);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void userClass() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_allUsers:
		{
			allUsers();
			break;
		}
		case ID_thisEntry:
		{
			thisEntry();
			break;
		}
		case ID_name:
		{
			name();
			break;
		}
		case ID_userGroup:
		{
			userGroup();
			break;
		}
		case ID_subtree:
		{
			subtree();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void allUsers() throws RecognitionException, TokenStreamException {
		
		
		match(ID_allUsers);
	}
	
	public final void thisEntry() throws RecognitionException, TokenStreamException {
		
		
		match(ID_thisEntry);
	}
	
	public final void name() throws RecognitionException, TokenStreamException {
		
		
		match(ID_name);
		{
		int _cnt804=0;
		_loop804:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt804>=1 ) { break _loop804; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt804++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop806:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop806;
			}
			
		} while (true);
		}
		distinguishedName();
		{
		_loop808:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop808;
			}
			
		} while (true);
		}
		{
		_loop814:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop811:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop811;
					}
					
				} while (true);
				}
				distinguishedName();
				{
				_loop813:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop813;
					}
					
				} while (true);
				}
			}
			else {
				break _loop814;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void userGroup() throws RecognitionException, TokenStreamException {
		
		
		match(ID_userGroup);
		{
		int _cnt817=0;
		_loop817:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt817>=1 ) { break _loop817; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt817++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop819:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop819;
			}
			
		} while (true);
		}
		distinguishedName();
		{
		_loop821:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop821;
			}
			
		} while (true);
		}
		{
		_loop827:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop824:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop824;
					}
					
				} while (true);
				}
				distinguishedName();
				{
				_loop826:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop826;
					}
					
				} while (true);
				}
			}
			else {
				break _loop827;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void subtree() throws RecognitionException, TokenStreamException {
		
		
		match(ID_subtree);
		{
		int _cnt830=0;
		_loop830:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt830>=1 ) { break _loop830; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt830++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop832:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop832;
			}
			
		} while (true);
		}
		subtreeSpecification();
		{
		_loop834:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop834;
			}
			
		} while (true);
		}
		{
		_loop840:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop837:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop837;
					}
					
				} while (true);
				}
				subtreeSpecification();
				{
				_loop839:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop839;
					}
					
				} while (true);
				}
			}
			else {
				break _loop840;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void distinguishedName() throws RecognitionException, TokenStreamException {
		
		
		match(SAFEUTF8STRING);
	}
	
	public final void subtreeSpecification() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop869:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop869;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_base:
		case ID_specificExclusions:
		case ID_minimum:
		case ID_maximum:
		{
			subtreeSpecificationComponent();
			{
			_loop872:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop872;
				}
				
			} while (true);
			}
			{
			_loop878:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop875:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop875;
						}
						
					} while (true);
					}
					subtreeSpecificationComponent();
					{
					_loop877:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop877;
						}
						
					} while (true);
					}
				}
				else {
					break _loop878;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void userPermission() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop857:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop857;
			}
			
		} while (true);
		}
		anyUserPermission();
		{
		_loop859:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop859;
			}
			
		} while (true);
		}
		{
		_loop865:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop862:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop862;
					}
					
				} while (true);
				}
				anyUserPermission();
				{
				_loop864:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop864;
					}
					
				} while (true);
				}
			}
			else {
				break _loop865;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void anyUserPermission() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_precedence:
		{
			precedence();
			break;
		}
		case ID_protectedItems:
		{
			protectedItems();
			break;
		}
		case ID_grantsAndDenials:
		{
			grantsAndDenials();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void subtreeSpecificationComponent() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_base:
		{
			ss_base();
			break;
		}
		case ID_specificExclusions:
		{
			ss_specificExclusions();
			break;
		}
		case ID_minimum:
		{
			ss_minimum();
			break;
		}
		case ID_maximum:
		{
			ss_maximum();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void ss_base() throws RecognitionException, TokenStreamException {
		
		
		match(ID_base);
		{
		int _cnt882=0;
		_loop882:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt882>=1 ) { break _loop882; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt882++;
		} while (true);
		}
		distinguishedName();
	}
	
	public final void ss_specificExclusions() throws RecognitionException, TokenStreamException {
		
		
		match(ID_specificExclusions);
		{
		int _cnt885=0;
		_loop885:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt885>=1 ) { break _loop885; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt885++;
		} while (true);
		}
		specificExclusions();
	}
	
	public final void ss_minimum() throws RecognitionException, TokenStreamException {
		
		
		match(ID_minimum);
		{
		int _cnt911=0;
		_loop911:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt911>=1 ) { break _loop911; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt911++;
		} while (true);
		}
		baseDistance();
	}
	
	public final void ss_maximum() throws RecognitionException, TokenStreamException {
		
		
		match(ID_maximum);
		{
		int _cnt914=0;
		_loop914:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt914>=1 ) { break _loop914; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt914++;
		} while (true);
		}
		baseDistance();
	}
	
	public final void specificExclusions() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop888:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop888;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_chopBefore:
		case ID_chopAfter:
		{
			specificExclusion();
			{
			_loop891:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop891;
				}
				
			} while (true);
			}
			{
			_loop897:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop894:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop894;
						}
						
					} while (true);
					}
					specificExclusion();
					{
					_loop896:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop896;
						}
						
					} while (true);
					}
				}
				else {
					break _loop897;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void specificExclusion() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_chopBefore:
		{
			chopBefore();
			break;
		}
		case ID_chopAfter:
		{
			chopAfter();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void chopBefore() throws RecognitionException, TokenStreamException {
		
		
		match(ID_chopBefore);
		{
		_loop901:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop901;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop903:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop903;
			}
			
		} while (true);
		}
		distinguishedName();
	}
	
	public final void chopAfter() throws RecognitionException, TokenStreamException {
		
		
		match(ID_chopAfter);
		{
		_loop906:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop906;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop908:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop908;
			}
			
		} while (true);
		}
		distinguishedName();
	}
	
	public final void baseDistance() throws RecognitionException, TokenStreamException {
		
		
		match(INTEGER);
	}
	
	public final void item() throws RecognitionException, TokenStreamException {
		
		
		match(ID_item);
		{
		_loop922:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop922;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop924:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop924;
			}
			
		} while (true);
		}
		oid();
	}
	
	public final void and() throws RecognitionException, TokenStreamException {
		
		
		match(ID_and);
		{
		_loop927:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop927;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop929:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop929;
			}
			
		} while (true);
		}
		refinements();
	}
	
	public final void or() throws RecognitionException, TokenStreamException {
		
		
		match(ID_or);
		{
		_loop932:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop932;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop934:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop934;
			}
			
		} while (true);
		}
		refinements();
	}
	
	public final void not() throws RecognitionException, TokenStreamException {
		
		
		match(ID_not);
		{
		_loop937:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop937;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop939:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop939;
			}
			
		} while (true);
		}
		refinements();
	}
	
	public final void refinements() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop942:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop942;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_item:
		case ID_and:
		case ID_or:
		case ID_not:
		{
			refinement();
			{
			_loop945:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop945;
				}
				
			} while (true);
			}
			{
			_loop951:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop948:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop948;
						}
						
					} while (true);
					}
					refinement();
					{
					_loop950:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop950;
						}
						
					} while (true);
					}
				}
				else {
					break _loop951;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"ATTRIBUTE_VALUE_CANDIDATE",
		"RANGE_OF_VALUES_CANDIDATE",
		"SP",
		"OPEN_CURLY",
		"SEP",
		"CLOSE_CURLY",
		"\"identificationTag\"",
		"SAFEUTF8STRING",
		"\"precedence\"",
		"INTEGER",
		"\"authenticationLevel\"",
		"\"none\"",
		"\"simple\"",
		"\"strong\"",
		"\"itemOrUserFirst\"",
		"\"itemFirst\"",
		"COLON",
		"\"userFirst\"",
		"\"protectedItems\"",
		"\"entry\"",
		"\"allUserAttributeTypes\"",
		"\"attributeType\"",
		"\"allAttributeValues\"",
		"\"allUserAttributeTypesAndValues\"",
		"\"selfValue\"",
		"\"maxValueCount\"",
		"\"type\"",
		"\"maxCount\"",
		"\"maxImmSub\"",
		"\"restrictedBy\"",
		"\"valuesIn\"",
		"\"classes\"",
		"\"itemPermissions\"",
		"\"grantsAndDenials\"",
		"\"grantAdd\"",
		"\"denyAdd\"",
		"\"grantDiscloseOnError\"",
		"\"denyDiscloseOnError\"",
		"\"grantRead\"",
		"\"denyRead\"",
		"\"grantRemove\"",
		"\"denyRemove\"",
		"\"grantBrowse\"",
		"\"denyBrowse\"",
		"\"grantExport\"",
		"\"denyExport\"",
		"\"grantImport\"",
		"\"denyImport\"",
		"\"grantModify\"",
		"\"denyModify\"",
		"\"grantRename\"",
		"\"denyRename\"",
		"\"grantReturnDN\"",
		"\"denyReturnDN\"",
		"\"grantCompare\"",
		"\"denyCompare\"",
		"\"grantFilterMatch\"",
		"\"denyFilterMatch\"",
		"\"grantInvoke\"",
		"\"denyInvoke\"",
		"\"userClasses\"",
		"\"allUsers\"",
		"\"thisEntry\"",
		"\"name\"",
		"\"userGroup\"",
		"\"subtree\"",
		"\"userPermissions\"",
		"\"base\"",
		"\"specificExclusions\"",
		"\"chopBefore\"",
		"\"chopAfter\"",
		"\"minimum\"",
		"\"maximum\"",
		"DESCR",
		"NUMERICOID",
		"\"item\"",
		"\"and\"",
		"\"or\"",
		"\"not\"",
		"\"FALSE\"",
		"\"TRUE\"",
		"\"level\"",
		"\"basicLevels\"",
		"\"localQualifier\"",
		"\"signed\"",
		"\"rangeOfValues\"",
		"\"specificationFilter\"",
		"SAFEUTF8CHAR",
		"DIGIT",
		"LDIGIT",
		"ALPHA",
		"HYPHEN",
		"DOT",
		"INTEGER_OR_NUMERICOID",
		"FILTER",
		"FILTER_VALUE"
	};
	
	
	}
