/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */

package org.apache.directory.shared.ldap.trigger;


/**
 * An enumeration that represents change inducing LDAP operations.
 * 
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 * @version $Rev:$, $Date:$
 */
public class LdapOperation
{
    public static final LdapOperation MODIFY = new LdapOperation( "Modify" );

    public static final LdapOperation ADD = new LdapOperation( "Add" );

    public static final LdapOperation DELETE = new LdapOperation( "Delete" );

    public static final LdapOperation MODIFYDN = new LdapOperation( "ModifyDN" );
    
    public static final LdapOperation MODIFYDN_RENAME = new LdapOperation( "ModifyDN.Rename" );
    
    public static final LdapOperation MODIFYDN_EXPORT = new LdapOperation( "ModifyDN.Export" );
    
    public static final LdapOperation MODIFYDN_IMPORT = new LdapOperation( "ModifyDN.Import" );

    
    private final String name;


    private LdapOperation( String name )
    {
        this.name = name;
    }


    /**
     * Returns the name of this LDAP operation.
     */
    public String getName()
    {
        return name;
    }


    public String toString()
    {
        return name;
    }


    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    public int hashCode()
    {
        final int PRIME = 31;
        int result = 1;
        result = PRIME * result + ( ( name == null ) ? 0 : name.hashCode() );
        return result;
    }


    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals( Object obj )
    {
        if ( this == obj )
            return true;
        if ( obj == null )
            return false;
        if ( getClass() != obj.getClass() )
            return false;
        final LdapOperation other = ( LdapOperation ) obj;
        if ( name == null )
        {
            if ( other.name != null )
                return false;
        }
        else if ( !name.equals( other.name ) )
            return false;
        return true;
    }
    
}
