/*
 * (C) Copyright 2015 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Anahide Tchertchian
 */
package org.nuxeo.ecm.platform.test;

import java.io.IOException;

import org.junit.Test;

/**
 * Basic class for messages files translations.
 *
 * @since 7.3
 */
public class TranslationTestCase extends AbstractTranslationTestCase {

    /**
     * Useful for override.
     */
    protected String getEnTranslationsPath() {
        return "OSGI-INF/l10n/messages_en_US.properties";
    }

    @Test
    public void testTranslationsLoading() throws IOException {
        checkFormat(getEnTranslationsPath());
    }

    @Test
    public void testTranslationsDupes() throws IOException {
        checkDuplicates(getEnTranslationsPath());
    }

}
