/*
 * (C) Copyright 2006-2011 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     bstefanescu
 *
 * $Id$
 */

package org.nuxeo.ecm.core.api;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 */
public class WrappedException extends Exception {

    private static final long serialVersionUID = -8068323167952050687L;

    // the class name of the original exception
    private String className;

    private WrappedException(String message, WrappedException cause) {
        super(message, cause);
    }

    public String getClassName() {
        return className;
    }

    public boolean sameAs(String className) {
        return this.className == null ? className == null : this.className.equals(className);
    }

    /**
     * No need to wrap Exception since RMI is not supported anymore
     *
     * @deprecated since 5.6
     */
    @Deprecated
    @SuppressWarnings({ "ThrowableInstanceNeverThrown" })
    public static WrappedException wrap(Throwable t) {
        if (t == null) {
            return null;
        }
        if (t instanceof WrappedException) {
            return (WrappedException) t;
        }
        String exceptionClass = t.getClass().getName();
        String message = "Exception: " + exceptionClass + ". message: " + t.getMessage();
        WrappedException cause = wrap(t.getCause());
        WrappedException we = new WrappedException(message, cause);
        we.className = exceptionClass;
        we.setStackTrace(t.getStackTrace());
        return we;
    }

}
