/*
 * (C) Copyright 2006-2011 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Nuxeo - initial API and implementation
 *
 */

package org.nuxeo.ecm.core.api.blobholder;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterFactory;
import org.nuxeo.runtime.api.Framework;

/**
 * {@link DocumentModel} adapter factory. Delegates calls to the {@link BlobHolderAdapterService} that management the
 * pluggability for factories.
 *
 * @author tiry
 */
public class BlobHolderAdapterFactory implements DocumentAdapterFactory {

    protected static BlobHolderAdapterService bhas;

    protected BlobHolderAdapterService getService() {
        if (bhas == null) {
            bhas = Framework.getLocalService(BlobHolderAdapterService.class);
        }
        return bhas;
    }

    @Override
    public Object getAdapter(DocumentModel doc, Class itf) {
        return getService().getBlobHolderAdapter(doc);
    }

}
