/*
 * (C) Copyright 2006-2011 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     bstefanescu
 *
 * $Id$
 */

package org.nuxeo.ecm.core.api.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a> TODO is this really needed?
 */
public class PropertyDiff implements Iterable<PropertyDiff> {

    public static final int MODIFIED = 1;

    public static final int ADDED = 2;

    public static final int REMOVED = 3;

    public int type;

    public Serializable value;

    public String name;

    public final Set<PropertyDiff> children;

    public PropertyDiff(int type, String name) {
        this(type, name, null);
    }

    // FIXME: not fully implemented
    public PropertyDiff(int type, String name, Serializable value) {
        children = new HashSet<PropertyDiff>();
    }

    public boolean hasChildren() {
        return !children.isEmpty();
    }

    public void modify(String name, Serializable value) {
        children.add(new PropertyDiff(MODIFIED, name, value));
    }

    public void remove(String name) {
        children.add(new PropertyDiff(REMOVED, name));
    }

    public void add(String name, Serializable value) {
        children.add(new PropertyDiff(ADDED, name, value));
    }

    @Override
    public Iterator<PropertyDiff> iterator() {
        return children.iterator();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PropertyDiff) {
            return name.equals(((PropertyDiff) obj).name);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (name == null) ? 0 : name.hashCode();
    }

}
