/*
 * (C) Copyright 2014 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Anahide Tchertchian
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

/**
 * Phase listener that empties the map of widget ids generated by the layout system to avoid duplicate when process of
 * facelet handlers is done twice.
 * <p>
 * Process is done twice on ajax requests, when performing phase restore and then phase render response => empty the map
 * before rendering response.
 *
 * @since 6.0
 */
public class LayoutPhaseListener implements PhaseListener {

    private static final long serialVersionUID = 1L;

    @Override
    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    @Override
    public void beforePhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        NuxeoLayoutIdManagerBean bean = lookupIdBean(context);
        bean.resetIds();
    }

    protected static NuxeoLayoutIdManagerBean lookupIdBean(FacesContext ctx) {
        String expr = "#{" + NuxeoLayoutIdManagerBean.NAME + "}";
        NuxeoLayoutIdManagerBean bean = (NuxeoLayoutIdManagerBean) ctx.getApplication().evaluateExpressionGet(ctx,
                expr, Object.class);
        if (bean == null) {
            throw new RuntimeException("Managed bean not found: " + expr);
        }
        return bean;
    }

    @Override
    public void afterPhase(PhaseEvent event) {
    }

}
