package com.tngtech.jgiven.format.table;

import java.util.List;

/**
 * Formats the rows of a data table.
 * 
 * @see com.tngtech.jgiven.annotation.Table
 * @since 0.10.0
 */
public abstract class RowFormatter {

    /**
     * Generates the header row of the data table
     */
    public abstract List<String> header();

    /**
     * Generates a single row of the data table for the given object.
     * This method is called for each object of the input.
     */
    public abstract List<String> formatRow( Object object );

    /**
     * Allows for post processing the resulting data table.
     * The default implementation just returns the provided list
     * @param table the table that has been generated by calls to the {@link #header()} and the {@link #formatRow(Object)} methods
     * @return a potentially new table or just the passed table
     */
    public List<List<String>> postProcess( List<List<String>> table ) {
        return table;
    }
}
