/*
 * (C) Copyright 2006-2007 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Nuxeo - initial API and implementation
 *
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipInputStream;

/**
 * Wrapper used because some consumer (SAX parser) tend to close the stream
 *
 * @author <a href="mailto:tdelprat@nuxeo.com">Tiry</a>
 */
public class UnclosableZipInputStream extends ZipInputStream {

    public UnclosableZipInputStream(InputStream in) {
        super(in);
    }

    @Override
    public void close() throws IOException {
    }

    public void doClose() throws IOException {
        super.close();
    }
}
