/*
 * (C) Copyright 2016 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Gabriel Barata <gbarata@nuxeo.com>
 */
package org.nuxeo.ecm.platform.search.core;

/**
 * @since 8.3
 */
public class SavedSearchConstants {

    public static final String PARAMETERIZED_SAVED_SEARCH_TYPE_NAME = "SavedSearch";

    public static final String SAVED_SEARCH_FACET = "SavedSearch";

    public static final String TITLE_PROPERTY_NAME = "dc:title";

    public static final String NAMED_PARAMS_PROPERTY_NAME = "saved:namedParams";

    public static final String QUERY_PARAMS_PROPERTY_NAME = "saved:queryParams";

    public static final String QUERY_PROPERTY_NAME = "saved:query";

    public static final String QUERY_LANGUAGE_PROPERTY_NAME = "saved:queryLanguage";

    public static final String PAGE_PROVIDER_NAME_PROPERTY_NAME = "saved:providerName";

    public static final String PAGE_SIZE_PROPERTY_NAME = "saved:pageSize";

    public static final String CURRENT_PAGE_INDEX_PROPERTY_NAME = "saved:currentPageIndex";

    public static final String MAX_RESULTS_PROPERTY_NAME = "saved:maxResults";

    public static final String SORT_BY_PROPERTY_NAME = "saved:sortBy";

    public static final String SORT_ORDER_PROPERTY_NAME = "saved:sortOrder";

    public static final String CONTENT_VIEW_DATA_PROPERTY_NAME = "saved:contentViewData";

}
