/*
 * (C) Copyright 2014-2016 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Maxime Hilaire
 *     Thierry Martins
 *
 */
package org.nuxeo.ecm.core.cache;

/**
 * Nuxeo cache interface
 *
 * @since 6.0
 */
public interface CacheService {

    public static final String CACHE_TOPIC = "cache-topic";

    public static final String INVALIDATE_ALL = "invalidateAll";

    public Cache getCache(String name);

    /**
     * @since 8.2
     */
    public void registerCache(String name, int size, int timeout);
}
