/* Generated By:JJTree: Do not edit this line. AstValue.java */

package org.jboss.el.parser;

import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.PropertyNotFoundException;

import org.jboss.el.lang.EvaluationContext;
import org.jboss.el.util.MessageFactory;

/**
 * @author Jacob Hookom [jacob@hookom.net]
 * @version $Change: 181177 $$DateTime: 2001/06/26 08:45:09 $$Author: markt $
 */
public final class AstValue extends SimpleNode {
    
    protected static class Target {
        protected Object base;
        protected ValueSuffixNode node;
    }
    
    public AstValue(int id) {
        super(id);
    }
    
    public Class getType(EvaluationContext ctx) throws ELException {
        Target t = getTarget(ctx);
        return t.node.getType(t.base, ctx);
    }
    
    private final Target getTarget(EvaluationContext ctx) throws ELException {
        // evaluate expr-a to value-a
        Object base = this.children[0].getValue(ctx);
        
        // if our base is null (we know there are more properites to evaluate)
        if (base == null) {
            throw new PropertyNotFoundException(MessageFactory.get(
                    "error.unreachable.base", this.children[0].getImage()));
        }
        
        // set up our start/end
        int propCount = this.jjtGetNumChildren() - 1;
        int i = 1;
        
        while (base != null && i < propCount) {
            base = ((ValueSuffixNode) this.children[i]).getTarget(base, ctx);
            i++;
            
            if (base == null) {
                throw new PropertyNotFoundException(MessageFactory.get(
                        "error.unreachable.base", this.children[0].getImage()));
            }
        }
        
        Target t = new Target();
        t.base = base;
        t.node = (ValueSuffixNode) this.children[propCount];
        return t;
    }
    
    public Object getValue(EvaluationContext ctx) throws ELException {
        Object base = this.children[0].getValue(ctx);
        int propCount = this.jjtGetNumChildren();
        int i = 1;
        while (base != null && i < propCount) {
            base = ((ValueSuffixNode) this.children[i]).getValue(base, ctx);
            if (base == null) {
                return base;
            }
            i++;
        }
        return base;
    }
    
    public boolean isReadOnly(EvaluationContext ctx) throws ELException {
        Target t = getTarget(ctx);
        return t.node.isReadOnly(t.base, ctx);
    }
    
    public void setValue(EvaluationContext ctx, Object value)
    throws ELException {
        Target t = getTarget(ctx);
        t.node.setValue(t.base, ctx, value);
    }
    
    public MethodInfo getMethodInfo(EvaluationContext ctx, Class[] paramTypes)
    throws ELException {
        Target t = getTarget(ctx);
        return t.node.getMethodInfo(t.base, ctx, paramTypes);
    }
    
    public Object invoke(EvaluationContext ctx, Class[] paramTypes,
            Object[] paramValues) throws ELException {
        Target t = getTarget(ctx);
        return t.node.invoke(t.base, ctx, paramTypes, paramValues);
    }
}
