/*
 * (C) Copyright 2012 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     ataillefer
 */
package org.nuxeo.ecm.diff.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

/**
 * Diff display descriptor.
 *
 * @author <a href="mailto:ataillefer@nuxeo.com">Antoine Taillefer</a>
 * @since 5.6
 */
@XObject("diffDisplay")
public class DiffDisplayDescriptor {

    @XNode("@type")
    public String type;

    @XNode("@enabled")
    public boolean enabled = true;

    @XNodeList(value = "diffBlocks/diffBlock", type = ArrayList.class, componentType = DiffBlockReferenceDescriptor.class)
    public List<DiffBlockReferenceDescriptor> diffBlocks = new ArrayList<DiffBlockReferenceDescriptor>();

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<DiffBlockReferenceDescriptor> getDiffBlocks() {
        return diffBlocks;
    }

    public void setDiffBlocks(List<DiffBlockReferenceDescriptor> diffBlocks) {
        this.diffBlocks = diffBlocks;
    }
}
