/*
 * @(#)file      Proxy.java
 * @(#)author    Sun Microsystems, Inc.
 * @(#)version   1.25
 * @(#)date      07/10/01
 *
 * 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright (c) 2007 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU General
 * Public License Version 2 only ("GPL") or the Common Development and
 * Distribution License("CDDL")(collectively, the "License"). You may not use
 * this file except in compliance with the License. You can obtain a copy of the
 * License at http://opendmk.dev.java.net/legal_notices/licenses.txt or in the 
 * LEGAL_NOTICES folder that accompanied this code. See the License for the 
 * specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file found at
 *     http://opendmk.dev.java.net/legal_notices/licenses.txt
 * or in the LEGAL_NOTICES folder that accompanied this code.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.
 * 
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * 
 *       "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding
 * 
 *       "[Contributor] elects to include this software in this distribution
 *        under the [CDDL or GPL Version 2] license."
 * 
 * If you don't indicate a single choice of license, a recipient has the option
 * to distribute your version of this file under either the CDDL or the GPL
 * Version 2, or to extend the choice of license to its licensees as provided
 * above. However, if you add GPL Version 2 code and therefore, elected the
 * GPL Version 2 license, then the option applies only if the new code is made
 * subject to such option by the copyright holder.
 * 
 *
 */


package com.sun.jdmk;

// RI imports
//
import com.sun.jdmk.comm.RemoteMBeanServer ;
import javax.management.ObjectInstance ;

import javax.management.JMException ;
import javax.management.InstanceNotFoundException ;
import javax.management.ReflectionException ;
import javax.management.MBeanRegistrationException ;


/**
 * Interface common to all proxy objects manipulated by
 * a remote or local MBean manager. 
 *
 * It must be implemented by both proxy MBeans generated by ProxyGen
 * (from standard MBeans) and by <code>GenericProxy</code> objects.
 *
 * @deprecated MBean proxies should be generated using {@link
 * javax.management.MBeanServerInvocationHandler#newProxyInstance
 * MBeanServerInvocationHandler.newProxyInstance}.  The interface
 * <code>Proxy</code> may be removed in a
 * future version of Java DMK.
 *
 */
public interface Proxy {

    /**
     * Returns an ObjectInstance object that contains the object name (ObjectName object) 
     * and the class name of the remote MBean that this proxy MBean represents.
     *
     */
    public ObjectInstance getMBeanObjectInstance() ; 


    /**
     * Returns the server to which this proxy is bound.
     * It returns null if this proxy is not bound to any server (local or remote).
     */
    public ProxyHandler getServer();

    /**
     * Sets the server to which this proxy is bound.
     * It is allowed to set server null, that means no sever
     * is bound to the Proxy.
     */
    public void setServer(ProxyHandler server);

}
