/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.server.schema.registries.*;


/**
 * A producer of schema objectClass definations for the apachemeta schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 * @version $Rev$
 */
public class ApachemetaObjectClassProducer extends AbstractBootstrapProducer
{

    public ApachemetaObjectClassProducer()
    {
        super( ProducerTypeEnum.OBJECT_CLASS_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce(Registries, ProducerCallback)
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> array = new ArrayList<String>();
        BootstrapObjectClass objectClass;

        
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.0.3.1 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.0.3.1", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "Top level objectclass of all meta objects" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.ABSTRACT );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "m-oid" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "m-description" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "metaTop" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.0.3.1", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.0.3.2 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.0.3.2", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "meta definition of the objectclass object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "metaTop" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "m-oid" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "m-name" );
        array.add( "m-obsolete" );
        array.add( "m-supObjectClass" );
        array.add( "m-typeObjectClass" );
        array.add( "m-must" );
        array.add( "m-may" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "metaObjectClass" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.0.3.2", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.0.3.3 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.0.3.3", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "meta definition of the AttributeType object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "metaTop" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "m-name" );
        array.add( "m-obsolete" );
        array.add( "m-supAttributeType" );
        array.add( "m-equality" );
        array.add( "m-ordering" );
        array.add( "m-substr" );
        array.add( "m-syntax" );
        array.add( "m-singleValue" );
        array.add( "m-collective" );
        array.add( "m-noUserModification" );
        array.add( "m-usage" );
        array.add( "m-length" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "metaAttributeType" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.0.3.3", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.0.3.4 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.0.3.4", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "meta definition of the Syntax object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "metaTop" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "metaSyntax" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.0.3.4", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.0.3.5 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.0.3.5", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "meta definition of the MatchingRule object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "metaTop" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "m-syntax" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "m-name" );
        array.add( "m-obsolete" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "metaMatchingRule" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.0.3.5", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.0.3.6 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.0.3.6", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "meta definition of the DITStructureRule object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "m-ruleId" );
        array.add( "m-form" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "m-name" );
        array.add( "m-obsolete" );
        array.add( "m-supDITStructureRule" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "metaDITStructureRule" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.0.3.6", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.0.3.7 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.0.3.7", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "meta definition of the NameForm object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "metaTop" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "m-oc" );
        array.add( "m-must" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "m-name" );
        array.add( "m-obsolete" );
        array.add( "m-may" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "metaNameForm" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.0.3.7", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.0.3.8 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.0.3.8", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "meta definition of the MatchingRuleUse object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "metaTop" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "m-applies" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "m-name" );
        array.add( "m-obsolete" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "metaMatchingRuleUse" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.0.3.8", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.0.3.9 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.0.3.9", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "meta definition of the DITContentRule object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "metaTop" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "m-name" );
        array.add( "m-obsolete" );
        array.add( "m-aux" );
        array.add( "m-must" );
        array.add( "m-may" );
        array.add( "m-not" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "metaDITContentRule" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.0.3.9", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.0.3.10 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.0.3.10", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "meta definition of the SyntaxChecker object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "metaTop" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "m-fqcn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "m-bytecode" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "metaSyntaxChecker" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.0.3.10", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.0.3.11 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.0.3.11", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "A schema object under which meta schema definitions are found" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "m-disabled" );
        array.add( "m-dependencies" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "metaSchema" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.0.3.11", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.0.3.12 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.0.3.12", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "meta definition of a Normalizer object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "metaTop" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "m-fqcn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "m-bytecode" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "metaNormalizer" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.0.3.12", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.0.3.13 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.0.3.13", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "meta definition of a Comparator object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "metaTop" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "m-fqcn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "m-bytecode" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "metaComparator" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.0.3.13", objectClass );

    }
}
