/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.server.schema.registries.*;


/**
 * A producer of schema objectClass definations for the core schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 * @version $Rev$
 */
public class CoreObjectClassProducer extends AbstractBootstrapProducer
{

    public CoreObjectClassProducer()
    {
        super( ProducerTypeEnum.OBJECT_CLASS_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce(Registries, ProducerCallback)
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> array = new ArrayList<String>();
        BootstrapObjectClass objectClass;

        
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.2 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.2", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: a country" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "c" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "searchGuide" );
        array.add( "description" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "country" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.2", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.3 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.3", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: a locality" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "street" );
        array.add( "seeAlso" );
        array.add( "searchGuide" );
        array.add( "st" );
        array.add( "l" );
        array.add( "description" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "locality" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.3", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.4 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.4", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: an organization" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "o" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "userPassword" );
        array.add( "searchGuide" );
        array.add( "seeAlso" );
        array.add( "businessCategory" );
        array.add( "x121Address" );
        array.add( "registeredAddress" );
        array.add( "destinationIndicator" );
        array.add( "preferredDeliveryMethod" );
        array.add( "telexNumber" );
        array.add( "teletexTerminalIdentifier" );
        array.add( "telephoneNumber" );
        array.add( "internationaliSDNNumber" );
        array.add( "facsimileTelephoneNumber" );
        array.add( "street" );
        array.add( "postOfficeBox" );
        array.add( "postalCode" );
        array.add( "postalAddress" );
        array.add( "physicalDeliveryOfficeName" );
        array.add( "st" );
        array.add( "l" );
        array.add( "description" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "organization" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.4", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.5 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.5", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: an organizational unit" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "ou" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "userPassword" );
        array.add( "searchGuide" );
        array.add( "seeAlso" );
        array.add( "businessCategory" );
        array.add( "x121Address" );
        array.add( "registeredAddress" );
        array.add( "destinationIndicator" );
        array.add( "preferredDeliveryMethod" );
        array.add( "telexNumber" );
        array.add( "teletexTerminalIdentifier" );
        array.add( "telephoneNumber" );
        array.add( "internationaliSDNNumber" );
        array.add( "facsimileTelephoneNumber" );
        array.add( "street" );
        array.add( "postOfficeBox" );
        array.add( "postalCode" );
        array.add( "postalAddress" );
        array.add( "physicalDeliveryOfficeName" );
        array.add( "st" );
        array.add( "l" );
        array.add( "description" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "organizationalUnit" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.5", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.6 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.6", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: a person" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "sn" );
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "userPassword" );
        array.add( "telephoneNumber" );
        array.add( "seeAlso" );
        array.add( "description" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "person" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.6", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.7 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.7", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: an organizational person" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "person" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "title" );
        array.add( "x121Address" );
        array.add( "registeredAddress" );
        array.add( "destinationIndicator" );
        array.add( "preferredDeliveryMethod" );
        array.add( "telexNumber" );
        array.add( "teletexTerminalIdentifier" );
        array.add( "telephoneNumber" );
        array.add( "internationaliSDNNumber" );
        array.add( "facsimileTelephoneNumber" );
        array.add( "street" );
        array.add( "postOfficeBox" );
        array.add( "postalCode" );
        array.add( "postalAddress" );
        array.add( "physicalDeliveryOfficeName" );
        array.add( "ou" );
        array.add( "st" );
        array.add( "l" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "organizationalPerson" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.7", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.8 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.8", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: an organizational role" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "x121Address" );
        array.add( "registeredAddress" );
        array.add( "destinationIndicator" );
        array.add( "preferredDeliveryMethod" );
        array.add( "telexNumber" );
        array.add( "teletexTerminalIdentifier" );
        array.add( "telephoneNumber" );
        array.add( "internationaliSDNNumber" );
        array.add( "facsimileTelephoneNumber" );
        array.add( "seeAlso" );
        array.add( "roleOccupant" );
        array.add( "preferredDeliveryMethod" );
        array.add( "street" );
        array.add( "postOfficeBox" );
        array.add( "postalCode" );
        array.add( "postalAddress" );
        array.add( "physicalDeliveryOfficeName" );
        array.add( "ou" );
        array.add( "st" );
        array.add( "l" );
        array.add( "description" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "organizationalRole" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.8", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.9 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.9", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: a group of names (DNs)" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "member" );
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "businessCategory" );
        array.add( "seeAlso" );
        array.add( "owner" );
        array.add( "ou" );
        array.add( "o" );
        array.add( "description" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "groupOfNames" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.9", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.10 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.10", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: an residential person" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "person" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "l" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "businessCategory" );
        array.add( "x121Address" );
        array.add( "registeredAddress" );
        array.add( "destinationIndicator" );
        array.add( "preferredDeliveryMethod" );
        array.add( "telexNumber" );
        array.add( "teletexTerminalIdentifier" );
        array.add( "telephoneNumber" );
        array.add( "internationaliSDNNumber" );
        array.add( "facsimileTelephoneNumber" );
        array.add( "preferredDeliveryMethod" );
        array.add( "street" );
        array.add( "postOfficeBox" );
        array.add( "postalCode" );
        array.add( "postalAddress" );
        array.add( "physicalDeliveryOfficeName" );
        array.add( "st" );
        array.add( "l" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "residentialPerson" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.10", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.11 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.11", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: an application process" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "seeAlso" );
        array.add( "ou" );
        array.add( "l" );
        array.add( "description" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "applicationProcess" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.11", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.12 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.12", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: an application entity" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "presentationAddress" );
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "supportedApplicationContext" );
        array.add( "seeAlso" );
        array.add( "ou" );
        array.add( "o" );
        array.add( "l" );
        array.add( "description" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "applicationEntity" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.12", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.13 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.13", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: a directory system agent (a server)" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "applicationEntity" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "knowledgeInformation" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "dSA" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.13", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.14 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.14", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: a device" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "serialNumber" );
        array.add( "seeAlso" );
        array.add( "owner" );
        array.add( "ou" );
        array.add( "o" );
        array.add( "l" );
        array.add( "description" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "device" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.14", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.15 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.15", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: a strong authentication user" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "userCertificate" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "strongAuthenticationUser" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.15", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.16 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.16", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: a certificate authority" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "authorityRevocationList" );
        array.add( "certificateRevocationList" );
        array.add( "cACertificate" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "crossCertificatePair" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "certificationAuthority" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.16", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.17 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.17", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: a group of unique names (DN and Unique Identifier)" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "uniqueMember" );
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "businessCategory" );
        array.add( "seeAlso" );
        array.add( "owner" );
        array.add( "ou" );
        array.add( "o" );
        array.add( "description" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "groupOfUniqueNames" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.17", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.18 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.18", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2256: a user security information" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "supportedAlgorithms" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "userSecurityInformation" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.18", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.16.2 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.16.2", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "certificationAuthority" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "deltaRevocationList" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "certificationAuthority-V2" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.16.2", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.19 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.19", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "certificateRevocationList" );
        array.add( "authorityRevocationList" );
        array.add( "deltaRevocationList" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "cRLDistributionPoint" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.19", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.20 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.20", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "dmdName" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "userPassword" );
        array.add( "searchGuide" );
        array.add( "seeAlso" );
        array.add( "businessCategory" );
        array.add( "x121Address" );
        array.add( "registeredAddress" );
        array.add( "destinationIndicator" );
        array.add( "preferredDeliveryMethod" );
        array.add( "telexNumber" );
        array.add( "teletexTerminalIdentifier" );
        array.add( "telephoneNumber" );
        array.add( "internationaliSDNNumber" );
        array.add( "facsimileTelephoneNumber" );
        array.add( "street" );
        array.add( "postOfficeBox" );
        array.add( "postalCode" );
        array.add( "postalAddress" );
        array.add( "physicalDeliveryOfficeName" );
        array.add( "st" );
        array.add( "l" );
        array.add( "description" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "dmd" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.20", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.21 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.21", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2587: a PKI user" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "userCertificate" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "pkiUser" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.21", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.22 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.22", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2587: PKI certificate authority" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "authorityRevocationList" );
        array.add( "certificateRevocationList" );
        array.add( "cACertificate" );
        array.add( "crossCertificatePair" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "pkiCA" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.22", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 2.5.6.23 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.5.6.23", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2587: PKI user" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "deltaRevocationList" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "deltaCRL" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.6.23", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.250.3.15 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.250.3.15", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2079: object that contains the URI attribute type" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "labeledURI" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "labeledURIObject" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.250.3.15", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 0.9.2342.19200300.100.4.19 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "0.9.2342.19200300.100.4.19", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC1274: simple security object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "userPassword" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "simpleSecurityObject" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.4.19", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.1466.344 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.1466.344", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2247: domain component object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "dc" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "dcObject" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.1466.344", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.1.3.1 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.1.3.1", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2377: uid object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "uid" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "uidObject" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.3.1", objectClass );

    }
}
