/**
 * Copyright (C) 2011-2015 The XDocReport Team <xdocreport@googlegroups.com>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free  of charge, to any person obtaining
 * a  copy  of this  software  and  associated  documentation files  (the
 * "Software"), to  deal in  the Software without  restriction, including
 * without limitation  the rights to  use, copy, modify,  merge, publish,
 * distribute,  sublicense, and/or sell  copies of  the Software,  and to
 * permit persons to whom the Software  is furnished to do so, subject to
 * the following conditions:
 *
 * The  above  copyright  notice  and  this permission  notice  shall  be
 * included in all copies or substantial portions of the Software.
 *
 * THE  SOFTWARE IS  PROVIDED  "AS  IS", WITHOUT  WARRANTY  OF ANY  KIND,
 * EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF
 * MERCHANTABILITY,    FITNESS    FOR    A   PARTICULAR    PURPOSE    AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE,  ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package fr.opensagres.xdocreport.remoting.resources.services.jaxws;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;

import fr.opensagres.xdocreport.remoting.resources.services.ResourcesService;

/**
 * This class was generated by Apache CXF 2.6.1
 * 2012-06-11T23:09:18.718+02:00
 * Generated source version: 2.6.1
 * 
 */
@WebService(targetNamespace = "http://ws.services.resources.remoting.xdocreport.opensagres.fr/", name = "JAXWSResourcesService")
@XmlSeeAlso({fr.opensagres.xdocreport.remoting.resources.domain.ObjectFactory.class})
public interface JAXWSResourcesService extends ResourcesService {

    @SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
    @WebMethod
    public void upload(
        @WebParam(partName = "content", name = "content", targetNamespace = "http://domain.resources.remoting.xdocreport.opensagres.fr/")
        fr.opensagres.xdocreport.remoting.resources.domain.BinaryData content
    );

    @SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
    @WebResult(name = "resource", targetNamespace = "http://domain.resources.remoting.xdocreport.opensagres.fr/", partName = "resource")
    @WebMethod(action = "getRoot")
    public fr.opensagres.xdocreport.remoting.resources.domain.Resource getRoot();

    @WebResult(name = "return", targetNamespace = "")
    @RequestWrapper(localName = "downloadMultiple", targetNamespace = "http://domain.resources.remoting.xdocreport.opensagres.fr/", className = "fr.opensagres.xdocreport.remoting.resources.domain.DownloadMultiple")
    @WebMethod
    @ResponseWrapper(localName = "downloadMultipleResponse", targetNamespace = "http://domain.resources.remoting.xdocreport.opensagres.fr/", className = "fr.opensagres.xdocreport.remoting.resources.domain.DownloadMultipleResponse")
    public java.util.List<fr.opensagres.xdocreport.remoting.resources.domain.BinaryData> downloadMultiple(
        @WebParam(name = "resourceIds", targetNamespace = "")
        java.util.List<java.lang.String> resourceIds
    );

    @SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
    @WebResult(name = "parameters", targetNamespace = "http://domain.resources.remoting.xdocreport.opensagres.fr/", partName = "parameters")
    @WebMethod(action = "getName")
    public java.lang.String getName();

    @SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
    @WebResult(name = "parameters", targetNamespace = "", partName = "parameters")
    @WebMethod
    public fr.opensagres.xdocreport.remoting.resources.domain.BinaryData download(
        @WebParam(partName = "resourceId", name = "resourceId", targetNamespace = "http://domain.resources.remoting.xdocreport.opensagres.fr/")
        java.lang.String resourceId
    );

    @SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
    @WebResult(name = "resource", targetNamespace = "http://domain.resources.remoting.xdocreport.opensagres.fr/", partName = "resource")
    @WebMethod
    public fr.opensagres.xdocreport.remoting.resources.domain.Resource getRootWithFilter(
        @WebParam(partName = "filter", name = "filter", targetNamespace = "http://domain.resources.remoting.xdocreport.opensagres.fr/")
        fr.opensagres.xdocreport.remoting.resources.domain.Filter filter
    );
}
