/*
 * (C) Copyright 2006-2015 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Nuxeo - initial API and implementation
 *
 */
package org.nuxeo.ecm.platform.picture.magick;

import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.runtime.api.Framework;

/**
 * Helper class to execute an ImageMagic command. Depends on the {@link CommandLineExecutorService} to run external
 * processes.
 *
 * @author tiry
 */
public class MagickExecutor {

    /**
     * @deprecated Since 7.4. Useless.
     */
    @Deprecated
    protected static ExecResult execCommand(String commandName, CmdParameters params) throws CommandNotAvailable {
        CommandLineExecutorService cles = Framework.getLocalService(CommandLineExecutorService.class);
        return cles.execCommand(commandName, params);
    }

    /**
     * @deprecated since 5.6. Quoting file paths is done by {@link CmdParameters}.
     */
    @Deprecated
    protected static String formatFilePath(String filePath) {
        return String.format("\"%s\"", filePath);
    }

}
